/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ChannelTransportConnection;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.iiop.Connection;
import com.ibm.wsspi.channel.base.OutboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;

public class ORBClientCallLink
extends OutboundApplicationLink
implements CallLink {
    private static final String CLASS = ORBClientCallLink.class.getName();
    private Connection conn;
    private GIOPConnectionContext connCtx = null;
    private ORBChannelHelper channelHelper;
    private int requestTimeout;
    private int reqId;
    private GIOPConnectionKey key;

    public ORBClientCallLink(VirtualConnection virtualConnection, ORBChannelHelper oRBChannelHelper) {
        this.init(virtualConnection);
        this.channelHelper = oRBChannelHelper;
    }

    protected void postConnectProcessing(VirtualConnection virtualConnection) {
        Trc.begin1(virtualConnection, CLASS, "postConnectProcessing:90");
        this.connCtx = (GIOPConnectionContext)this.getDeviceLink().getChannelAccessor();
        ChannelTransportConnection channelTransportConnection = new ChannelTransportConnection(this.channelHelper.getOrb(), this.connCtx, this.key);
        this.conn = new Connection(this.channelHelper.getOrb(), this.channelHelper.getGIOPImpl(), false);
        this.requestTimeout = this.channelHelper.getTimeout(this.conn.getORB().getRequestTimeout());
        Trc.info("Connection=", this.conn, ", local=", this.connCtx.getLocalHostName(), ":", Trc.str(this.connCtx.getLocalPort()), ", remote=", this.connCtx.getRemoteHost(), ":", Trc.str(this.connCtx.getRemotePort()), CLASS, "postConnectProcessing:104");
        this.conn.setContext(this, channelTransportConnection, this.connCtx);
        virtualConnection.getStateMap().put("Connection", this.conn);
        Trc.complete(CLASS, "postConnectProcessing:109");
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
    }

    public void destroy(Exception exception) {
    }

    public void setGIOPConnectionContext(GIOPConnectionContext gIOPConnectionContext) {
        this.connCtx = gIOPConnectionContext;
    }

    public GIOPConnectionContext getGIOPConnectionContext() {
        return this.connCtx;
    }

    public void processMessage(GIOPMessageContext gIOPMessageContext) {
        Trc.begin(CLASS, "processMessage:139");
        try {
            this.channelHelper.processCall(this.conn, this.connCtx, gIOPMessageContext, this, this.requestTimeout);
        }
        catch (Exception exception) {
            Trc.warn(exception, CLASS, "processMessage:146");
            this.connCtx.finishRequest(this.reqId);
        }
        gIOPMessageContext.release();
        Trc.complete(CLASS, "processMessage:153");
    }

    public void errorResponse(Exception exception) {
        Trc.warn(exception, CLASS, "errorResponse:160");
        this.conn.notifyErrorResponse(this.reqId, exception);
    }

    public void setRequestId(int n) {
        this.reqId = n;
    }

    public void connect(Object object) throws Exception {
        try {
            this.key = (GIOPConnectionKey)object;
        }
        catch (ClassCastException classCastException) {
            throw new Exception(classCastException.getMessage());
        }
        super.connect(object);
    }
}

