/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CancelRequestException;
import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionInfo;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPWriteCompletedCallback;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPServerChannel;
import com.ibm.rmi.channel.giop.GIOPServerLink;
import com.ibm.rmi.channel.giop.HeaderWalker;
import com.ibm.rmi.channel.giop.MessageReader;
import com.ibm.rmi.channel.giop.MessageWriter;
import com.ibm.rmi.channel.giop.RequestDataStore;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.ServerRequestImpl;
import com.ibm.rmi.iiop.ServiceContextList;
import com.ibm.rmi.iiop.TransportService;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

public class GIOPConnection
extends RequestDataStore
implements GIOPConnectionContext {
    private static final String CLASS = GIOPConnection.class.getName();
    private static final boolean SERVER = true;
    private static final boolean CLIENT = false;
    private ORB orb;
    private final boolean isServer;
    private VirtualConnection virtualConnection;
    private String theParameterString;
    private TCPConnectionContext devConnectionContext;
    private MessageReader readRequestContext;
    private MessageWriter writeRequestContext;
    private Connection conn;
    private GIOPMessageContext firstMessage;
    private ConnectionLink connLink;
    private HeaderWalker walker = null;
    private RequestIdGenerator requestIds = new RequestIdGenerator();
    private GIOPChannelPlugin giopPlugin;
    private final Object WRITE_LOCK = new String("WRITE_LOCK");
    private boolean writeInProgress = false;
    private String serverChannelName;
    private static final long serialVersionUID = 0L;

    public int nextRequestId() {
        int n = 0;
        if (n == 0) {
            n = this.requestIds.getNext();
        }
        return n;
    }

    public GIOPConnection(VirtualConnection virtualConnection, ConnectionLink connectionLink, Connection connection, TransportConnection transportConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, TCPConnectionContext tCPConnectionContext) {
        this(virtualConnection, connectionLink, connection, transportConnection, gIOPChannelConfig, gIOPChannelPlugin, tCPConnectionContext, null, false);
    }

    public GIOPConnection(VirtualConnection virtualConnection, ConnectionLink connectionLink, Connection connection, TransportConnection transportConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, TCPConnectionContext tCPConnectionContext, String string) {
        this(virtualConnection, connectionLink, connection, transportConnection, gIOPChannelConfig, gIOPChannelPlugin, tCPConnectionContext, string, true);
        GIOPServerChannel gIOPServerChannel = ((GIOPServerLink)connectionLink).getChannel();
        this.serverChannelName = gIOPServerChannel.getChannelName();
    }

    public GIOPConnection(VirtualConnection virtualConnection, ConnectionLink connectionLink, Connection connection, TransportConnection transportConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, TCPConnectionContext tCPConnectionContext, String string, boolean bl) {
        this.virtualConnection = virtualConnection;
        this.connLink = connectionLink;
        this.conn = connection;
        this.devConnectionContext = tCPConnectionContext;
        this.giopPlugin = gIOPChannelPlugin;
        this.readRequestContext = new MessageReader(virtualConnection, transportConnection, tCPConnectionContext.getReadInterface(), this, gIOPChannelConfig, gIOPChannelPlugin, string, bl);
        this.writeRequestContext = new MessageWriter(virtualConnection, transportConnection, tCPConnectionContext.getWriteInterface(), this, gIOPChannelConfig, gIOPChannelPlugin);
        this.isServer = bl;
        this.orb = gIOPChannelConfig.getOrb();
    }

    protected void updateActivityIndicator() {
        this.conn.updateTimeStamp();
    }

    protected ConnectionLink getConnectionLink() {
        return this.connLink;
    }

    public VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
        throw new UnsupportedOperationException("Async read should not be called directly");
    }

    public TCPReadRequestContext getReadInterface() {
        return this.readRequestContext;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writeRequestContext;
    }

    public InetAddress getRemoteAddress() {
        return this.devConnectionContext.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.devConnectionContext.getRemotePort();
    }

    public InetAddress getLocalAddress() {
        return this.devConnectionContext.getLocalAddress();
    }

    public int getLocalPort() {
        return this.devConnectionContext.getLocalPort();
    }

    public SSLConnectionContext getSSLContext() {
        return this.devConnectionContext.getSSLContext();
    }

    public String getLocalHostName() {
        return this.devConnectionContext.getLocalAddress().getHostName();
    }

    public String getLocalHost() {
        return this.devConnectionContext.getLocalAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.devConnectionContext.getRemoteAddress().getHostAddress();
    }

    public String getRemoteHostName() {
        return this.devConnectionContext.getRemoteAddress().getHostName();
    }

    public void preWrite(boolean bl) {
    }

    public void preReply() {
    }

    protected void setFirstMessage(GIOPMessageContext gIOPMessageContext) {
        this.firstMessage = gIOPMessageContext;
    }

    public GIOPMessageContext getFirstMessage() {
        return this.firstMessage;
    }

    public void writeMessage(CallLink callLink, GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        this.updateActivityIndicator();
        this.writeRequestContext.writeMessage(callLink, gIOPMessageContext, n);
    }

    public VirtualConnection writeMessage(CallLink callLink, GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        this.updateActivityIndicator();
        VirtualConnection virtualConnection = this.writeRequestContext.writeMessage(callLink, gIOPMessageContext, gIOPWriteCompletedCallback, bl, n);
        return virtualConnection;
    }

    public GIOPConnectionInfo getGIOPConnectionInfo() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Exception exception) {
        this.conn.abortConnection();
        this.connLink.close(this.virtualConnection, exception);
        try {
            TransportService transportService = (TransportService)this.orb.getTransport();
            try {
                transportService.getConnectionTable().removeConnection(this.conn);
            }
            catch (Exception exception2) {
                Trc.ffdc(exception2, CLASS, "closeConnection:385");
            }
        }
        catch (Exception exception3) {
            Trc.info(exception.getMessage(), CLASS, "closeConnection:390");
        }
        finally {
            this.giopPlugin.routeCloseConnection(this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainPermissionToWrite() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            while (!this.virtualConnection.requestPermissionToWrite()) {
                if (this.isClosed()) {
                    Trc.info("Connection closed", CLASS, "obtainPermissionToWrite:403");
                    throw new IOException("Connection is closed");
                }
                try {
                    Trc.info("Waiting ...", CLASS, "obtainPermissionToWrite:408");
                    this.WRITE_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Trc.info("Permission obtained", CLASS, "obtainPermissionToWrite:413");
            this.writeInProgress = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relinquishPermissionToWrite() {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.writeInProgress = false;
            this.virtualConnection.setWriteStateToDone();
            Trc.info("Relinquishing permission", CLASS, "relinquishPermissionToWrite:425");
            this.WRITE_LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPermissionToClose(Exception exception) {
        Trc.info(this, CLASS, "waitForPermissionToClose:438");
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            if (!this.isClosed()) {
                Trc.ffdc("Connection is not marked as being closed!", CLASS, "waitForPermissionToClose:447");
            }
            Trc.info("Notifying all threads waiting to write", CLASS, "waitForPermissionToClose:454");
            this.WRITE_LOCK.notifyAll();
            while (this.writeInProgress) {
                try {
                    Trc.info("Waiting for write in progress", CLASS, "waitForPermissionToClose:460");
                    this.WRITE_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Trc.info("Requestiong close permission", CLASS, "waitForPermissionToClose:467");
            boolean bl = this.virtualConnection.requestPermissionToClose(5000L);
            Trc.info("Close permission ", bl ? "granted" : "denied", CLASS, "waitForPermissionToClose:473");
        }
    }

    public String toString() {
        if (this.theParameterString == null) {
            int n;
            int n2;
            String string;
            String string2 = this.getClass().getName();
            int n3 = string2.lastIndexOf(".");
            String string3 = string2.substring(n3 + 1);
            try {
                string = this.getRemoteHost();
                n2 = this.getRemotePort();
                n = this.getLocalPort();
            }
            catch (NullPointerException nullPointerException) {
                this.theParameterString = string3 + " connection may have already closed down ";
                return this.theParameterString;
            }
            this.theParameterString = string3 + "[addr=" + string + ",port=" + n2 + ",local=" + n + "]";
        }
        return this.theParameterString;
    }

    private IIOPOutputStream prepareExceptionResponse(Exception exception, GIOPMessageContext gIOPMessageContext) throws IOException {
        IIOPInputStream iIOPInputStream;
        Message message = (Message)gIOPMessageContext.getMessage();
        GIOPMessageContextBase gIOPMessageContextBase = (GIOPMessageContextBase)gIOPMessageContext;
        try {
            iIOPInputStream = this.conn.getStreamObject(WsByteBufferUtils.asByteArray((WsByteBuffer[])gIOPMessageContextBase.getMessageBody()), 0, message);
        }
        catch (Exception exception2) {
            throw new IOException(exception2.toString());
        }
        ServerRequestImpl serverRequestImpl = (ServerRequestImpl)iIOPInputStream;
        UNKNOWN uNKNOWN = new UNKNOWN("proxy exception", 1229126404, CompletionStatus.COMPLETED_NO);
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)((Object)serverRequestImpl.createSystemExceptionResponse((SystemException)uNKNOWN));
        Trc.info("prepare ", exception, " for msg ", message, " in ", iIOPOutputStream, CLASS, "prepareExceptionResponse:534");
        return iIOPOutputStream;
    }

    public VirtualConnection sendExceptionResponse(Exception exception, GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, IOException, UnsupportedOperationException {
        VirtualConnection virtualConnection;
        if (!this.isServer) {
            throw new UnsupportedOperationException("sendExceptionResponse is not allowed for Client");
        }
        if (!gIOPMessageContext.isResponseExpected()) {
            throw new UnsupportedOperationException("Message is not expecting a response");
        }
        IIOPOutputStream iIOPOutputStream = this.prepareExceptionResponse(exception, gIOPMessageContext);
        GIOPMessageContextBase gIOPMessageContextBase = (GIOPMessageContextBase)gIOPMessageContext;
        gIOPMessageContextBase.setExceptionResponse(iIOPOutputStream);
        try {
            virtualConnection = iIOPOutputStream.writeAsyncExceptionResponse(this, gIOPWriteCompletedCallback, bl, n);
        }
        catch (Exception exception2) {
            throw new IOException(exception2.toString());
        }
        return virtualConnection;
    }

    public void sendExceptionResponse(Exception exception, GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, IOException, UnsupportedOperationException {
        if (!this.isServer) {
            throw new UnsupportedOperationException("sendExceptionResponse is not allowed for Client");
        }
        if (!gIOPMessageContext.isResponseExpected()) {
            throw new UnsupportedOperationException("Message is not expecting a response");
        }
        IIOPOutputStream iIOPOutputStream = this.prepareExceptionResponse(exception, gIOPMessageContext);
        try {
            iIOPOutputStream.writeTo(null, this);
            iIOPOutputStream.releaseBuffer();
        }
        catch (Exception exception2) {
            throw new IOException(exception2.toString());
        }
    }

    public VirtualConnection getVirtualConnection() {
        return this.virtualConnection;
    }

    public WsByteBuffer[] getNextFragment(int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        return this.giopPlugin.getNextFragment(this, n);
    }

    public void finishRequest(int n) {
        this.giopPlugin.finishRequest(this, n);
    }

    HeaderWalker getHeaderWalker() {
        if (this.walker == null) {
            this.walker = new HeaderWalker();
        }
        return this.walker;
    }

    public Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(this.getClass().getName());
    }

    protected boolean isServer() {
        return this.isServer;
    }

    public void writeMessage(GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        this.writeMessage(null, gIOPMessageContext, n);
    }

    public VirtualConnection writeMessage(GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        return this.writeMessage(null, gIOPWriteCompletedCallback, bl, n);
    }

    public synchronized void consumeServiceContexts(GIOPMessageContext gIOPMessageContext) {
        ServiceContextList serviceContextList = (ServiceContextList)gIOPMessageContext.getServiceContexts();
        if (this.isServer) {
            this.consumeForServer(serviceContextList);
        } else {
            this.consumeForClient(serviceContextList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void consumeCodeSets(ServiceContext serviceContext) {
        byte[] byArray = serviceContext.getContextData();
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)this.orb, byArray, byArray.length);
        cDRInputStream.consumeEndian();
        CodeSetComponentInfo.CodeSetContext codeSetContext = new CodeSetComponentInfo.CodeSetContext();
        codeSetContext.read(cDRInputStream);
        int n = codeSetContext.getCharCodeSet();
        int n2 = codeSetContext.getWCharCodeSet();
        Trc.info("CODE_SETS ", "char_data=0x", Trc.hex(n), " wchar_data=0x", Trc.hex(n2), CLASS, "consumeCodeSets:673");
        CodeSetComponentInfo codeSetComponentInfo = (CodeSetComponentInfo)this.conn.getCodeSetComponentInfo();
        if (!codeSetComponentInfo.validate(codeSetContext)) {
            if (n != 65537 || this.conn == null || this.conn.getCharCodeSet() != 0) throw new DATA_CONVERSION("CodeSetComponent 0x" + Utility.bytesToHexString(byArray) + " appears to be invalid.", 1229124488, CompletionStatus.COMPLETED_NO);
            Trc.info("Ignoring unexpected Latin-1 codeset", CLASS, "consumeCodeSets:686");
            return;
        } else {
            int n3 = this.conn.getCharCodeSet();
            int n4 = this.conn.getWCharCodeSet();
            if (n3 != 0 && n3 != n || n4 != 0 && n4 != n2) {
                throw new MARSHAL("Codeset has already been set.", 1229125859, CompletionStatus.COMPLETED_NO);
            }
            this.conn.setCodeSets(n, n2);
        }
    }

    private void consumeSendingContextRuntime(ServiceContext serviceContext) {
        byte[] byArray = serviceContext.getContextData();
        this.conn.setCodeBaseRefByteArray(byArray);
    }

    private void consumeIBMORBVersion(ServiceContext serviceContext) {
        byte[] byArray = serviceContext.getContextData();
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)this.orb, byArray, byArray.length);
        cDRInputStream.consumeEndian();
        short s = cDRInputStream.read_ushort();
        int n = cDRInputStream.read_ulong();
        short s2 = PartnerVersionUtil.unpackMajor(n);
        short s3 = PartnerVersionUtil.unpackMinor(n);
        Trc.info(Trc.str(s2), " (0x", Trc.hex(s2), "):", Trc.str(s3), ":", Trc.str(s), CLASS, "consumeIBMORBVersion:742");
        if (n == 0) {
            this.conn.setPartnerVersion(PartnerVersionUtil.getORB11(), (short)0, s);
        } else {
            this.conn.setPartnerVersion(s2, s3, s);
        }
    }

    private void consumeCustomMaxStreamFormat(ServiceContext serviceContext) {
        byte[] byArray = serviceContext.getContextData();
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)this.orb, byArray, byArray.length);
        cDRInputStream.consumeEndian();
        this.conn.setStreamFormatVersion(cDRInputStream.read_octet());
        Trc.info("RMICustomMaxStreamFormat=", Trc.str(this.conn.getStreamFormatVersion()), CLASS, "consumeCustomMaxStreamFormat:767");
    }

    public final void consumeForServer(ServiceContextList serviceContextList) {
        Trc.begin(CLASS, "consumeForServer:778");
        ServiceContext[] serviceContextArray = serviceContextList.get();
        block6: for (int i = 0; i < serviceContextArray.length; ++i) {
            switch (serviceContextArray[i].getId()) {
                case 1: {
                    this.consumeCodeSets(serviceContextArray[i]);
                    continue block6;
                }
                case 6: {
                    this.consumeSendingContextRuntime(serviceContextArray[i]);
                    continue block6;
                }
                case 1229081874: {
                    this.consumeIBMORBVersion(serviceContextArray[i]);
                    continue block6;
                }
                case 17: {
                    this.consumeCustomMaxStreamFormat(serviceContextArray[i]);
                }
            }
        }
        Trc.complete(CLASS, "consumeForServer:802");
    }

    public final void consumeForClient(ServiceContextList serviceContextList) {
        Trc.begin(CLASS, "consumeForClient:815");
        ServiceContext[] serviceContextArray = serviceContextList.get();
        block5: for (int i = 0; i < serviceContextArray.length; ++i) {
            switch (serviceContextArray[i].getId()) {
                case 1: {
                    continue block5;
                }
                case 6: {
                    this.consumeSendingContextRuntime(serviceContextArray[i]);
                    continue block5;
                }
                case 1229081874: {
                    this.consumeIBMORBVersion(serviceContextArray[i]);
                }
            }
        }
        Trc.complete(CLASS, "consumeForClient:833");
    }

    public WsByteBuffer[] getCodeBaseRefBytes() {
        return this.conn.getCodeBaseRefBytes();
    }

    public boolean isBusy() {
        return this.giopPlugin.isBusy(this);
    }

    public boolean isClosed() {
        return this.conn.isClosed();
    }

    protected String getServerChannelName() {
        return this.serverChannelName;
    }

    public String getProtocol() {
        return "IIOP";
    }

    private static class RequestIdGenerator {
        private int requestId = 5;

        private RequestIdGenerator() {
        }

        synchronized int getNext() {
            return this.requestId++;
        }
    }
}

