/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CancelRequestException;
import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPReadSchedulingPolicy;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.FragmentQueue;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.HeaderWalker;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.TransportService;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.INTERNAL;

public class GIOPChannelPluginImpl
implements GIOPChannelPlugin {
    private static final String CLASS = GIOPChannelPluginImpl.class.getName();
    private int requestTimeout;
    private Map appChannelMap = null;
    private Channel[] appChannels;
    private int channelCount = 0;
    private ORB orb;
    private TransportService transportService;
    private int maxChannelCount;
    private Object initLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerAppChannel(Channel channel) {
        if (this.channelCount == 0) {
            this.transportService = (TransportService)this.orb.getTransport();
            this.maxChannelCount = this.transportService.getNumberOfGIOPInChainGroup();
            this.appChannels = new Channel[this.maxChannelCount];
        }
        Object object = this.initLock;
        synchronized (object) {
            this.appChannels[this.channelCount++] = channel;
            if (this.channelCount == this.maxChannelCount) {
                this.initLock.notify();
            }
        }
        Trc.info(Trc.str(this.channelCount), " of ", Trc.str(this.maxChannelCount), " channels: ", channel, CLASS, "registerAppChannel:96");
    }

    private Channel getORBChannel(String string) throws ChannelException, InterruptedException {
        if (this.appChannelMap == null) {
            this.initAppChannelMap();
        }
        return (Channel)this.appChannelMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initAppChannelMap() throws ChannelException, InterruptedException {
        if (this.appChannelMap != null) {
            return;
        }
        this.appChannelMap = new HashMap();
        ChannelFramework channelFramework = this.transportService.getChannelFramework();
        Object object = this.initLock;
        synchronized (object) {
            if (this.channelCount < this.maxChannelCount) {
                this.initLock.wait();
            }
        }
        for (int i = 0; i < this.channelCount; ++i) {
            ChainData[] chainDataArray = channelFramework.getInternalRunningChains(this.appChannels[i].getName());
            ChannelData[] channelDataArray = chainDataArray[0].getChannelList();
            String string = null;
            for (int j = 0; j < channelDataArray.length; ++j) {
                Class clazz = channelDataArray[j].getFactoryType();
                if (!GIOPInboundChannelFactory.class.isAssignableFrom(clazz)) continue;
                string = channelFramework.getChannel(channelDataArray[j].getName()).getName();
            }
            this.appChannelMap.put(string, this.appChannels[i]);
        }
        Trc.info(this.appChannelMap, CLASS, "initAppChannelMap:154");
        this.appChannels = null;
    }

    public void init(ORB oRB) {
        this.orb = oRB;
        this.requestTimeout = oRB.getRequestTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer[] processIncomingMsg(GIOPConnectionContext gIOPConnectionContext, WsByteBuffer[] wsByteBufferArray) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        HeaderWalker headerWalker = gIOPConnection.getHeaderWalker();
        Trc.begin1(headerWalker, CLASS, "processIncomingMsg:169");
        try {
            HeaderWalker.Progress progress;
            byte by;
            headerWalker.setBuffers(wsByteBufferArray);
            headerWalker.readGiopHeader();
            byte by2 = headerWalker.getMsgType();
            switch (by2) {
                case 2: {
                    int n = headerWalker.getRequestId();
                    CancelRequestException cancelRequestException = new CancelRequestException("GIOPCancelRequest for " + n + " received");
                    Object object = gIOPConnection.retrieveRequestData(n);
                    if (object instanceof HeaderWalker.Progress) {
                        gIOPConnection.clearRequestData(n);
                    } else {
                        gIOPConnection.storeException(n, cancelRequestException);
                    }
                    Trc.complete("Received cancel message for request ", Trc.str(n), CLASS, "processIncomingMsg:192");
                    WsByteBuffer[] wsByteBufferArray2 = null;
                    return wsByteBufferArray2;
                }
                case 5: {
                    CloseConnectionMessageException closeConnectionMessageException = new CloseConnectionMessageException("CloseConnection msg received");
                    Trc.complete("Expected Exception for GIOPCloseConnection", CLASS, "processIncomingMsg:202");
                    throw closeConnectionMessageException;
                }
                case 6: {
                    IOException iOException = new IOException("MessageError msg received");
                    gIOPConnection.markCloseConnection(iOException);
                    gIOPConnection.closeConnection(iOException);
                    Trc.complete("Received ", headerWalker.getMsgTypeName(), " - closing down connection", CLASS, "processIncomingMsg:212");
                    WsByteBuffer[] wsByteBufferArray3 = null;
                    return wsByteBufferArray3;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    by = by2;
                    progress = headerWalker.walkMessageHeader();
                    break;
                }
                case 7: {
                    Object object = null;
                    int n = -1;
                    if (headerWalker.getMajor() > 1 || headerWalker.getMinor() > 1) {
                        n = headerWalker.getRequestId();
                        object = gIOPConnection.retrieveRequestData(n);
                    }
                    if (object instanceof HeaderWalker.Progress) {
                        progress = (HeaderWalker.Progress)object;
                        by = progress.mType;
                        progress = headerWalker.continueMessageHeaderWalk(progress);
                        break;
                    }
                    if (object instanceof FragmentQueue) {
                        FragmentQueue fragmentQueue = (FragmentQueue)object;
                        byte by3 = fragmentQueue.msgType;
                        if (headerWalker.msgHasFragmentToFollow()) {
                            fragmentQueue.addNextFragment(wsByteBufferArray);
                        } else {
                            fragmentQueue.addLastFragment(wsByteBufferArray);
                        }
                        Trc.complete("Received fragment for request ", Trc.str(n), " - enqueued", CLASS, "processIncomingMsg:251");
                        WsByteBuffer[] wsByteBufferArray4 = null;
                        return wsByteBufferArray4;
                    }
                    if (object instanceof IOException) {
                        Trc.fail("Exception in dataStore ", Trc.str(n), object, CLASS, "processIncomingMsg:255");
                        throw (IOException)object;
                    }
                    if (object == null) {
                        Trc.complete("discarding unexpected fragment - request id:", Trc.str(n), CLASS, "processIncomingMsg:260");
                        WsByteBuffer[] wsByteBufferArray5 = null;
                        return wsByteBufferArray5;
                    }
                    Trc.fail("Invalid request data for request ", Trc.str(n), object, CLASS, "processIncomingMsg:263");
                    throw new INTERNAL("Invalid request data stored for req id " + n + ": " + object);
                }
                default: {
                    throw new GIOPVersionException("Unknown message type = " + by2);
                }
            }
            int n = headerWalker.getRequestId();
            if (progress == HeaderWalker.HEADER_WALK_COMPLETE) {
                if (headerWalker.msgHasFragmentToFollow()) {
                    Trc.complete("Header complete - creating frag queue: reqId=", Trc.str(n), CLASS, "processIncomingMsg:277");
                    FragmentQueue fragmentQueue = new FragmentQueue(n, by);
                    gIOPConnection.storeRequestData(n, fragmentQueue);
                } else if (by2 == 7) {
                    gIOPConnection.clearRequestData(n);
                    Trc.complete("Header complete - no frags to follow: reqId=", Trc.str(n), CLASS, "processIncomingMsg:283");
                } else {
                    Trc.complete("Header complete - message not fragmented: reqId=", Trc.str(n), CLASS, "processIncomingMsg:285");
                }
                headerWalker.rewindBuffers();
                WsByteBuffer[] wsByteBufferArray6 = headerWalker.getBuffers();
                return wsByteBufferArray6;
            }
            if (by2 != 7) {
                gIOPConnection.storeRequestData(n, progress);
            }
            Trc.complete("Header incomplete for request ", Trc.str(n), " storing progress: ", progress, CLASS, "processIncomingMsg:296");
            WsByteBuffer[] wsByteBufferArray7 = null;
            return wsByteBufferArray7;
        }
        finally {
            headerWalker.forgetBuffers();
        }
    }

    public GIOPMessageContext processIncomingContext(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        return gIOPMessageContext;
    }

    public void routeIncomingRequest(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Channel channel = this.getORBChannel(gIOPConnection.getServerChannelName());
        VirtualConnection virtualConnection = gIOPConnectionContext.getVirtualConnection();
        ConnectionLink connectionLink = channel.getConnectionLink(virtualConnection);
        CallLink callLink = (CallLink)connectionLink;
        callLink.setGIOPConnectionContext(gIOPConnectionContext);
        if (gIOPMessageContext.isResponseExpected()) {
            gIOPConnection.storeCallLink(gIOPMessageContext.getRequestId(), callLink);
        }
        callLink.processMessage(gIOPMessageContext);
    }

    public WsByteBuffer[] processOutgoingMsg(GIOPConnectionContext gIOPConnectionContext, WsByteBuffer[] wsByteBufferArray) throws Exception {
        return wsByteBufferArray;
    }

    public GIOPMessageContext processOutgoingContext(CallLink callLink, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        int n = gIOPMessageContext.getRequestId();
        IOException iOException = gIOPConnection.retrieveException(n);
        if (iOException != null) {
            throw iOException;
        }
        if (gIOPConnection.isServer() && !gIOPMessageContext.isFragmentToFollow()) {
            gIOPConnection.clearCallLink(gIOPMessageContext.getRequestId());
        } else if (!gIOPConnection.isServer() && gIOPMessageContext.isResponseExpected()) {
            long l = this.requestTimeout == 0 ? 0L : System.currentTimeMillis() + (long)this.requestTimeout;
            gIOPConnection.storeCallLink(gIOPMessageContext.getRequestId(), callLink, l);
        }
        return gIOPMessageContext;
    }

    private void cleanUpForRequestTimeout(GIOPConnectionContext gIOPConnectionContext) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Object[] objectArray = gIOPConnection.getCallLinkKeySet();
        for (int i = 0; i < objectArray.length; ++i) {
            CallLink callLink = gIOPConnection.clearCallLinkIfTimeout(objectArray[i]);
            if (callLink == null) continue;
            callLink.errorResponse(new IOException("Timeout waiting for reply to request " + gIOPConnection.getIdForKey(objectArray[i])));
        }
    }

    public void routeIncomingReply(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        CallLink callLink = gIOPConnection.clearCallLink(gIOPMessageContext.getRequestId());
        callLink.processMessage(gIOPMessageContext);
        this.cleanUpForRequestTimeout(gIOPConnectionContext);
    }

    public void routeErrorResponse(GIOPConnectionContext gIOPConnectionContext, int n, Exception exception) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Object object = gIOPConnection.retrieveRequestData(n);
        if (object != null) {
            gIOPConnection.storeRequestData(n, exception);
        } else {
            CallLink callLink = gIOPConnection.clearCallLink(n);
            callLink.errorResponse(exception);
        }
    }

    public void routeCloseConnection(GIOPConnectionContext gIOPConnectionContext, Exception exception) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        gIOPConnection.markCloseConnection(new IOException(exception.getMessage()));
        if (!gIOPConnection.isServer()) {
            Object[] objectArray = gIOPConnection.getCallLinkKeySet();
            for (int i = 0; i < objectArray.length; ++i) {
                CallLink callLink = gIOPConnection.clearCallLinkIfWaiting(objectArray[i]);
                if (callLink == null) continue;
                callLink.errorResponse(exception);
            }
        }
    }

    public WsByteBuffer[] getNextFragment(GIOPConnectionContext gIOPConnectionContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        Object object = gIOPConnection.retrieveRequestData(n);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        FragmentQueue fragmentQueue = (FragmentQueue)object;
        WsByteBuffer[] wsByteBufferArray = fragmentQueue.getNextFragment();
        if (fragmentQueue.finished()) {
            gIOPConnection.clearRequestData(n);
        }
        return wsByteBufferArray;
    }

    public void finishRequest(GIOPConnectionContext gIOPConnectionContext, int n) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        gIOPConnection.clearRequestData(n);
        gIOPConnection.clearCallLink(n);
    }

    public boolean isBusy(GIOPConnectionContext gIOPConnectionContext) {
        GIOPConnection gIOPConnection = (GIOPConnection)gIOPConnectionContext;
        return !gIOPConnection.noCallLink() || !gIOPConnection.noRequestData();
    }

    public GIOPReadSchedulingPolicy getGiopReadSchedulingPolicy() {
        return GIOPReadSchedulingPolicy.EARLY;
    }
}

