/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.corba.GIOPVersionProvider;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.util.JDKBridge;
import com.ibm.rmi.util.PartnerVersionUtil;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;

public class Profile
implements com.ibm.CORBA.iiop.Profile {
    protected String host;
    protected int port;
    protected byte major = 1;
    protected byte minor = (byte)2;
    private final byte maxMinor;
    protected ObjectKey objectKey;
    private byte[] data;
    protected TaggedComponent[] components;
    private com.ibm.rmi.ORB factory;
    private String dottedDecimalHostAddress = null;
    private CodeSetComponentInfo cs = null;
    private int partnerVersion = 0;
    private short partnerExtended = 0;
    private byte streamFormatVersion = 0;
    private String codebase = null;
    private boolean interceptorsRun = false;

    public Profile(com.ibm.rmi.ORB oRB) {
        this(oRB, null, 0, null, new TaggedComponent[0]);
    }

    public Profile(com.ibm.rmi.ORB oRB, ObjectKey objectKey) {
        this(oRB, null, 0, objectKey, new TaggedComponent[0]);
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, ObjectKey objectKey, boolean bl) {
        this(oRB, string, n, objectKey, bl ? new TaggedComponent[]{} : null);
        if (bl) {
            this.partnerVersion = PartnerVersionUtil.pack((short)-1, (short)-1);
            this.partnerExtended = (short)-1;
        }
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, ObjectKey objectKey) {
        this(oRB, string, n, objectKey, null);
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, ObjectKey objectKey, TaggedComponent[] taggedComponentArray) {
        this.factory = oRB;
        this.host = string;
        this.port = n;
        this.objectKey = objectKey;
        this.minor = this.maxMinor = ((GIOPVersionProvider)((Object)oRB)).getMaxGIOPMinor();
        if (taggedComponentArray == null) {
            int n2 = this.major == 1 && this.minor == 2 ? 3 : 2;
            this.components = new TaggedComponent[n2];
            this.components[0] = this.createCodeSetComponent();
            this.components[1] = this.createPartnerComponent();
            if (n2 > 2) {
                this.components[2] = this.createStreamFormatComponent();
            }
        } else {
            this.components = taggedComponentArray;
            this.setCachedComponentInfo();
        }
    }

    private TaggedComponent createCodeSetComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        this.cs = (CodeSetComponentInfo)this.factory.getCodeSetComponentInfo();
        cDROutputStream.putEndian();
        this.cs.write(cDROutputStream);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(1, byArray);
    }

    private TaggedComponent createPartnerComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        this.partnerExtended = ((ORB)this.factory).getPartnerExtended();
        cDROutputStream.write_ushort(this.partnerExtended);
        this.partnerVersion = ((ORB)this.factory).getPartnerVersion();
        cDROutputStream.write_ulong(this.partnerVersion);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(1229081866, byArray);
    }

    private TaggedComponent createStreamFormatComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        this.streamFormatVersion = (byte)2;
        cDROutputStream.write_octet(this.streamFormatVersion);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(38, byArray);
    }

    void addCodebaseComponent(String string) {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        cDROutputStream.write_string(string);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        this.addTaggedComponent(new TaggedComponent(25, byArray));
        this.codebase = string;
    }

    private void setCachedComponentInfo() {
        for (int i = 0; i < this.components.length; ++i) {
            this.setCachedComponentInfo(this.components[i]);
        }
    }

    private void setCachedComponentInfo(TaggedComponent taggedComponent) {
        switch (taggedComponent.tag()) {
            case 1: {
                com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.cs = new CodeSetComponentInfo();
                this.cs.read(cDRInputStream);
                break;
            }
            case 25: {
                com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.codebase = cDRInputStream.read_string();
                break;
            }
            case 38: {
                com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.streamFormatVersion = cDRInputStream.read_octet();
                break;
            }
            case 1229081866: {
                com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.partnerExtended = cDRInputStream.read_ushort();
                this.partnerVersion = cDRInputStream.read_ulong();
                if (this.partnerVersion != 0) break;
                this.partnerVersion = PartnerVersionUtil.pack(PartnerVersionUtil.getORB11(), (short)0);
            }
        }
    }

    public byte[] getEncapsulation() throws SystemException {
        if (this.data != null) {
            return this.data;
        }
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        cDROutputStream.write_octet(this.major);
        cDROutputStream.write_octet(this.minor);
        cDROutputStream.write_string(this.host);
        cDROutputStream.write_short((short)this.port);
        cDROutputStream.write_long(this.objectKey.length());
        cDROutputStream.write_octet_array(this.objectKey.getBytes(), 0, this.objectKey.length());
        if (this.minor > 0) {
            cDROutputStream.write_long(this.components.length);
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].write(cDROutputStream);
            }
        }
        this.data = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return this.data;
    }

    public Profile.TaggedComponent[] getTaggedComponents() {
        return this.components;
    }

    public Profile.TaggedComponent[] getTaggedComponents(int n) {
        int n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() != n) continue;
            ++n2;
        }
        Profile.TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
        n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() != n) continue;
            taggedComponentArray[n2++] = this.components[i];
        }
        return taggedComponentArray;
    }

    public byte[] getTaggedComponent(int n) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() != n) continue;
            return this.components[i].componentData();
        }
        return null;
    }

    public void putTaggedComponent(int n, byte[] byArray) {
        this.putTaggedComponent(n, byArray, true);
    }

    public void putTaggedComponent(int n, byte[] byArray, boolean bl) {
        int n2;
        TaggedComponent taggedComponent = null;
        if (bl) {
            for (n2 = 0; n2 < this.components.length; ++n2) {
                if (this.components[n2].tag() != n) continue;
                taggedComponent = this.components[n2];
            }
        }
        if (taggedComponent == null) {
            n2 = this.components.length;
            TaggedComponent[] taggedComponentArray = this.components;
            this.components = new TaggedComponent[n2 + 1];
            System.arraycopy(taggedComponentArray, 0, this.components, 0, n2);
            this.components[n2] = taggedComponent = new TaggedComponent(n, byArray);
        } else {
            taggedComponent.setData(byArray);
        }
        this.setCachedComponentInfo(taggedComponent);
    }

    public void removeTaggedComponent(int n) {
        int n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() == n) continue;
            ++n2;
        }
        if (n2 < this.components.length) {
            TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
            n2 = 0;
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i].tag() == n) continue;
                taggedComponentArray[n2] = this.components[i];
                ++n2;
            }
            this.components = taggedComponentArray;
        }
    }

    public void addTaggedComponent(TaggedComponent taggedComponent) {
        TaggedComponent[] taggedComponentArray = this.components;
        this.components = new TaggedComponent[taggedComponentArray.length + 1];
        System.arraycopy(taggedComponentArray, 0, this.components, 0, taggedComponentArray.length);
        this.components[taggedComponentArray.length] = taggedComponent;
    }

    public void addTaggedComponents(TaggedComponent[] taggedComponentArray) {
        TaggedComponent[] taggedComponentArray2 = this.components;
        this.components = new TaggedComponent[taggedComponentArray2.length + taggedComponentArray.length];
        System.arraycopy(taggedComponentArray2, 0, this.components, 0, taggedComponentArray2.length);
        System.arraycopy(taggedComponentArray, 0, this.components, taggedComponentArray2.length, taggedComponentArray.length);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
        this.dottedDecimalHostAddress = null;
    }

    public String getHostIPAddress() {
        if (this.dottedDecimalHostAddress == null) {
            this.dottedDecimalHostAddress = this.factory.getTransport().getHostIPAddress(this.host);
        }
        return this.dottedDecimalHostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public byte[] getObjectKey() {
        return this.objectKey.getBytes();
    }

    public ObjectKey getObjectKeyObject() {
        return this.objectKey;
    }

    public void setObjectKey(ObjectKey objectKey) {
        this.objectKey = objectKey;
    }

    public com.ibm.rmi.ORB getFactory() {
        return this.factory;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public void setMinor(byte by) {
        this.minor = by < 0 ? (byte)0 : (by > this.maxMinor ? this.maxMinor : by);
        if (this.minor != by && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "setMinor:528", "requested GIOP minor = " + by + " out of range, reset to " + this.minor);
        }
    }

    public com.ibm.CORBA.iiop.CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs;
    }

    public int getPartnerVersion() {
        return this.partnerVersion;
    }

    public short getPartnerExtended() {
        return this.partnerExtended;
    }

    public byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public boolean isEquivalent(com.ibm.CORBA.iiop.Profile profile) {
        return this.getPort() == profile.getPort() && this.getHost().equalsIgnoreCase(profile.getHost()) && this.getObjectKeyObject().equals(profile.getObjectKeyObject());
    }

    public void read(com.ibm.CORBA.iiop.CDRInputStream cDRInputStream) {
        byte[] byArray;
        int n = cDRInputStream.read_ulong();
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new MARSHAL("Data of length 0x" + Integer.toHexString(n) + " while reading Profile", 1229126036, CompletionStatus.COMPLETED_NO);
        }
        cDRInputStream.read_octet_array(byArray, 0, n);
        this.read(byArray);
    }

    protected void read(byte[] byArray) {
        block10: {
            byte[] byArray2;
            this.dottedDecimalHostAddress = null;
            CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)this.factory, byArray, byArray.length);
            ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).consumeEndian();
            this.major = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_octet();
            this.minor = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_octet();
            this.host = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_string();
            this.port = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_short() & 0xFFFF;
            int n = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_long();
            try {
                byArray2 = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("ObjectKey of length 0x" + Integer.toHexString(n) + " while reading Profile", 1229126037, CompletionStatus.COMPLETED_NO);
            }
            ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_octet_array(byArray2, 0, n);
            this.objectKey = this.factory.createObjectKey(byArray2);
            if (this.minor > 0) {
                String string;
                int n2 = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream).read_long();
                try {
                    this.components = new TaggedComponent[n2];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new MARSHAL("TaggedComponent sequence of length 0x" + Integer.toHexString(n2) + " while reading Profile", 1229126038, CompletionStatus.COMPLETED_NO);
                }
                for (int i = 0; i < n2; ++i) {
                    this.components[i] = new TaggedComponent();
                    this.components[i].read(cDRInputStream);
                }
                this.setCachedComponentInfo();
                if (this.codebase == null && (string = JDKBridge.getLocalCodebase()) != null) {
                    this.addCodebaseComponent(string);
                }
            } else {
                this.components = new TaggedComponent[0];
            }
            try {
                cDRInputStream.close();
            }
            catch (IOException iOException) {
                if (!ORBRas.isTrcLogging) break block10;
                ORBRas.orbTrcLogger.exception(4104L, this, "read:650", (Exception)iOException);
            }
        }
    }

    public void write(CDROutputStream cDROutputStream) {
        CDROutputStream cDROutputStream2 = this.factory.newOutputStream();
        cDROutputStream2.putEndian();
        cDROutputStream2.write_octet(this.major);
        cDROutputStream2.write_octet(this.minor);
        cDROutputStream2.write_string(this.host);
        cDROutputStream2.write_short((short)this.port);
        cDROutputStream2.write_long(this.objectKey.length());
        cDROutputStream2.write_octet_array(this.objectKey.getBytes(), 0, this.objectKey.length());
        if (this.minor > 0) {
            cDROutputStream2.write_long(this.components.length);
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].write(cDROutputStream2);
            }
        }
        cDROutputStream2.writeOctetSequenceTo((OutputStream)cDROutputStream);
        cDROutputStream2.releaseBuffer();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "clone:690", (Exception)cloneNotSupportedException);
            throw new INTERNAL("failed to clone Profile:" + cloneNotSupportedException.getMessage(), 1229125048, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void interceptorsRun(boolean bl) {
        this.interceptorsRun = bl;
    }

    public boolean interceptorsRun() {
        return this.interceptorsRun;
    }

    public int hashCode() {
        return this.objectKey.hashCode() + this.host.hashCode() + this.port;
    }

    public boolean equals(Profile profile) {
        return this.port == profile.getPort() && this.host.equalsIgnoreCase(profile.getHost()) && this.objectKey.equals(profile.getObjectKeyObject());
    }

    public boolean equals(Object object) {
        if (object instanceof Profile) {
            return this.equals((Profile)object);
        }
        return false;
    }

    public static class TaggedComponent
    implements Profile.TaggedComponent {
        private int tag;
        private byte[] data;

        public TaggedComponent() {
            this.tag = -1;
            this.data = null;
        }

        public TaggedComponent(int n, byte[] byArray) {
            this.tag = n;
            this.data = byArray;
        }

        public void read(com.ibm.CORBA.iiop.CDRInputStream cDRInputStream) {
            byte[] byArray;
            this.tag = cDRInputStream.read_ulong();
            int n = cDRInputStream.read_long();
            try {
                byArray = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("Component data of length 0x" + Integer.toHexString(n) + " while reading Profile", 1229126035, CompletionStatus.COMPLETED_NO);
            }
            cDRInputStream.read_octet_array(byArray, 0, n);
            this.data = byArray;
        }

        public void write(CDROutputStream cDROutputStream) {
            cDROutputStream.write_ulong(this.tag);
            cDROutputStream.write_long(this.data.length);
            cDROutputStream.write_octet_array(this.data, 0, this.data.length);
        }

        public com.ibm.CORBA.iiop.CDRInputStream getComponentData(com.ibm.CORBA.iiop.ORB oRB) {
            return this.getComponentData((com.ibm.rmi.ORB)oRB);
        }

        public com.ibm.CORBA.iiop.CDRInputStream getComponentData(com.ibm.rmi.ORB oRB) {
            com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = oRB.newInputStream(this.data, this.data.length);
            cDRInputStream.consumeEndian();
            return cDRInputStream;
        }

        public int tag() {
            return this.tag;
        }

        public byte[] componentData() {
            return this.data;
        }

        private void setData(byte[] byArray) {
            this.data = byArray;
        }
    }
}

