/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

final class RecordDataHashGeneratorFactory {
    private RecordDataHashGeneratorFactory() {
        throw new UnsupportedOperationException();
    }

    public static RecordDataHashGenerator newRecordDataHashGenerator() {
        return new RecordDataHashGeneratorImpl();
    }

    private static class RecordDataHashGeneratorImpl
    implements RecordDataHashGenerator {
        private static final String HASH_ALG = "SHA1";

        RecordDataHashGeneratorImpl() {
        }

        private Buffer generateHash(byte[] data) throws NoSuchAlgorithmException, NullPointerException, IOException {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            byte[] hash = md.digest(data);
            ByteSequence buffer = IntableByteSequenceFactory.newIntableByteSequence(md.getDigestLength()).append(ByteSequenceFactory.newByteSequence(hash));
            return BufferFactory.newBuffer(buffer.getInputStream());
        }

        public Buffer generateCertificateSignatureHash(X509Certificate certificate) throws NoSuchAlgorithmException, NullPointerException, IOException {
            return this.generateHash(certificate.getSignature());
        }

        public Buffer generateTBSCertificateHash(X509Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException, NullPointerException, IOException {
            return this.generateHash(certificate.getTBSCertificate());
        }

        public Buffer generateSubjectNameHash(X509Certificate certificate) throws NoSuchAlgorithmException, NullPointerException, IOException {
            X500Name name = (X500Name)certificate.getSubjectDN();
            return this.generateHash(name.getEncoded());
        }

        public Buffer generateSubjectPublicKeyInfoHash(X509Certificate certificate) throws NoSuchAlgorithmException, NullPointerException, IOException {
            return this.generateHash(certificate.getPublicKey().getEncoded());
        }

        public Buffer generateIssuerAndSerialNumberHash(X509Certificate certificate) throws IOException, NoSuchAlgorithmException, NullPointerException {
            X500Name name = (X500Name)certificate.getIssuerDN();
            SerialNumber sn = new SerialNumber(certificate.getSerialNumber());
            DerOutputStream out = new DerOutputStream();
            name.encode(out);
            sn.encode(out);
            return this.generateHash(out.toByteArray());
        }

        public Buffer generateHash(ByteSequence data) throws NoSuchAlgorithmException, NullPointerException, IOException {
            byte[] dataBytes = new byte[data.length()];
            data.getInputStream().read(dataBytes);
            return this.generateHash(dataBytes);
        }
    }
}

