/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BERObject;
import com.ibm.security.cmskeystore.CertificateItem;
import com.ibm.security.cmskeystore.CertificateRequestItem;
import com.ibm.security.cmskeystore.EncryptedPrivateKeyInfoItem;
import com.ibm.security.cmskeystore.KMUtil;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyItem {
    public static final int RSA_KEY_ENTRY = 1;
    public static final int DES_KEY_ENTRY = 2;
    public static final int CRL_ENTRY = 3;
    private int itemType = 1;
    private String keyLabel;
    private short uniqueId;
    private short keySize;
    private boolean isTrustedRoot;
    private boolean isDefault;
    private boolean hasPrivateKey;
    private boolean hasCertificate;
    private boolean isUserDefinedFieldPresent;
    private boolean isSiteCertificate;
    private EncryptedPrivateKeyInfoItem epkiItem;
    private BERObject udfBER;
    private Vector<CertificateItem> certificatesChain;
    private CertificateRequestItem certReq;
    private boolean hasCRL;
    private String desKey;
    private String subAltEmail = null;
    private String subAltIP = null;
    private String subAltDNS = null;
    private boolean subAltNamesParsed = false;

    public KeyItem() {
        this((String)null, 0, 0, (EncryptedPrivateKeyInfoItem)null, (Vector)null, (BERObject)null, false, false);
    }

    public KeyItem(String label, short id, short keySize, EncryptedPrivateKeyInfoItem epki, Vector certsChain, BERObject userDefinedFields, boolean isTrusted, boolean isDefaultKey) {
        this.keyLabel = label;
        this.uniqueId = id;
        this.keySize = keySize;
        this.epkiItem = epki;
        this.setCertificateChain(certsChain);
        this.udfBER = userDefinedFields;
        this.isTrustedRoot = isTrusted;
        this.isDefault = isDefaultKey;
        this.isUserDefinedFieldPresent = userDefinedFields != null;
        this.hasCertificate = this.certificatesChain != null && !this.certificatesChain.isEmpty();
        this.isSiteCertificate = false;
        this.hasPrivateKey = epki != null;
        this.certReq = null;
        this.desKey = null;
        this.hasCRL = false;
    }

    public KeyItem(String label, short id, short keySize, EncryptedPrivateKeyInfoItem epki, CertificateItem[] certsList, BERObject userDefinedFields, boolean isTrusted, boolean isDefaultKey) {
        this.keyLabel = label;
        this.uniqueId = id;
        this.keySize = keySize;
        this.epkiItem = epki;
        this.setCertificateChain(certsList);
        this.udfBER = userDefinedFields;
        this.isTrustedRoot = isTrusted;
        this.isDefault = isDefaultKey;
        this.isUserDefinedFieldPresent = userDefinedFields != null;
        this.hasCertificate = this.certificatesChain != null && !this.certificatesChain.isEmpty();
        this.isSiteCertificate = false;
        this.hasPrivateKey = epki != null;
        this.certReq = null;
        this.desKey = null;
        this.hasCRL = false;
    }

    public KeyItem(String label, short id, short keySize, CertificateItem siteCertificate) {
        this.keyLabel = label;
        this.uniqueId = id;
        this.keySize = keySize;
        this.epkiItem = null;
        this.addCertificate(siteCertificate);
        this.udfBER = null;
        this.isTrustedRoot = false;
        this.isDefault = false;
        this.isUserDefinedFieldPresent = false;
        this.hasCertificate = siteCertificate != null;
        this.isSiteCertificate = true;
        this.hasPrivateKey = false;
        this.certReq = null;
        this.desKey = null;
        this.hasCRL = false;
    }

    public KeyItem(String label, short id, short keySize, EncryptedPrivateKeyInfoItem epki, CertificateRequestItem certReq, BERObject userDefinedFields) {
        this.keyLabel = label;
        this.uniqueId = id;
        this.keySize = keySize;
        this.epkiItem = epki;
        this.certificatesChain = null;
        this.udfBER = userDefinedFields;
        this.isTrustedRoot = false;
        this.isDefault = false;
        this.isUserDefinedFieldPresent = userDefinedFields != null;
        this.hasCertificate = false;
        this.isSiteCertificate = false;
        this.hasPrivateKey = epki != null;
        this.certReq = certReq;
        this.desKey = null;
        this.hasCRL = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isTrusted() {
        return this.isTrustedRoot;
    }

    public boolean isSiteCertificate() {
        return this.isSiteCertificate;
    }

    public int getItemType() {
        return this.itemType;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public short getKeySize() {
        return this.keySize;
    }

    public void setKeySize(short ks) {
        this.keySize = ks;
    }

    public Vector<CertificateItem> getCertificateChain() {
        return this.certificatesChain;
    }

    public void setCertificateChain(CertificateItem[] certsList) {
        if (this.certificatesChain == null) {
            this.certificatesChain = new Vector();
        } else {
            this.certificatesChain.removeAllElements();
        }
        if (certsList != null) {
            for (int i = 0; i < certsList.length; ++i) {
                this.certificatesChain.addElement(certsList[i]);
                this.hasCertificate = true;
            }
        }
    }

    public void setCertificateChain(Vector certsChain) {
        if (this.certificatesChain == null) {
            this.certificatesChain = new Vector();
        } else {
            this.certificatesChain.removeAllElements();
        }
        if (certsChain != null) {
            for (int i = 0; i < certsChain.size(); ++i) {
                CertificateItem aCert = (CertificateItem)certsChain.elementAt(i);
                this.certificatesChain.addElement(aCert);
                this.hasCertificate = true;
            }
        }
    }

    public int addCertificate(CertificateItem aCert) {
        if (aCert == null) {
            return 0;
        }
        if (this.certificatesChain == null) {
            this.certificatesChain = new Vector();
        }
        this.certificatesChain.addElement(aCert);
        this.hasCertificate = true;
        return this.certificatesChain.size();
    }

    public boolean hasMultipleCertificateChain() {
        return this.hasCertificate && this.certificatesChain.size() > 1;
    }

    public KeyItem[] getKeyItemsForCertChain() {
        if (this.certificatesChain == null) {
            KeyItem[] keyItemList = new KeyItem[]{this};
            return keyItemList;
        }
        int numItems = this.certificatesChain.size();
        KeyItem[] keyItemList = new KeyItem[numItems];
        for (int i = 0; i < numItems; ++i) {
            CertificateItem cert = this.certificatesChain.elementAt(i);
            KeyItem k = new KeyItem((String)null, 0, 0, (EncryptedPrivateKeyInfoItem)null, (Vector)null, new BERObject(cert.getEncoded()), true, false);
            k.addCertificate(cert);
            k.setKeySize(cert.getKeySize());
            if (i == 0) {
                k.setKeyLabel(this.keyLabel);
                k.setEncryptedPrivateKeyInfoItem(this.epkiItem);
            }
            keyItemList[i] = k;
        }
        return keyItemList;
    }

    public EncryptedPrivateKeyInfoItem getEncryptedPrivateKeyInfoItem() {
        return this.epkiItem;
    }

    public BERObject getUserDefinedFields() {
        return this.udfBER;
    }

    public CertificateRequestItem getCertificateRequestItem() {
        return this.certReq;
    }

    public String getDESKey() {
        return this.desKey;
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public void setHasPrivateKey(boolean hasPrivateKey) {
        this.hasPrivateKey = hasPrivateKey;
    }

    public boolean hasCertificate() {
        return this.hasCertificate;
    }

    public boolean containExpiredCertificate() {
        boolean expired = false;
        if (this.certificatesChain != null) {
            int certCnt = this.certificatesChain.size();
            for (int i = 0; i < certCnt; ++i) {
                CertificateItem certItem = this.certificatesChain.elementAt(i);
                if (!certItem.isExpired()) continue;
                expired = true;
                break;
            }
        }
        return expired;
    }

    public boolean hasUserDefinedFields() {
        return this.isUserDefinedFieldPresent;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        return super.toString() + ", type=" + this.itemType + ", keyLabel=" + this.keyLabel + ", isDefault=" + this.isDefault + ", isTrusted=" + this.isTrustedRoot + ", isPrivateKeyPresent=" + this.hasPrivateKey + ", keySize=" + this.keySize + ", certificate=" + this.certificatesChain + ", certificateRequest=" + this.certReq;
    }

    public void setEncryptedPrivateKeyInfoItem(EncryptedPrivateKeyInfoItem encPvtKey) {
        if (encPvtKey != null) {
            this.epkiItem = encPvtKey;
            this.hasPrivateKey = true;
        }
    }

    public void setKeyLabel(String Label) {
        this.keyLabel = Label;
    }

    public void setTrusted(boolean trust) {
        this.isTrustedRoot = trust;
    }

    public void setDefault(boolean b) {
        this.isDefault = b;
    }

    public boolean equalsCert(KeyItem key2) {
        if (this.hasCertificate && key2.hasCertificate()) {
            String cert2f;
            String cert1f = this.certificatesChain.elementAt(0).getFingerPrint();
            return cert1f.equals(cert2f = key2.getCertificateChain().elementAt(0).getFingerPrint());
        }
        return !this.hasCertificate && !key2.hasCertificate();
    }

    public void setSiteCertificate(boolean b) {
        this.isSiteCertificate = b;
    }

    public String getSubAltEmail() {
        if (!this.subAltNamesParsed) {
            this.parseSubAltNames();
        }
        return this.subAltEmail;
    }

    public String getSubAltIP() {
        if (!this.subAltNamesParsed) {
            this.parseSubAltNames();
        }
        return this.subAltIP;
    }

    public String getSubAltDNS() {
        if (!this.subAltNamesParsed) {
            this.parseSubAltNames();
        }
        return this.subAltDNS;
    }

    public void setSubAltNames(String email, String ip, String dns) {
        if (email != null && email.length() > 0) {
            this.subAltEmail = new String(email);
        }
        if (ip != null && ip.length() > 0) {
            this.subAltIP = new String(ip);
        }
        if (dns != null && dns.length() > 0) {
            this.subAltDNS = new String(dns);
        }
    }

    public void parseSubAltNames() {
        KMUtil.debugMsg("KeyItem::parseSubAltNames 0000");
        this.subAltNamesParsed = true;
        if (this.hasCertificate) {
            CertificateItem certItem = this.certificatesChain.elementAt(0);
            try {
                String strEmail = null;
                String strIP = null;
                String strDNS = null;
                KMUtil.debugMsg("KeyItem::parseSubAltNames 0100");
                X509CertImpl x509Cert = new X509CertImpl(certItem.getEncoded());
                KMUtil.debugMsg("KeyItem::parseSubAltNames 0110");
                X509CertInfo x509certinfo = (X509CertInfo)x509Cert.get("x509.info");
                KMUtil.debugMsg("KeyItem::parseSubAltNames 0120");
                CertificateExtensions certificateExtensions = (CertificateExtensions)x509certinfo.get("extensions");
                KMUtil.debugMsg("KeyItem::parseSubAltNames 0130");
                if (certificateExtensions != null) {
                    SubjectAlternativeNameExtension subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)certificateExtensions.get("SubjectAlternativeName");
                    KMUtil.debugMsg("KeyItem::parseSubAltNames 0150");
                    GeneralNames generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
                    if (generalNames != null) {
                        int n = generalNames.size();
                        KMUtil.debugMsg("KeyItem::parseSubAltNames 0160");
                        GeneralName name = generalNames.getGeneralName(1);
                        if (name != null) {
                            strEmail = name.toString().substring(12);
                        }
                        KMUtil.debugMsg("KeyItem::parseSubAltNames 0180");
                        name = generalNames.getGeneralName(7);
                        if (name != null) {
                            GeneralNameInterface interf = name.getName();
                            IPAddressName ipnew = (IPAddressName)interf;
                            strIP = ipnew.getName();
                        }
                        KMUtil.debugMsg("KeyItem::parseSubAltNames 0200");
                        name = generalNames.getGeneralName(2);
                        if (name != null) {
                            strDNS = name.toString().substring(9);
                        }
                    }
                }
                KMUtil.debugMsg("KeyItem::parseSubAltNames 0300");
                this.setSubAltNames(strEmail, strIP, strDNS);
            }
            catch (Exception e) {
                KMUtil.debugMsg("KeyItem::parseSubAltNames 8000, Exception=" + e);
            }
        }
        KMUtil.debugMsg("KeyItem::parseSubAltNames 9999");
    }
}

