/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.PKIXExtensions;

class KMExtensionItem {
    public static final int FIELD_TYPE_UNKNOWN = 0;
    public static final int FIELD_TYPE_EMAIL = 1;
    public static final int FIELD_TYPE_IPADDR = 7;
    public static final int FIELD_TYPE_DNSNAME = 2;
    private ObjectIdentifier asn1oid;
    private int fieldType;
    private Object fieldValue;
    private ObjectIdentifier defaultAsn1oid;

    public KMExtensionItem() {
        this.defaultAsn1oid = PKIXExtensions.SubjectAlternativeName_Id;
        this.asn1oid = null;
        this.fieldType = 0;
        this.fieldValue = null;
    }

    public KMExtensionItem(int fType, Object fValue) {
        this.asn1oid = this.defaultAsn1oid = PKIXExtensions.SubjectAlternativeName_Id;
        this.fieldType = fType;
        this.fieldValue = fValue;
    }

    public KMExtensionItem(ObjectIdentifier oid, int fType, Object fValue) {
        this.defaultAsn1oid = PKIXExtensions.SubjectAlternativeName_Id;
        this.asn1oid = oid;
        this.fieldType = fType;
        this.fieldValue = fValue;
    }

    public ObjectIdentifier getAsn1oid() {
        return this.asn1oid;
    }

    public ObjectIdentifier getDefaultAsn1oid() {
        return this.defaultAsn1oid;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public static boolean isValidFieldType(int fType) {
        if (fType == 1) {
            return true;
        }
        if (fType == 7) {
            return true;
        }
        return fType == 2;
    }
}

