/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.ByteSequenceXorFactory;
import com.ibm.security.cmskeystore.DatabaseHashGenerator;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordHashGeneratorFactory;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class DatabaseHashGeneratorFactory {
    private DatabaseHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static DatabaseHashGenerator newDatabaseHashGenerator() {
        return new DatabaseHashGeneratorImpl();
    }

    private static final class DatabaseHashGeneratorImpl
    implements DatabaseHashGenerator {
        DatabaseHashGeneratorImpl() {
        }

        public ByteSequence generateHash(KeyDatabase database, ByteSequence password) throws NullPointerException, NoSuchAlgorithmException {
            if (database == null || password == null) {
                throw new NullPointerException();
            }
            FileHeader header = database.getHeader();
            Sequence<Record> records = database.getRecords();
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordHeaderHash().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = password.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            ByteSequence digest = ByteSequenceFactory.newByteSequence(md.digest());
            for (Record record : records) {
                ByteSequence recordHash = RecordHashGeneratorFactory.newRecordHashGenerator().generateHash(record, password);
                digest = ByteSequenceXorFactory.newByteSequenceXor().xor(digest, recordHash);
            }
            return digest;
        }
    }
}

