/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSStoreParameter;
import java.io.File;
import java.security.KeyStore;

public final class CMSLoadStoreParameterFactory {
    public static final KeyStore.LoadStoreParameter newCMSLoadParameter(File ksFile, KeyStore.ProtectionParameter protection) {
        return new CMSLoadParameterImpl(ksFile, protection);
    }

    public static final KeyStore.LoadStoreParameter newCMSStoreParameter(File ksFile, KeyStore.ProtectionParameter protection, boolean stashPassword) {
        return new CMSStoreParameterImpl(ksFile, protection, stashPassword);
    }

    private CMSLoadStoreParameterFactory() {
    }

    private static final class CMSStoreParameterImpl
    implements CMSStoreParameter {
        private File keyStoreFile = null;
        private KeyStore.ProtectionParameter protection = null;
        boolean stashPassword = false;

        CMSStoreParameterImpl(File kdbFile, KeyStore.ProtectionParameter protection, boolean stashPassword) {
            this.keyStoreFile = kdbFile;
            this.protection = protection;
            this.stashPassword = stashPassword;
        }

        private CMSStoreParameterImpl() {
            throw new UnsupportedOperationException();
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public boolean isStashPassword() {
            return this.stashPassword;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.protection;
        }
    }

    private static final class CMSLoadParameterImpl
    implements CMSLoadParameter {
        private File keyStoreFile = null;
        private KeyStore.ProtectionParameter protection = null;

        CMSLoadParameterImpl(File kdbFile, KeyStore.ProtectionParameter protection) {
            this.keyStoreFile = kdbFile;
            if (protection == null) {
                throw new NullPointerException("ProtectionParameter should not be null when loading CMS KeyStore.");
            }
            this.protection = protection;
        }

        private CMSLoadParameterImpl() {
            throw new UnsupportedOperationException();
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.protection;
        }
    }
}

