/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingDefaultsImpl;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NumberVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.SubclassJoinDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.ValueMapDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import serp.util.Strings;

public class PersistenceMappingDefaults
extends MappingDefaultsImpl {
    private boolean _prependFieldNameToJoinTableInverseJoinColumns = true;

    public PersistenceMappingDefaults() {
        this.setDefaultMissingInfo(true);
        this.setStoreEnumOrdinal(true);
        this.setOrderLists(false);
        this.setAddNullIndicator(false);
        this.setDiscriminatorColumnName("DTYPE");
    }

    public boolean getPrependFieldNameToJoinTableInverseJoinColumns() {
        return this._prependFieldNameToJoinTableInverseJoinColumns;
    }

    public void setPrependFieldNameToJoinTableInverseJoinColumns(boolean val) {
        this._prependFieldNameToJoinTableInverseJoinColumns = val;
    }

    public Object getStrategy(Version vers, boolean adapt) {
        Object strat = super.getStrategy(vers, adapt);
        ClassMapping cls = vers.getClassMapping();
        if (strat != null || cls.getJoinablePCSuperclassMapping() != null || cls.getVersionField() != null) {
            return strat;
        }
        if (vers.getMappingInfo().getColumns().isEmpty()) {
            return NoneVersionStrategy.getInstance();
        }
        return new NumberVersionStrategy();
    }

    public Object getStrategy(Discriminator disc, boolean adapt) {
        Object strat = super.getStrategy(disc, adapt);
        ClassMapping cls = disc.getClassMapping();
        if (strat != null || cls.getJoinablePCSuperclassMapping() != null || disc.getMappingInfo().getValue() != null) {
            return strat;
        }
        if (!disc.getMappingInfo().getColumns().isEmpty()) {
            return new ValueMapDiscriminatorStrategy();
        }
        ClassMapping base = cls;
        while (base.getMappingInfo().getHierarchyStrategy() == null && base.getPCSuperclassMapping() != null) {
            base = base.getPCSuperclassMapping();
        }
        strat = base.getMappingInfo().getHierarchyStrategy();
        if ("flat".equals(strat)) {
            return new ValueMapDiscriminatorStrategy();
        }
        if ("vertical".equals(strat) && this.dict.joinSyntax != 1) {
            return new SubclassJoinDiscriminatorStrategy();
        }
        return NoneDiscriminatorStrategy.getInstance();
    }

    public String getTableName(ClassMapping cls, Schema schema) {
        if (cls.getTypeAlias() != null) {
            return cls.getTypeAlias();
        }
        return Strings.getClassName(cls.getDescribedType()).replace('$', '_');
    }

    public String getTableName(FieldMapping fm, Schema schema) {
        String name = fm.getDefiningMapping().getTable().getName() + "_";
        ClassMapping rel = fm.getElementMapping().getTypeMapping();
        boolean assoc = rel != null && rel.getTable() != null && fm.getTypeCode() != 13;
        name = assoc ? name + rel.getTable().getName() : name + fm.getName();
        return name.replace('$', '_');
    }

    public void populateJoinColumn(FieldMapping fm, Table local, Table foreign, Column col, Object target, int pos, int cols) {
        if (!(target instanceof Column)) {
            return;
        }
        FieldMapping[] inverses = fm.getInverseMappings();
        String name = inverses.length > 0 ? inverses[0].getName() : fm.getDefiningMapping().getTypeAlias();
        name = name + "_" + ((Column)target).getName();
        col.setName(name);
    }

    public void populateForeignKeyColumn(ValueMapping vm, String name, Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
        boolean elem;
        boolean bl = elem = vm == vm.getFieldMapping().getElement() && vm.getFieldMapping().getTypeCode() != 13;
        if (!this._prependFieldNameToJoinTableInverseJoinColumns && !inverse && elem) {
            return;
        }
        if (target instanceof Column) {
            if (elem) {
                name = vm.getFieldMapping().getName();
            }
            col.setName(name + "_" + ((Column)target).getName());
        }
    }

    public void populateColumns(Version vers, Table table, Column[] cols) {
        FieldMapping fm = vers.getClassMapping().getVersionFieldMapping();
        if (fm != null && cols.length == 1) {
            cols[0].setName(fm.getName());
        } else {
            super.populateColumns(vers, table, cols);
        }
    }
}

