/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPriv5Helper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AbstractMetaDataDefaults;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.PersistentMap;
import org.apache.openjpa.util.MetaDataException;

public class PersistenceMetaDataDefaults
extends AbstractMetaDataDefaults {
    private boolean _allowsMultipleMethodsForSameCallback = false;
    private static final Localizer _loc = Localizer.forPackage(PersistenceMetaDataDefaults.class);
    private static final Map<Class, PersistenceStrategy> _strats = new HashMap<Class, PersistenceStrategy>();
    private static final Set<String> _ignoredAnnos = new HashSet<String>();

    public PersistenceMetaDataDefaults() {
        this.setCallbackMode(50);
        this.setDataStoreObjectIdFieldUnwrapped(true);
    }

    public static PersistenceStrategy getPersistenceStrategy(FieldMetaData fmd, Member member) {
        int code;
        Class<?> type;
        if (member == null) {
            return null;
        }
        AnnotatedElement el = (AnnotatedElement)((Object)member);
        if (((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction(el, Transient.class))).booleanValue()) {
            return PersistenceStrategy.TRANSIENT;
        }
        if (fmd != null && fmd.getManagement() != 3) {
            return null;
        }
        PersistenceStrategy pstrat = null;
        for (Annotation anno : el.getDeclaredAnnotations()) {
            if (pstrat != null && _strats.containsKey(anno.annotationType())) {
                throw new MetaDataException(_loc.get("already-pers", member));
            }
            if (pstrat != null) continue;
            pstrat = _strats.get(anno.annotationType());
        }
        if (pstrat != null) {
            return pstrat;
        }
        if (fmd != null) {
            type = fmd.getType();
            code = fmd.getTypeCode();
        } else if (member instanceof Field) {
            type = ((Field)member).getType();
            code = JavaTypes.getTypeCode(type);
        } else {
            type = ((Method)member).getReturnType();
            code = JavaTypes.getTypeCode(type);
        }
        switch (code) {
            case 11: {
                if (type != byte[].class && type != char[].class && type != Byte[].class && type != Character[].class) break;
                return PersistenceStrategy.BASIC;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return PersistenceStrategy.BASIC;
            }
            case 8: {
                if (!Enum.class.isAssignableFrom(type)) break;
                return PersistenceStrategy.BASIC;
            }
        }
        if (((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction(type, Embeddable.class))).booleanValue()) {
            return PersistenceStrategy.EMBEDDED;
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return PersistenceStrategy.BASIC;
        }
        return null;
    }

    public boolean getAllowsMultipleMethodsForSameCallback() {
        return this._allowsMultipleMethodsForSameCallback;
    }

    public void setAllowsMultipleMethodsForSameCallback(boolean flag) {
        this._allowsMultipleMethodsForSameCallback = flag;
    }

    public void setDefaultAccessType(String type) {
        if (type == null) {
            return;
        }
        if ("PROPERTY".equals(type.toUpperCase())) {
            this.setDefaultAccessType(4);
        } else {
            this.setDefaultAccessType(2);
        }
    }

    public void populate(ClassMetaData meta, int access) {
        super.populate(meta, access);
        meta.setDetachable(true);
    }

    protected void populate(FieldMetaData fmd) {
        PersistenceMetaDataDefaults.setCascadeNone(fmd);
        PersistenceMetaDataDefaults.setCascadeNone(fmd.getKey());
        PersistenceMetaDataDefaults.setCascadeNone(fmd.getElement());
    }

    static void setCascadeNone(ValueMetaData vmd) {
        vmd.setCascadePersist(0);
        vmd.setCascadeRefresh(0);
        vmd.setCascadeAttach(0);
    }

    protected int getAccessType(ClassMetaData meta) {
        return this.getAccessType(meta.getDescribedType());
    }

    private int getAccessType(Class cls) {
        if (cls == null || cls == Object.class) {
            return 0;
        }
        int access = 0;
        if (PersistenceMetaDataDefaults.usesAccess((Field[])AccessController.doPrivileged(J2DoPriv5Helper.getDeclaredFieldsAction(cls)))) {
            access |= 2;
        }
        if (PersistenceMetaDataDefaults.usesAccess((Method[])AccessController.doPrivileged(J2DoPriv5Helper.getDeclaredMethodsAction(cls)))) {
            access |= 4;
        }
        return access == 0 ? this.getAccessType(cls.getSuperclass()) : access;
    }

    private static boolean usesAccess(AnnotatedElement[] members) {
        for (int i = 0; i < members.length; ++i) {
            Annotation[] annos = (Annotation[])AccessController.doPrivileged(J2DoPriv5Helper.getAnnotationsAction(members[i]));
            for (int j = 0; j < annos.length; ++j) {
                String name = annos[j].annotationType().getName();
                if (!name.startsWith("javax.persistence.") && !name.startsWith("org.apache.openjpa.persistence.") || _ignoredAnnos.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isDefaultPersistent(ClassMetaData meta, Member member, String name) {
        PersistenceStrategy strat;
        int mods = member.getModifiers();
        if (Modifier.isTransient(mods)) {
            return false;
        }
        if (member instanceof Method) {
            try {
                Method setter = (Method)AccessController.doPrivileged(J2DoPriv5Helper.getDeclaredMethodAction(meta.getDescribedType(), "set" + StringUtils.capitalize(name), new Class[]{((Method)member).getReturnType()}));
                if (setter == null && !this.isAnnotatedTransient(member)) {
                    this.logNoSetter(meta, name, null);
                    return false;
                }
            }
            catch (Exception e) {
                if (!this.isAnnotatedTransient(member)) {
                    this.logNoSetter(meta, name, e);
                }
                return false;
            }
        }
        return (strat = PersistenceMetaDataDefaults.getPersistenceStrategy(null, member)) != null && strat != PersistenceStrategy.TRANSIENT;
    }

    private boolean isAnnotatedTransient(Member member) {
        return member instanceof AnnotatedElement && (Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)((Object)member), Transient.class)) != false;
    }

    private void logNoSetter(ClassMetaData meta, String name, Exception e) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.MetaData");
        if (log.isWarnEnabled()) {
            log.warn(_loc.get("no-setter-for-getter", name, meta.getDescribedType().getName()));
        } else if (log.isTraceEnabled()) {
            log.warn(_loc.get("no-setter-for-getter", name, meta.getDescribedType().getName()), e);
        }
    }

    static {
        _strats.put(Basic.class, PersistenceStrategy.BASIC);
        _strats.put(ManyToOne.class, PersistenceStrategy.MANY_ONE);
        _strats.put(OneToOne.class, PersistenceStrategy.ONE_ONE);
        _strats.put(Embedded.class, PersistenceStrategy.EMBEDDED);
        _strats.put(EmbeddedId.class, PersistenceStrategy.EMBEDDED);
        _strats.put(OneToMany.class, PersistenceStrategy.ONE_MANY);
        _strats.put(ManyToMany.class, PersistenceStrategy.MANY_MANY);
        _strats.put(Persistent.class, PersistenceStrategy.PERS);
        _strats.put(PersistentCollection.class, PersistenceStrategy.PERS_COLL);
        _strats.put(PersistentMap.class, PersistenceStrategy.PERS_MAP);
        _ignoredAnnos.add(DetachedState.class.getName());
        _ignoredAnnos.add(PostLoad.class.getName());
        _ignoredAnnos.add(PostPersist.class.getName());
        _ignoredAnnos.add(PostRemove.class.getName());
        _ignoredAnnos.add(PostUpdate.class.getName());
        _ignoredAnnos.add(PrePersist.class.getName());
        _ignoredAnnos.add(PreRemove.class.getName());
        _ignoredAnnos.add(PreUpdate.class.getName());
    }
}

