/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import sun.tools.jconsole.BorderedComponent;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.VariableGridLayout;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBeanTree;
import sun.tools.jconsole.inspector.XSheet;
import sun.tools.jconsole.inspector.XTree;
import sun.tools.jconsole.inspector.XTreeRenderer;

public class MBeansTab
extends Tab
implements NotificationListener {
    private XMBeanTree beanTree;
    private XSheet xmbeanSheet;
    private XDataViewer viewer;

    public static String getTabName() {
        return Resources.getText("MBeans", new Object[0]);
    }

    public MBeansTab(VMPanel vMPanel) {
        super(vMPanel, MBeansTab.getTabName());
        try {
            this.setupTab();
            this.workerAdd(new Runnable(){

                public void run() {
                    MBeansTab.this.synchroniseMBeanServerView();
                }
            });
        }
        catch (Exception exception) {
            System.out.println("Error when synchronizing with MBeanServer : " + exception);
        }
    }

    public void dispose() {
        super.dispose();
        this.xmbeanSheet.dispose();
    }

    public int getUpdateInterval() {
        return this.vmPanel.getUpdateInterval();
    }

    void synchroniseMBeanServerView() {
        try {
            this.getMBeanServerConnection().addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
            Set<ObjectName> set = this.getMBeanServerConnection().queryNames(null, null);
            this.beanTree.removeAll();
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ObjectName objectName = (ObjectName)objectArray[i];
                try {
                    this.beanTree.addMBeanToView(this, objectName);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Error adding " + objectName);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MBeansTab.this.beanTree.revalidate();
                    MBeansTab.this.beanTree.repaint();
                    MBeansTab.this.repaint();
                }
            });
        }
        catch (Exception exception) {
            System.out.println("Error when synchronizing with MBeanServer : " + exception);
        }
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.vmPanel.getProxyClient().getMBeanServerConnection();
    }

    public void update() {
    }

    private List getSelected() {
        return this.beanTree.getSelectedXMBeans();
    }

    private void unSelectAll() {
        this.beanTree.unSelectAll();
    }

    private void setupTab() {
        this.setLayout(new VariableGridLayout(0, 1, 4, 4, true, true));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerLocation(150);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.beanTree = new XTree();
        this.beanTree.setCellRenderer(new XTreeRenderer());
        this.beanTree.getAccessibleContext().setAccessibleName(Resources.getText("MBeans", new Object[0]));
        JScrollPane jScrollPane = new JScrollPane(this.beanTree, 20, 30);
        jScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.setBackground(new Color(102, 102, 153));
        jPanel.add((Component)jScrollPane, "Center");
        jSplitPane.add(jPanel, "left", 0);
        this.viewer = new XDataViewer(this);
        this.xmbeanSheet = new XSheet(this.beanTree, this.viewer, this);
        this.beanTree.addXMBeanListener(this.xmbeanSheet);
        jSplitPane.add(this.xmbeanSheet, "right", 0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        BorderedComponent borderedComponent = new BorderedComponent(Resources.getText("MBeans", new Object[0]), jPanel2, false);
        jPanel2.add(jSplitPane);
        this.add(borderedComponent);
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof MBeanServerNotification) {
            try {
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                if (notification.getType().equals("JMX.mbean.registered")) {
                    this.beanTree.addMBeanToView(this, objectName);
                    return;
                }
                if (notification.getType().equals("JMX.mbean.unregistered")) {
                    this.beanTree.delMBeanFromView(objectName);
                }
            }
            catch (Exception exception) {
                System.out.println("Error when handling notification : " + exception);
            }
        }
    }
}

