/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type {
    public static final Type noType = new Type(18, null);
    public static boolean moreInfo = false;
    public int tag;
    public Symbol.TypeSymbol tsym;

    public Object constValue() {
        return null;
    }

    public void accept(Visitor visitor) {
        visitor.visitType(this);
    }

    public Type(int n, Symbol.TypeSymbol typeSymbol) {
        this.tag = n;
        this.tsym = typeSymbol;
    }

    public Type map(Mapping mapping) {
        return this;
    }

    public static List<Type> map(List<Type> list, Mapping mapping) {
        if (list.nonEmpty()) {
            List<Type> list2 = Type.map(list.tail, mapping);
            Type type = mapping.apply((Type)list.head);
            if (list2 != list.tail || type != list.head) {
                return list2.prepend(type);
            }
        }
        return list;
    }

    public Type constType(Object object) {
        final Object object2 = object;
        assert (this.tag <= 8);
        return new Type(this.tag, this.tsym){

            public Object constValue() {
                return object2;
            }

            public Type baseType() {
                return this.tsym.type;
            }
        };
    }

    public Type baseType() {
        return this;
    }

    public static List<Type> baseTypes(List<Type> list) {
        if (list.nonEmpty()) {
            Type type = ((Type)list.head).baseType();
            List<Type> list2 = Type.baseTypes(list.tail);
            if (type != list.head || list2 != list.tail) {
                return list2.prepend(type);
            }
        }
        return list;
    }

    public String toString() {
        String string;
        String string2 = string = this.tsym == null || this.tsym.name == null ? "<none>" : this.tsym.name.toString();
        if (moreInfo && this.tag == 14) {
            string = string + this.hashCode();
        }
        return string;
    }

    public static String toString(List<Type> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((Type)list.head).toString());
        List list2 = list.tail;
        while (list2.nonEmpty()) {
            stringBuffer.append(",").append(((Type)list2.head).toString());
            list2 = list2.tail;
        }
        return stringBuffer.toString();
    }

    public String stringValue() {
        assert (this.constValue() != null);
        if (this.tag == 8) {
            return (Integer)this.constValue() == 0 ? "false" : "true";
        }
        if (this.tag == 2) {
            return String.valueOf((char)((Integer)this.constValue()).intValue());
        }
        return this.constValue().toString();
    }

    public boolean isFalse() {
        return this.tag == 8 && this.constValue() != null && (Integer)this.constValue() == 0;
    }

    public boolean isTrue() {
        return this.tag == 8 && this.constValue() != null && (Integer)this.constValue() != 0;
    }

    public String argtypes(boolean bl) {
        List<Type> list = this.argtypes();
        if (!bl) {
            return list.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (list.tail.nonEmpty()) {
            stringBuffer.append(list.head);
            list = list.tail;
            stringBuffer.append(',');
        }
        if (((Type)list.head).tag == 11) {
            stringBuffer.append(((ArrayType)list.head).elemtype);
            stringBuffer.append("...");
        } else {
            stringBuffer.append(list.head);
        }
        return stringBuffer.toString();
    }

    public List<Type> typarams() {
        return List.nil();
    }

    public Type outer() {
        return null;
    }

    public List<Type> argtypes() {
        return List.nil();
    }

    public Type restype() {
        return null;
    }

    public List<Type> thrown() {
        return List.nil();
    }

    public Type bound() {
        return null;
    }

    public void setThrown(List<Type> list) {
        throw new AssertionError();
    }

    public List<Type> allparams() {
        return List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (((Type)list2.head).isErroneous()) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return (this.tsym.flags() & 0x1000000L) != 0L;
    }

    public boolean isPrimitive() {
        return this.tag < 9;
    }

    public boolean contains(Type type) {
        return type == this;
    }

    public static boolean contains(List<Type> list, Type type) {
        List<Type> list2 = list;
        while (list2.tail != null) {
            if (((Type)list2.head).contains(type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean containsSome(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.contains((Type)list.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type type) {
        return this;
    }

    public static List<Type> removeBounds(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        while (list.nonEmpty()) {
            listBuffer.append(((Type)list.head).removeBounds());
            list = list.tail;
        }
        return listBuffer.toList();
    }

    public Type removeBounds() {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static abstract class Visitor {
        public void visitClassType(ClassType classType) {
            this.visitType(classType);
        }

        public void visitArgumentType(ArgumentType argumentType) {
            this.visitType(argumentType);
        }

        public void visitArrayType(ArrayType arrayType) {
            this.visitType(arrayType);
        }

        public void visitMethodType(MethodType methodType) {
            this.visitType(methodType);
        }

        public void visitPackageType(PackageType packageType) {
            this.visitType(packageType);
        }

        public void visitTypeVar(TypeVar typeVar) {
            this.visitType(typeVar);
        }

        public void visitCapturedType(CapturedType capturedType) {
            this.visitTypeVar(capturedType);
        }

        public void visitDelegatedType(DelegatedType delegatedType) {
            delegatedType.qtype.accept(this);
        }

        public void visitForAll(ForAll forAll) {
            this.visitDelegatedType(forAll);
        }

        public void visitUndetVar(UndetVar undetVar) {
            this.visitDelegatedType(undetVar);
        }

        public void visitErrorType(ErrorType errorType) {
            this.visitType(errorType);
        }

        public abstract void visitType(Type var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorType
    extends ClassType {
        public ErrorType() {
            super(noType, List.<Type>nil(), null);
            this.tag = 19;
        }

        public ErrorType(Symbol.ClassSymbol classSymbol) {
            this();
            this.tsym = classSymbol;
            classSymbol.type = this;
            classSymbol.kind = 31;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
        }

        public ErrorType(Name name, Symbol.TypeSymbol typeSymbol) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, typeSymbol));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitErrorType(this);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public Type outer() {
            return this;
        }

        @Override
        public Type restype() {
            return this;
        }

        public Type asSub(Symbol symbol) {
            return this;
        }

        @Override
        public Type map(Mapping mapping) {
            return this;
        }

        public boolean isGenType(Type type) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public List<Type> allparams() {
            return List.nil();
        }

        @Override
        public List<Type> typarams() {
            return List.nil();
        }
    }

    public static class UndetVar
    extends DelegatedType {
        public List<Type> lobounds = List.nil();
        public List<Type> hibounds = List.nil();
        public Type inst = null;

        public void accept(Visitor visitor) {
            visitor.visitUndetVar(this);
        }

        public UndetVar(Type type) {
            super(21, type);
        }

        public String toString() {
            if (this.inst != null) {
                return this.inst.toString();
            }
            return this.qtype + "?";
        }

        public Type baseType() {
            if (this.inst != null) {
                return this.inst.baseType();
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForAll
    extends DelegatedType
    implements Cloneable {
        public List<Type> tvars;

        public ForAll(List<Type> list, Type type) {
            super(16, type);
            this.tvars = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitForAll(this);
        }

        @Override
        public String toString() {
            return "<" + this.tvars + ">" + this.qtype;
        }

        @Override
        public List<Type> typarams() {
            return this.tvars;
        }

        @Override
        public void setThrown(List<Type> list) {
            this.qtype.setThrown(list);
        }

        @Override
        public Object clone() {
            ForAll forAll = (ForAll)super.clone();
            forAll.qtype = (Type)forAll.qtype.clone();
            return forAll;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public Type map(Mapping mapping) {
            return mapping.apply(this.qtype);
        }

        @Override
        public boolean contains(Type type) {
            return this.qtype.contains(type);
        }

        @Override
        public MethodType asMethodType() {
            return this.qtype.asMethodType();
        }

        @Override
        public void complete() {
            List<Type> list = this.tvars;
            while (list.nonEmpty()) {
                ((TypeVar)list.head).bound.complete();
                list = list.tail;
            }
            this.qtype.complete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DelegatedType
    extends Type {
        public Type qtype;

        public DelegatedType(int n, Type type) {
            super(n, type.tsym);
            this.qtype = type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDelegatedType(this);
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> typarams() {
            return this.qtype.typarams();
        }

        @Override
        public Type outer() {
            return this.qtype.outer();
        }

        @Override
        public List<Type> argtypes() {
            return this.qtype.argtypes();
        }

        @Override
        public Type restype() {
            return this.qtype.restype();
        }

        @Override
        public List<Type> thrown() {
            return this.qtype.thrown();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type bound() {
            return this.qtype.bound();
        }

        @Override
        public Object clone() {
            DelegatedType delegatedType = (DelegatedType)super.clone();
            delegatedType.qtype = (Type)this.qtype.clone();
            return delegatedType;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public Type lower;

        public CapturedType(Name name, Symbol symbol, Type type, Type type2) {
            super(name, symbol);
            this.bound = type;
            this.lower = type2;
        }

        public void accept(Visitor visitor) {
            visitor.visitCapturedType(this);
        }
    }

    public static class TypeVar
    extends Type {
        public Type bound = null;
        int rank_field = -1;

        public TypeVar(Name name, Symbol symbol) {
            super(14, null);
            this.tsym = new Symbol.TypeSymbol(0L, name, this, symbol);
        }

        public TypeVar(Symbol.TypeSymbol typeSymbol, Type type) {
            super(14, typeSymbol);
            this.bound = type;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeVar(this);
        }

        public Type bound() {
            return this.bound;
        }
    }

    public static class PackageType
    extends Type {
        PackageType(Symbol.TypeSymbol typeSymbol) {
            super(13, typeSymbol);
        }

        public void accept(Visitor visitor) {
            visitor.visitPackageType(this);
        }

        public String toString() {
            return this.tsym.fullName().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type
    implements Cloneable {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;

        public MethodType(List<Type> list, Type type, List<Type> list2, Symbol.TypeSymbol typeSymbol) {
            super(12, typeSymbol);
            this.argtypes = list;
            this.restype = type;
            this.thrown = list2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitMethodType(this);
        }

        @Override
        public String toString() {
            return "(" + this.argtypes + ")" + this.restype;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MethodType)) {
                return false;
            }
            MethodType methodType = (MethodType)object;
            List<Type> list = this.argtypes;
            List<Type> list2 = methodType.argtypes;
            while (list.tail != null && list2.tail != null && ((Type)list.head).equals(list2.head)) {
                list = list.tail;
                list2 = list2.tail;
            }
            if (list.tail != null || list2.tail != null) {
                return false;
            }
            return this.restype.equals(methodType.restype);
        }

        public int hashCode() {
            int n = 12;
            List<Type> list = this.argtypes;
            while (list.tail != null) {
                n = (n << 5) + ((Type)list.head).hashCode();
                list = list.tail;
            }
            return (n << 5) + this.restype.hashCode();
        }

        @Override
        public List<Type> argtypes() {
            return this.argtypes;
        }

        @Override
        public Type restype() {
            return this.restype;
        }

        @Override
        public List<Type> thrown() {
            return this.thrown;
        }

        @Override
        public void setThrown(List<Type> list) {
            this.thrown = list;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public Type map(Mapping mapping) {
            List<Type> list = MethodType.map(this.argtypes, mapping);
            Type type = mapping.apply(this.restype);
            List<Type> list2 = MethodType.map(this.thrown, mapping);
            if (list == this.argtypes && type == this.restype && list2 == this.thrown) {
                return this;
            }
            return new MethodType(list, type, list2, this.tsym);
        }

        @Override
        public boolean contains(Type type) {
            return type == this || MethodType.contains(this.argtypes, type) || this.restype.contains(type);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> list = this.argtypes;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
            this.restype.complete();
            list = this.thrown;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayType
    extends Type {
        public Type elemtype;

        public ArrayType(Type type, Symbol.TypeSymbol typeSymbol) {
            super(11, typeSymbol);
            this.elemtype = type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public String toString() {
            return this.elemtype + "[]";
        }

        public boolean equals(Object object) {
            return this == object || object instanceof ArrayType && this.elemtype.equals(((ArrayType)object).elemtype);
        }

        public int hashCode() {
            return 352 + this.elemtype.hashCode();
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        @Override
        public Type map(Mapping mapping) {
            Type type = mapping.apply(this.elemtype);
            if (type == this.elemtype) {
                return this;
            }
            return new ArrayType(type, this.tsym);
        }

        @Override
        public boolean contains(Type type) {
            return type == this || this.elemtype.contains(type);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        int rank_field = -1;

        public ClassType(Type type, List<Type> list, Symbol.TypeSymbol typeSymbol) {
            super(10, typeSymbol);
            this.outer_field = type;
            this.typarams_field = list;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitClassType(this);
        }

        @Override
        public Type constType(Object object) {
            final Object object2 = object;
            return new ClassType(this.outer_field, this.typarams_field, this.tsym){

                public Object constValue() {
                    return object2;
                }

                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.outer().tag == 10 && this.tsym.owner.kind == 2) {
                stringBuffer.append(this.outer().toString());
                stringBuffer.append(".");
                stringBuffer.append(this.className(this.tsym, false));
            } else {
                stringBuffer.append(this.className(this.tsym, true));
            }
            if (this.typarams().nonEmpty()) {
                stringBuffer.append('<');
                stringBuffer.append(this.typarams().toString());
                stringBuffer.append(">");
            }
            return stringBuffer.toString();
        }

        private String className(Symbol symbol, boolean bl) {
            if (symbol.name.len == 0 && (symbol.flags() & 0x1000000L) != 0L) {
                StringBuffer stringBuffer = new StringBuffer(this.supertype_field.toString());
                List<Type> list = this.interfaces_field;
                while (list.nonEmpty()) {
                    stringBuffer.append("&");
                    stringBuffer.append(((Type)list.head).toString());
                    list = list.tail;
                }
                return stringBuffer.toString();
            }
            if (symbol.name.len == 0) {
                ClassType classType = (ClassType)this.tsym.type;
                String string = classType.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", classType.interfaces_field.head) : Log.getLocalizedString("anonymous.class", classType.supertype_field);
                if (moreInfo) {
                    string = string + String.valueOf(symbol.hashCode());
                }
                return string;
            }
            if (bl) {
                return symbol.fullName().toString();
            }
            return symbol.name.toString();
        }

        @Override
        public List<Type> typarams() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = List.nil();
                }
            }
            return this.typarams_field;
        }

        @Override
        public Type outer() {
            return this.outer_field;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = this.typarams().prependList(this.outer().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.outer().isErroneous() || ClassType.isErroneous(this.typarams()) || this != this.tsym.type && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public Type map(Mapping mapping) {
            Type type = this.outer();
            Type type2 = mapping.apply(type);
            List<Type> list = this.typarams();
            List<Type> list2 = ClassType.map(list, mapping);
            if (type2 == type && list2 == list) {
                return this;
            }
            return new ClassType(type2, list2, this.tsym);
        }

        @Override
        public boolean contains(Type type) {
            return type == this || this.isParameterized() && (this.outer().contains(type) || ClassType.contains(this.typarams(), type));
        }

        @Override
        public void complete() {
            if (this.tsym.completer != null) {
                this.tsym.complete();
            }
        }
    }

    public static class ArgumentType
    extends Type {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        public void accept(Visitor visitor) {
            visitor.visitArgumentType(this);
        }

        public ArgumentType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol) {
            super(15, typeSymbol);
            assert (type != null);
            this.kind = boundKind;
            this.type = type;
        }

        public ArgumentType(ArgumentType argumentType, TypeVar typeVar) {
            this(argumentType.type, argumentType.kind, argumentType.tsym, typeVar);
        }

        public ArgumentType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeVar typeVar) {
            this(type, boundKind, typeSymbol);
            this.bound = typeVar;
        }

        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND;
        }

        public Type withTypeVar(Type type) {
            if (this.bound == type) {
                return this;
            }
            this.bound = (TypeVar)type;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                stringBuffer.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    stringBuffer.append("{:").append(this.bound.bound).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return stringBuffer.toString();
        }

        public Type map(Mapping mapping) {
            Type type = this.type;
            if (type != null) {
                type = mapping.apply(type);
            }
            if (type == this.type) {
                return this;
            }
            return new ArgumentType(type, this.kind, this.tsym, this.bound);
        }

        public Type removeBounds() {
            return this.isUnbound() ? this : this.type;
        }
    }

    public static abstract class Mapping {
        public abstract Type apply(Type var1);
    }
}

