/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;

public abstract class Attribute {
    public Type type;
    public static final Attribute[] emptyArray = new Attribute[0];

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        public void accept(Visitor visitor) {
            visitor.visitError(this);
        }

        public String toString() {
            return "<error>";
        }
    }

    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;

        public Enum(Type type, Symbol.VarSymbol varSymbol) {
            super(type);
            assert (varSymbol != null);
            this.value = varSymbol;
        }

        public void accept(Visitor visitor) {
            visitor.visitEnum(this);
        }

        public String toString() {
            return this.value == null ? "null" : this.value.name.toString();
        }
    }

    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] attributeArray) {
            super(type);
            this.values = attributeArray;
        }

        public void accept(Visitor visitor) {
            visitor.visitArray(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            boolean bl = true;
            for (Attribute attribute : this.values) {
                if (!bl) {
                    stringBuffer.append(",");
                }
                bl = false;
                stringBuffer.append(attribute);
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compound
    extends Attribute {
        public final List<Pair<Symbol.MethodSymbol, Attribute>> values;

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> list) {
            super(type);
            this.values = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCompound(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("@");
            stringBuffer.append(this.type.tsym.fullName());
            stringBuffer.append("{");
            boolean bl = true;
            List<Pair<Symbol.MethodSymbol, Attribute>> list = this.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                if (!bl) {
                    stringBuffer.append(",");
                }
                bl = false;
                stringBuffer.append(((Symbol.MethodSymbol)pair.fst).name);
                stringBuffer.append("=");
                stringBuffer.append(pair.snd);
                list = list.tail;
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public Attribute member(Name name) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != name) continue;
                return (Attribute)pair.snd;
            }
            return null;
        }
    }

    public static class Class
    extends Attribute {
        public final Type type;

        public void accept(Visitor visitor) {
            visitor.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.type = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type type2 = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.outer(), List.of(type2), types.syms.classType.tsym);
        }

        public String toString() {
            return this.type + ".class";
        }
    }

    public static class Constant
    extends Attribute {
        public final Object value;

        public void accept(Visitor visitor) {
            visitor.visitConstant(this);
        }

        public Constant(Type type, Object object) {
            super(type);
            this.value = object;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

