/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.declaration.AnnotationValueImpl;
import com.sun.tools.apt.mirror.declaration.Constants;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMirrorImpl
implements AnnotationMirror {
    protected final AptEnv env;
    protected final Attribute.Compound anno;
    protected final Declaration decl;

    AnnotationMirrorImpl(AptEnv aptEnv, Attribute.Compound compound, Declaration declaration) {
        this.env = aptEnv;
        this.anno = compound;
        this.decl = declaration;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("@");
        Constants.Formatter formatter = Constants.getFormatter(stringBuilder);
        formatter.append(this.anno.type.tsym);
        int n = this.anno.values.length();
        if (n > 0) {
            stringBuilder.append('(');
            boolean bl = true;
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.anno.values) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                Name name = ((Symbol.MethodSymbol)pair.fst).name;
                if (n > 1 || name != this.env.names.value) {
                    formatter.append(name);
                    stringBuilder.append('=');
                }
                stringBuilder.append(new AnnotationValueImpl(this.env, (Attribute)pair.snd, this));
            }
            stringBuilder.append(')');
        }
        return formatter.toString();
    }

    public AnnotationType getAnnotationType() {
        return (AnnotationType)this.env.typeMaker.getType(this.anno.type);
    }

    public Map<AnnotationTypeElementDeclaration, AnnotationValue> getElementValues() {
        LinkedHashMap<AnnotationTypeElementDeclaration, AnnotationValue> linkedHashMap = new LinkedHashMap<AnnotationTypeElementDeclaration, AnnotationValue>();
        for (Pair<Symbol.MethodSymbol, Attribute> pair : this.anno.values) {
            linkedHashMap.put(this.getElement((Symbol.MethodSymbol)pair.fst), new AnnotationValueImpl(this.env, (Attribute)pair.snd, this));
        }
        return linkedHashMap;
    }

    public SourcePosition getPosition() {
        return this.decl == null ? null : this.decl.getPosition();
    }

    public Declaration getDeclaration() {
        return this.decl;
    }

    private AnnotationTypeElementDeclaration getElement(Symbol.MethodSymbol methodSymbol) {
        return (AnnotationTypeElementDeclaration)this.env.declMaker.getExecutableDeclaration(methodSymbol);
    }
}

