/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;

public class DirectoryLoader
extends ClassLoader {
    private Hashtable cache;
    private ClassPath classPath;
    private ClassPath dDir;
    private URLClassPath urlPath;
    private AccessControlContext acc;

    public DirectoryLoader(String string, String string2) {
        this.classPath = new ClassPath(string);
        this.dDir = new ClassPath(string2);
        this.urlPath = new URLClassPath(URLClassPath.pathToURLs((String)string));
        this.cache = new Hashtable();
        this.acc = AccessController.getContext();
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.cache.get(string);
        if (clazz == null) {
            try {
                clazz = super.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                byte[] byArray = this.getClassFileData(string);
                if (byArray == null) {
                    throw new ClassNotFoundException();
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                if (clazz == null) {
                    throw new ClassFormatError();
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                this.cache.put(string, clazz);
            }
        }
        return clazz;
    }

    protected URL findResource(String string) {
        if (null == string) {
            return null;
        }
        final String string2 = new String(string);
        Resource resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DirectoryLoader.this.urlPath.getResource(string2, true);
            }
        }, this.acc);
        return resource != null ? this.urlPath.checkURL(resource.getURL()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassFileData(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        ClassFile classFile = this.classPath.getFile(Identifier.lookup(string).getTopName().toString().replace('.', File.separatorChar) + ".java");
        ClassFile classFile2 = this.classPath.getFile(string.replace('.', File.separatorChar) + ".class");
        if (classFile != null && (classFile2 == null || classFile.lastModified() > classFile2.lastModified())) {
            classFile2 = this.dDir.getFile(string.replace('.', File.separatorChar) + ".class");
        }
        try {
            inputStream = classFile2.getInputStream();
            int n = (int)classFile2.length();
            byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n && n2 != -1; i += n2) {
                n2 = inputStream.read(byArray, i, n - i);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {}
            }
        }
        return byArray;
    }

    public void destroy() {
        try {
            this.classPath.close();
            this.dDir.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

