/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceState;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.toJavaPortable.Compile;
import com.ibm.idl.toJavaPortable.Factories;
import com.ibm.idl.toJavaPortable.JavaGenerator;
import com.ibm.idl.toJavaPortable.TCOffsets;
import com.ibm.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueBoxGen
implements com.ibm.idl.ValueBoxGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected ValueBoxEntry v = null;
    protected PrintWriter stream = null;

    public void generate(Hashtable hashtable, ValueBoxEntry valueBoxEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.v = valueBoxEntry;
        TypedefEntry typedefEntry = ((InterfaceState)valueBoxEntry.state().elementAt((int)0)).entry;
        SymtabEntry symtabEntry = typedefEntry.type();
        if (symtabEntry instanceof PrimitiveEntry) {
            this.openStream();
            if (this.stream == null) {
                return;
            }
            this.writeHeading();
            this.writeBody();
            this.writeClosing();
            this.closeStream();
        } else {
            Enumeration enumeration = valueBoxEntry.contained().elements();
            while (enumeration.hasMoreElements()) {
                SymtabEntry symtabEntry2 = (SymtabEntry)enumeration.nextElement();
                if (symtabEntry2.type() == null) continue;
                symtabEntry2.type().generate(hashtable, this.stream);
            }
        }
        this.generateHelper();
        this.generateHolder();
    }

    protected void openStream() {
        this.stream = Util.stream(this.v, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.v);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.v);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.v);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.v.comment() != null) {
            this.v.comment().generate("", this.stream);
        }
        this.stream.println("public class " + this.v.name() + " implements org.omg.CORBA.portable.ValueBase");
        this.stream.println("{");
    }

    protected void writeBody() {
        InterfaceState interfaceState = (InterfaceState)this.v.state().elementAt(0);
        TypedefEntry typedefEntry = interfaceState.entry;
        Util.fillInfo(typedefEntry);
        if (typedefEntry.comment() != null) {
            typedefEntry.comment().generate(" ", this.stream);
        }
        this.stream.println("  public " + Util.javaName(typedefEntry) + " value;");
        this.stream.println("  public " + this.v.name() + " (" + Util.javaName(typedefEntry) + " initial)");
        this.stream.println("  {");
        this.stream.println("    value = initial;");
        this.stream.println("  }");
        this.stream.println();
        this.writeTruncatable();
    }

    protected void writeTruncatable() {
        this.stream.print("  private static String[] _truncatable_ids = {");
        this.stream.println(Util.helperName(this.v, true) + ".id ()};");
        this.stream.println();
        this.stream.println("  public String[] _truncatable_ids() {");
        this.stream.println("    return _truncatable_ids;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.v.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeStreamableMethods() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        this.streamableRead("this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream ostream)");
        this.stream.println("  {");
        this.write(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + Util.helperName(this.v, false) + ".type ();");
        this.stream.println("  }");
    }

    public int helperType(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        ValueEntry valueEntry = (ValueEntry)symtabEntry;
        TypedefEntry typedefEntry = ((InterfaceState)valueEntry.state().elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = Util.typeOf(typedefEntry);
        n = ((JavaGenerator)((Object)symtabEntry2.generator())).type(n, string, tCOffsets, string2, symtabEntry2, printWriter);
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_value_box_tc (" + "_id, " + '\"' + symtabEntry.name() + "\", " + string2 + ");");
        return n;
    }

    public int type(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n;
    }

    public int read(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        return n;
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    if (!(istream instanceof org.omg.CORBA_2_3.portable.InputStream)) {");
        printWriter.println("      throw new org.omg.CORBA.BAD_PARAM(); }");
        printWriter.println("    return (" + string + ") ((org.omg.CORBA_2_3.portable.InputStream) istream).read_value (_instance);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public java.io.Serializable read_value (org.omg.CORBA.portable.InputStream istream)");
        printWriter.println("  {");
        String string2 = "    ";
        Vector vector = ((ValueBoxEntry)symtabEntry).state();
        TypedefEntry typedefEntry = ((InterfaceState)vector.elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = typedefEntry.type();
        if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
            printWriter.println(string2 + Util.javaName(symtabEntry2) + " tmp;");
            ((JavaGenerator)((Object)typedefEntry.generator())).read(0, string2, "tmp", typedefEntry, printWriter);
        } else {
            printWriter.println(string2 + Util.javaName(symtabEntry2) + " tmp = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
        }
        if (symtabEntry2 instanceof PrimitiveEntry) {
            printWriter.println(string2 + "return new " + string + " (tmp);");
        } else {
            printWriter.println(string2 + "return (java.io.Serializable) tmp;");
        }
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    if (!(ostream instanceof org.omg.CORBA_2_3.portable.OutputStream)) {");
        printWriter.println("      throw new org.omg.CORBA.BAD_PARAM(); }");
        printWriter.println("    ((org.omg.CORBA_2_3.portable.OutputStream) ostream).write_value (value, _instance);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public void write_value (org.omg.CORBA.portable.OutputStream ostream, java.io.Serializable value)");
        printWriter.println("  {");
        String string = Util.javaName(symtabEntry);
        printWriter.println("    if (!(value instanceof " + string + ")) {");
        printWriter.println("      throw new org.omg.CORBA.MARSHAL(); }");
        printWriter.println("    " + string + " valueType = (" + string + ") value;");
        this.write(0, "    ", "valueType", symtabEntry, printWriter);
    }

    public int write(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Vector vector = ((ValueEntry)symtabEntry).state();
        TypedefEntry typedefEntry = ((InterfaceState)vector.elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = typedefEntry.type();
        if (symtabEntry2 instanceof PrimitiveEntry || !typedefEntry.arrayInfo().isEmpty()) {
            n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, string, string2 + ".value", typedefEntry, printWriter);
        } else if (symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof TypedefEntry || !typedefEntry.arrayInfo().isEmpty()) {
            n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, string, string2, typedefEntry, printWriter);
        } else {
            printWriter.println(string + Util.helperName(symtabEntry2, true) + ".write (ostream, " + string2 + ");");
        }
        return n;
    }

    protected void writeAbstract() {
    }

    protected void streamableRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Vector vector = ((ValueBoxEntry)symtabEntry).state();
        TypedefEntry typedefEntry = ((InterfaceState)vector.elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = typedefEntry.type();
        if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
            TypedefEntry typedefEntry2 = ((InterfaceState)vector.elementAt((int)0)).entry;
            ((JavaGenerator)((Object)typedefEntry.generator())).read(0, "    ", string + ".value", typedefEntry, printWriter);
        } else if (symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) {
            printWriter.println("    " + string + ".value = (" + Util.javaQualifiedName(symtabEntry2) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(symtabEntry2, true) + ".get_instance ());");
        } else {
            printWriter.println("    " + string + ".value = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
        }
    }
}

