/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spi;

import com.ibm.cfwk.pkcs.PKCS12PBE;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.X509Chain;
import com.ibm.cfwk.tools.PrivateKeyAndCertificateChain;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PKCS12Spi
extends KeyStoreSpi {
    private X509Certificate[] x509Cert = null;
    private Key rsaKey = null;
    private Vector aliases = null;
    private boolean validEntry = false;

    public Enumeration engineAliases() {
        if (this.validEntry) {
            return this.aliases.elements();
        }
        return null;
    }

    public boolean engineContainsAlias(String string) {
        if (this.validEntry) {
            return this.aliases.contains(string);
        }
        return false;
    }

    public void engineDeleteEntry(String string) {
        this.validEntry = false;
    }

    public Certificate engineGetCertificate(String string) {
        if (!this.validEntry || !this.aliases.contains(string)) {
            return null;
        }
        int n = this.aliases.indexOf(string);
        return this.x509Cert[n];
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (!this.validEntry || !(certificate instanceof X509Certificate)) {
            return null;
        }
        PublicKey publicKey = ((X509Certificate)certificate).getPublicKey();
        int n = 0;
        while (n < this.x509Cert.length) {
            try {
                PublicKey publicKey2 = this.x509Cert[n].getPublicKey();
                if (publicKey.equals(publicKey2)) {
                    return (String)this.aliases.elementAt(n);
                }
            }
            catch (Exception exception) {
                return null;
            }
            ++n;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (this.validEntry) {
            return this.x509Cert;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) {
        if (this.validEntry) {
            return this.rsaKey;
        }
        return null;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (!this.validEntry) {
            return false;
        }
        return this.aliases.contains(string) && !this.aliases.elementAt(0).equals(string);
    }

    public boolean engineIsKeyEntry(String string) {
        if (!this.validEntry) {
            return false;
        }
        return this.aliases.elementAt(0).equals(string);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Method not supported, PKCS#12 cannot contain trusted cert entries");
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!key.getFormat().equals("PKCS#8")) {
            throw new KeyStoreException("Key does not support PKCS#8 encoding");
        }
        this.rsaKey = key;
        this.aliases = new Vector(certificateArray.length);
        int n = 0;
        while (n < certificateArray.length) {
            if (!(certificateArray[n] instanceof X509Certificate)) {
                throw new KeyStoreException("Chain not X.509");
            }
            ++n;
        }
        this.aliases.add(string);
        int n2 = 1;
        while (n2 < certificateArray.length) {
            String string2 = ((X509Certificate)certificateArray[n2]).getSubjectDN().getName();
            int n3 = string2.indexOf("cn=");
            if (n3 == -1 && (n3 = string2.indexOf("CN=")) == -1 && (n3 = string2.indexOf("ou=")) == -1 && (n3 = string2.indexOf("OU=")) == -1) {
                throw new KeyStoreException("Cannot find a suitable friendly name");
            }
            if (string2.indexOf(", ", n3) == -1) {
                this.aliases.add(string2.substring(n3 + 3));
            } else {
                this.aliases.add(string2.substring(n3 + 3, string2.indexOf(", ", n3)));
            }
            ++n2;
        }
        this.x509Cert = (X509Certificate[])certificateArray;
        this.validEntry = true;
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Method not supported");
    }

    public int engineSize() {
        return this.validEntry ? this.aliases.size() : 0;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, CertificateException {
        byte[] byArray;
        X509Chain x509Chain;
        if (!this.validEntry) {
            throw new CertificateException("Nothing to make a PKCS#12 out of.");
        }
        if (this.rsaKey == null || this.x509Cert == null || this.aliases == null) {
            throw new CertificateException("Some components are missing.");
        }
        PrivateKeyAndCertificateChain privateKeyAndCertificateChain = null;
        byte[] byArray2 = new byte[]{2, 3, 4};
        String[] stringArray = new String[this.aliases.size()];
        int n = 0;
        while (n < this.aliases.size()) {
            stringArray[n] = (String)this.aliases.elementAt(n);
            ++n;
        }
        try {
            X509Cert[] x509CertArray = new X509Cert[this.x509Cert.length];
            int n2 = 0;
            while (n2 < this.x509Cert.length) {
                x509CertArray[n2] = new X509Cert(this.x509Cert[n2].getEncoded());
                ++n2;
            }
            x509Chain = new X509Chain(x509CertArray);
        }
        catch (Exception exception) {
            throw new CertificateException("Error during encoding of X.509 Certificates, " + exception.getMessage());
        }
        try {
            privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain(this.rsaKey.getEncoded(), x509Chain, stringArray, byArray2);
            byArray = privateKeyAndCertificateChain.makePKCS12PDU(new String(cArray), PKCS12PBE.SHA1_3DES3, null, 1000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CertificateException("Error during creation of PKCS#12 object: " + exception.getMessage());
        }
        outputStream.write(byArray);
        outputStream.flush();
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, CertificateException {
        Object[] objectArray;
        int n;
        if (inputStream == null) {
            return;
        }
        byte[] byArray = new byte[4096];
        PrivateKeyAndCertificateChain privateKeyAndCertificateChain = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        byteArrayOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        try {
            privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain(byArray, new String(cArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CertificateException("PKCS#12 load error: " + exception.getMessage());
        }
        X509Cert[] x509CertArray = privateKeyAndCertificateChain.getCertificateChain().getCertArray();
        this.x509Cert = new X509CertImpl[x509CertArray.length];
        int n2 = 0;
        while (n2 < x509CertArray.length) {
            this.x509Cert[n2] = new X509CertImpl(x509CertArray[n2].getEncoded());
            ++n2;
        }
        try {
            objectArray = privateKeyAndCertificateChain.getPrivateKey();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", KeyStoreManager.JCEProvider);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])objectArray);
            this.rsaKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new CertificateException("Error during encoding of Private Key, " + exception.getMessage());
        }
        objectArray = privateKeyAndCertificateChain.getFriendlyNames();
        this.aliases = new Vector(objectArray.length);
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.aliases.add(objectArray[n3]);
            ++n3;
        }
        this.validEntry = true;
    }
}

