/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.BERDecoder;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.pki.SubjectPublicKeyInfo;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.ce.AltNames;
import com.ibm.cfwk.pki.ce.AuthorityKeyIdentifier;
import com.ibm.cfwk.pki.ce.BasicConstraints;
import com.ibm.cfwk.pki.ce.CRLDistributionPoints;
import com.ibm.cfwk.pki.ce.ExtKeyUsage;
import com.ibm.cfwk.pki.ce.KeyUsage;
import com.ibm.cfwk.pki.ce.NameConstraints;
import com.ibm.cfwk.pki.ce.PolicyConstraints;
import com.ibm.cfwk.pki.ce.PolicyMappings;
import com.ibm.cfwk.pki.ce.PrivateKeyUsagePeriod;
import com.ibm.cfwk.pki.ce.SubjectDirectoryAttributes;
import com.ibm.cfwk.pki.ce.SubjectKeyIdentifier;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMpkcs12;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.cli.CLICertificateInfo;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseManager;
import com.ibm.gsk.ikeyman.ikeycmd;
import com.ibm.util.x500name.RDNAttribute;
import com.ibm.util.x500name.X500Name;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class CLICertificateManager
implements CLIConstants {
    public static void create(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.dn.getCommonName();
        String string4 = cLICertificateInfo.dn.getOrgUnit();
        String string5 = cLICertificateInfo.dn.getOrg();
        String string6 = cLICertificateInfo.dn.getLocality();
        String string7 = cLICertificateInfo.dn.getState();
        String string8 = cLICertificateInfo.dn.getZipCode();
        String string9 = cLICertificateInfo.dn.getCountry();
        String string10 = cLICertificateInfo.dn.getEmail();
        Vector vector = cLICertificateInfo.dn.getOptions();
        DNItem dNItem = new DNItem(string3, string4, string5, string6, string7, string8, string9, string10);
        int n2 = cLICertificateInfo.getVersion();
        String string11 = cLICertificateInfo.getLabel();
        boolean bl = cLICertificateInfo.getDefault();
        int n3 = cLICertificateInfo.getKeySize();
        long l2 = cLICertificateInfo.getExpire();
        String string12 = cLICertificateInfo.getFileName();
        boolean bl2 = cLICertificateInfo.getFormat();
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("calling createNewSelfSignedCertificate with parms: \n \nversion: " + n2 + " \nlabel: " + string11 + " \nset as default: " + bl + " \nkeySize: " + n3 + " \nexpire: " + l2 + " \ncertFileName: " + string12 + " \nis base 64 armored: " + bl2);
        ikeycmd.debugMsg("\n");
        keyDatabase.getKeyDatabaseOperator().createNewSelfSignedCertificate(n2, string11, bl, n3, dNItem, (int)l2, string12, bl2);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void receive(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getFileName();
        boolean bl = cLICertificateInfo.getFormat();
        boolean bl2 = cLICertificateInfo.getDefault();
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("Calling receive with params: ");
        ikeycmd.debugMsg("filename: " + string3);
        ikeycmd.debugMsg("format: " + bl);
        ikeycmd.debugMsg("default: " + bl2);
        ikeycmd.debugMsg("\n");
        keyDatabase.getKeyDatabaseOperator().receiveCertificate(string3, bl, bl2);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void add(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        String string4 = cLICertificateInfo.getFileName();
        boolean bl = cLICertificateInfo.getFormat();
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("Calling addCACertificate(" + string3 + ", " + string4 + "' " + bl + ")\n");
        keyDatabase.getKeyDatabaseOperator().addCACertificate(string3, string4, bl);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void list(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        Vector vector = null;
        String string = null;
        KeyItem keyItem = null;
        String string2 = cLICertificateInfo.cliDb.getName();
        String string3 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string2);
        ikeycmd.debugMsg("keyDbPassword: " + string3);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string2, string3, l);
        keyDatabase.getKeyDatabaseOperator().open();
        String string4 = cLICertificateInfo.getList();
        if (string4.equalsIgnoreCase("all")) {
            String string5;
            int n2;
            vector = new Vector();
            Vector vector2 = keyDatabase.getCaCertLabelList();
            Vector vector3 = keyDatabase.getSiteCertLabelList();
            Vector vector4 = keyDatabase.getMyCertLabelList();
            if (vector2 != null) {
                n2 = 0;
                while (n2 < vector2.size()) {
                    string5 = (String)vector2.elementAt(n2);
                    vector.addElement(string5);
                    ++n2;
                }
            }
            if (vector3 != null) {
                n2 = 0;
                while (n2 < vector3.size()) {
                    string5 = (String)vector3.elementAt(n2);
                    vector.addElement(string5);
                    ++n2;
                }
            }
            if (vector4 != null) {
                n2 = 0;
                while (n2 < vector4.size()) {
                    string5 = (String)vector4.elementAt(n2);
                    vector.addElement(string5);
                    ++n2;
                }
            }
        } else if (string4.equalsIgnoreCase("CA")) {
            vector = keyDatabase.getCaCertLabelList();
        } else if (string4.equalsIgnoreCase("site")) {
            if (n == 1) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_CMS_NO_GOOD"));
            }
            vector = keyDatabase.getSiteCertLabelList();
        } else if (string4.equalsIgnoreCase("personal")) {
            vector = keyDatabase.getMyCertLabelList();
        }
        if (vector == null || vector.size() == 0) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
        }
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_LIST_MSG") + " " + string2);
        int n3 = 0;
        while (n3 < vector.size()) {
            string = (String)vector.elementAt(n3);
            keyItem = keyDatabase.getKeyDatabaseOperator().getKeyItemByLabel(string);
            System.out.println("   " + string);
            ++n3;
        }
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void moreDetails(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        String string = "  ";
        String string2 = "    ";
        String string3 = "      ";
        String string4 = "        ";
        cLICertificateInfo.init();
        String string5 = cLICertificateInfo.cliDb.getName();
        String string6 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLICertificateManager: moreDetails()");
        ikeycmd.debugMsg("KeyDbFileName: " + string5);
        ikeycmd.debugMsg("keyDbPassword: " + string6);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string5, string6, l);
        String string7 = cLICertificateInfo.getLabel();
        KeyItem keyItem = null;
        keyDatabase.getKeyDatabaseOperator().open();
        keyItem = keyDatabase.getKeyDatabaseOperator().getKeyItemByLabel(string7);
        if (keyItem != null && keyItem.hasCertificate()) {
            System.out.println("\n\n");
            if (keyItem.getKeyLabel().compareTo(string7) == 0) {
                System.out.println(ikeycmd.getNLSResString("GUI_LABEL_KEY_LABEL_COLON") + " " + keyItem.getKeyLabel());
            }
            System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_TBS_CERT"));
            Vector vector = keyItem.getCertificateChain();
            if (vector != null && vector.size() > 0) {
                String string8;
                Object object;
                Object object2;
                String string9;
                String string10;
                Object object3;
                Object object4;
                String string11;
                RDNAttribute[][] rDNAttributeArray;
                ASN1OID aSN1OID;
                CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                X509Cert x509Cert = null;
                try {
                    x509Cert = new X509Cert(certificateItem.getEncoded(), 0, certificateItem.getLength());
                }
                catch (ASN1Exception aSN1Exception) {
                    // empty catch block
                }
                System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " X509 V" + certificateItem.getVersion());
                System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SERIAL") + " " + certificateItem.getSerialNumber());
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ISSUER"));
                X500Name x500Name = x509Cert.issuer();
                RDNAttribute[][] rDNAttributeArray2 = x500Name.attributes();
                if (rDNAttributeArray2 != null) {
                    int n2 = 0;
                    while (n2 < rDNAttributeArray2.length) {
                        int n3 = 0;
                        while (n3 < rDNAttributeArray2[n2].length) {
                            aSN1OID = rDNAttributeArray2[n2][n3].keyToASN1OID();
                            rDNAttributeArray = aSN1OID.toString();
                            string11 = rDNAttributeArray2[n2][n3].valueToString();
                            object4 = CLICertificateManager.getAttributeName(aSN1OID);
                            System.out.println(string3 + (String)object4);
                            System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)rDNAttributeArray);
                            System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + string11);
                            ++n3;
                        }
                        ++n2;
                    }
                }
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_VALIDITY"));
                Date date = certificateItem.getValidNotBefore();
                Date date2 = certificateItem.getValidNotAfter();
                if (date != null && date2 != null) {
                    System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_NOT_BEFORE") + ": " + date.toString());
                    System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_NOT_AFTER") + ": " + date2.toString());
                }
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT"));
                aSN1OID = x509Cert.subject();
                rDNAttributeArray = aSN1OID.attributes();
                if (rDNAttributeArray != null) {
                    int n4 = 0;
                    while (n4 < rDNAttributeArray.length) {
                        int n5 = 0;
                        while (n5 < rDNAttributeArray[n4].length) {
                            object3 = rDNAttributeArray[n4][n5].keyToASN1OID();
                            string10 = object3.toString();
                            string9 = rDNAttributeArray[n4][n5].valueToString();
                            String string12 = CLICertificateManager.getAttributeName((ASN1OID)object3);
                            System.out.println(string3 + string12);
                            System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + string10);
                            System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + string9);
                            ++n5;
                        }
                        ++n4;
                    }
                }
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"));
                string11 = x509Cert.subjectKeyAlgId();
                object4 = null;
                object3 = x509Cert.subjectPublicKeyInfo();
                if (object3 != null && ((byte[])object3).length > 0) {
                    string10 = new BERDecoder(object3);
                    string9 = new SubjectPublicKeyInfo();
                    try {
                        string9.decode((ASN1Decoder)string10, (AlgId)string11);
                        object4 = string9.computePublicKeyAsByteArray();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string11 != null) {
                    string10 = string11.asn1oid();
                    if (string10 != null && (string9 = string10.toString()) != null && string9.length() > 0) {
                        System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string9);
                    }
                    switch (string11.parameterStatus()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                            break;
                        }
                        case 2: {
                            string9 = string11.toString();
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string9);
                            break;
                        }
                    }
                }
                if (object4 != null && ((String)object4).length > 0) {
                    string10 = CLICertificateManager.getHexDumpForMoreDetails((byte[])object4);
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY") + ":\n" + string3 + string10);
                }
                string10 = null;
                try {
                    string10 = x509Cert.extensions(false);
                }
                catch (ASN1Exception aSN1Exception) {
                    // empty catch block
                }
                int n6 = string10.numberOfExtensions();
                if (string10 != null && n6 > 0) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_EXTENSIONS"));
                    int n7 = 0;
                    while (n7 < n6) {
                        object2 = string10.extension(n7);
                        object = "";
                        string8 = "";
                        ASN1OID aSN1OID2 = null;
                        String string13 = "";
                        String string14 = "";
                        int n8 = 0;
                        boolean bl = false;
                        String string15 = ikeycmd.getNLSResString("GUI_LABEL_EXTNID");
                        String string16 = ikeycmd.getNLSResString("GUI_LABEL_CRITICAL");
                        String string17 = ikeycmd.getNLSResString("GUI_LABEL_EXTNVALUE");
                        aSN1OID2 = object2.asn1oid();
                        object = aSN1OID2.toString();
                        string8 = object;
                        if (string8.equals("2.5.29.9")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_DIRECTORY_ATTRIBUTES");
                            n8 = 9;
                        } else if (string8.equals("2.5.29.14")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_KEY_IDENTIFIER");
                            n8 = 14;
                        } else if (string8.equals("2.5.29.15")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_KEY_USAGE");
                            n8 = 15;
                        } else if (string8.equals("2.5.29.16")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_PRIVATE_KEY_USAGE_PERIOD");
                            n8 = 16;
                        } else if (string8.equals("2.5.29.17")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_ALTERNATIVE_NAME");
                            n8 = 17;
                        } else if (string8.equals("2.5.29.18")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_ISSUER_ALTERNATIVE_NAMES");
                            n8 = 18;
                        } else if (string8.equals("2.5.29.19")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_BASIC_CONSTRAINTS");
                            n8 = 19;
                        } else if (string8.equals("2.5.29.30")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_NAME_CONSTRAINTS");
                            n8 = 30;
                        } else if (string8.equals("2.5.29.31")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_CRL_DISTRIBUTION_POINTS");
                            n8 = 31;
                        } else if (string8.equals("2.5.29.32")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_CERTIFICATE_POLICIES");
                            n8 = 32;
                        } else if (string8.equals("2.5.29.33")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_POLICY_MAPPINGS");
                            n8 = 33;
                        } else if (string8.equals("2.5.29.35")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_AUTH_KEY_ID");
                            n8 = 35;
                        } else if (string8.equals("2.5.29.36")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_POLICY_CONSTRAINTS");
                            n8 = 36;
                        } else if (string8.equals("2.5.29.37")) {
                            string8 = ikeycmd.getNLSResString("GUI_LABEL_EXT_KEY_USAGE_FIELD");
                            n8 = 37;
                        }
                        System.out.println(string3 + string8);
                        System.out.println(string4 + string15 + ": " + (String)object);
                        string13 = object2.isCritical() ? ikeycmd.getNLSResString("GUI_LABEL_TRUE") : ikeycmd.getNLSResString("GUI_LABEL_FALSE");
                        System.out.println(string4 + string16 + ": " + string13);
                        try {
                            string14 = object2.toBERDump();
                        }
                        catch (ASN1Exception aSN1Exception) {
                            bl = true;
                        }
                        if (!bl && object2.isValid()) {
                            switch (n8) {
                                case 9: {
                                    string14 = ((SubjectDirectoryAttributes)object2).valueToString();
                                    break;
                                }
                                case 14: {
                                    string14 = ((SubjectKeyIdentifier)object2).valueToString();
                                    break;
                                }
                                case 15: {
                                    string14 = ((KeyUsage)object2).valueToString();
                                    break;
                                }
                                case 16: {
                                    string14 = ((PrivateKeyUsagePeriod)object2).valueToString();
                                    break;
                                }
                                case 17: {
                                    string14 = ((AltNames)object2).valueToString();
                                    break;
                                }
                                case 18: {
                                    string14 = ((AltNames)object2).valueToString();
                                    break;
                                }
                                case 19: {
                                    string14 = ((BasicConstraints)object2).valueToString();
                                    break;
                                }
                                case 30: {
                                    string14 = ((NameConstraints)object2).valueToString();
                                    break;
                                }
                                case 31: {
                                    string14 = ((CRLDistributionPoints)object2).valueToString();
                                    break;
                                }
                                case 32: {
                                    break;
                                }
                                case 33: {
                                    string14 = ((PolicyMappings)object2).valueToString();
                                    break;
                                }
                                case 35: {
                                    string14 = ((AuthorityKeyIdentifier)object2).valueToString();
                                    break;
                                }
                                case 36: {
                                    string14 = ((PolicyConstraints)object2).valueToString();
                                    break;
                                }
                                case 37: {
                                    string14 = ((ExtKeyUsage)object2).valueToString();
                                    break;
                                }
                            }
                        } else {
                            string14 = ikeycmd.getNLSResString("GUI_LABEL_INFO_NOT_VALID_ERROR");
                        }
                        System.out.println(string4 + string17 + ": " + string14);
                        ++n7;
                    }
                }
                AlgId algId = x509Cert.signatureKeyAlgId();
                object2 = certificateItem.getSignature();
                System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_SIG_ALG"));
                if (algId != null) {
                    object = algId.asn1oid();
                    if (object != null && (string8 = object.toString()) != null && string8.length() > 0) {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string8);
                    }
                    switch (algId.parameterStatus()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                            break;
                        }
                        case 2: {
                            string8 = algId.toString();
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string8);
                            break;
                        }
                    }
                }
                if (object2 != null) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SIG_VALUE") + ":\n" + string3 + CLICertificateManager.getHexDumpForMoreDetails(object2));
                }
                System.out.println("\n");
            }
        }
        keyDatabase.getKeyDatabaseOperator().close();
    }

    private static String getAttributeName(ASN1OID aSN1OID) {
        String string = null;
        if (aSN1OID != null) {
            string = aSN1OID.equals((Object)X500Name.COMMON_NAME) ? ikeycmd.getNLSResString("GUI_LABEL_COMMON_NAME") : (aSN1OID.equals((Object)X500Name.SERIAL_NUMBER) ? ikeycmd.getNLSResString("GUI_LABEL_SERIALNO") : (aSN1OID.equals((Object)X500Name.COUNTRY) ? ikeycmd.getNLSResString("GUI_LABEL_COUNTRY") : (aSN1OID.equals((Object)X500Name.LOCATION) ? ikeycmd.getNLSResString("GUI_LABEL_LOCALITY") : (aSN1OID.equals((Object)X500Name.STATE) ? ikeycmd.getNLSResString("GUI_LABEL_STATE") : (aSN1OID.equals((Object)X500Name.STREET) ? ikeycmd.getNLSResString("GUI_LABEL_STREET") : (aSN1OID.equals((Object)X500Name.ORGANIZATION) ? ikeycmd.getNLSResString("GUI_LABEL_ORG") : (aSN1OID.equals((Object)X500Name.ORGANIZATIONAL_UNIT) ? ikeycmd.getNLSResString("GUI_LABEL_ORG_UNIT") : (aSN1OID.equals((Object)X500Name.TITLE) ? ikeycmd.getNLSResString("GUI_LABEL_TITLE2") : (aSN1OID.equals((Object)X500Name.ZIP) ? ikeycmd.getNLSResString("GUI_LABEL_ZIPCODE") : (aSN1OID.equals((Object)X500Name.EMAIL) ? ikeycmd.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : aSN1OID.toString()))))))))));
        }
        return string;
    }

    private static String getHexDumpForMoreDetails(byte[] byArray) {
        String string = new String("");
        String string2 = "      ";
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n" + string2;
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    public static void details(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        KeyItem keyItem = null;
        keyDatabase.getKeyDatabaseOperator().open();
        keyItem = keyDatabase.getKeyDatabaseOperator().getKeyItemByLabel(string3);
        if (keyItem != null && keyItem.hasCertificate()) {
            Vector vector;
            System.out.println("\n\n");
            if (keyItem.getKeyLabel().compareTo(string3) == 0) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_LABEL") + " " + keyItem.getKeyLabel());
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_KEYSIZE") + " " + keyItem.getKeySize());
            }
            if ((vector = keyItem.getCertificateChain()) != null && vector.size() > 0) {
                String string4;
                String string5;
                DNItem dNItem;
                CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " X509 V" + certificateItem.getVersion());
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SERIAL") + " " + certificateItem.getSerialNumber());
                DNItem dNItem2 = certificateItem.getIssuer();
                if (dNItem2 != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_ISSUER") + " " + dNItem2.toStringWithoutTag());
                }
                if ((dNItem = certificateItem.getSubject()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SUBJECT") + " " + dNItem.toStringWithoutTag());
                }
                Date date = certificateItem.getValidNotBefore();
                String string6 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date);
                Date date2 = certificateItem.getValidNotAfter();
                String string7 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date2);
                if (date != null && date2 != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VALID") + " " + string6 + " " + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_TO") + " " + string7);
                }
                if ((string5 = certificateItem.getFingerPrint()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_FINGER") + " " + string5);
                }
                if ((string4 = certificateItem.getSigAlgorithmIdOID()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SIG") + " " + string4);
                }
                if (keyItem.isTrusted()) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_ENABLED"));
                } else {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_DISABLED"));
                }
                System.out.println("\n");
            }
        }
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void delete(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        keyDatabase.getKeyDatabaseOperator().open();
        if (string3 == null || string3.equals("")) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
        }
        ikeycmd.debugMsg("Deleteing Label: " + string3 + "\n");
        keyDatabase.getKeyDatabaseOperator().deleteKeyByLabel(string3);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void modify(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        boolean bl = cLICertificateInfo.getTrust();
        String string3 = cLICertificateInfo.getLabel();
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("Calling setKeyTrust(" + string3 + ", " + bl + ")\n");
        Vector vector = keyDatabase.getMyCertLabelList();
        if (vector != null && vector.contains(string3)) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_TRUST_STATUS_NOT_APPLY"));
        } else {
            keyDatabase.getKeyDatabaseOperator().setKeyTrust(string3, bl);
        }
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void importCert(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        String string3 = cLICertificateInfo.getTargetDb();
        String string4 = cLICertificateInfo.getTargetPassword();
        int n2 = cLICertificateInfo.getTargetDbType();
        String string5 = cLICertificateInfo.getLabel();
        int n3 = cLICertificateInfo.getEncryption();
        boolean bl = cLICertificateInfo.getFormat();
        if (n == 4) {
            switch (n2) {
                case 1: {
                    ikeycmd.debugMsg("KeyDbFileName: " + string3);
                    ikeycmd.debugMsg("keyDbPassword: " + string4);
                    ikeycmd.debugMsg("keyDbType:  " + n2);
                    ikeycmd.debugMsg("\n");
                    CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string3, string4, l);
                    KMpkcs12 kMpkcs12 = new KMpkcs12(string, string2);
                    cMSKeyDatabase.getKeyDatabaseOperator().open();
                    ikeycmd.debugMsg("calling importPCKS12File(pkcs)\nfilename: " + string + "\n " + "password: " + string2 + "\n");
                    cMSKeyDatabase.importFromPKCSFile(kMpkcs12);
                    cMSKeyDatabase.getKeyDatabaseOperator().close();
                    break;
                }
                case 3: {
                    ikeycmd.debugMsg("KeyDbFileName: " + string3);
                    ikeycmd.debugMsg("keyDbPassword: " + string4);
                    ikeycmd.debugMsg("keyDbType:  " + n2);
                    ikeycmd.debugMsg("\n");
                    SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string3, string4, l);
                    sSLightKeyDatabase.getKeyDatabaseOperator().open();
                    ikeycmd.debugMsg("calling importFromPFXFile(" + string + ", " + string2 + ", " + string5 + ")\n");
                    sSLightKeyDatabase.importFromPFXFile(string, string2);
                    sSLightKeyDatabase.getKeyDatabaseOperator().close();
                    break;
                }
                case 2: {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_WEBDB_NOT_SUPPORTED"));
                }
                default: {
                    ikeycmd.debugMsg("Impossible");
                    break;
                }
            }
        } else if (n == 1 && n2 == 1) {
            if (string5 == null) {
                ikeycmd.displayHelp(null, 235);
            }
            ikeycmd.debugMsg("Import: In database to database branch");
            ikeycmd.debugMsg("KeyDbFileName: " + string3);
            ikeycmd.debugMsg("keyDbPassword: " + string4);
            ikeycmd.debugMsg("keyDbType:  " + n2);
            ikeycmd.debugMsg("\n");
            KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n2, string3, string4, l);
            keyDatabase.getKeyDatabaseOperator().open();
            ikeycmd.debugMsg("KeyDbFileName: " + string);
            ikeycmd.debugMsg("keyDbPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            KeyDatabase keyDatabase2 = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
            keyDatabase2.getKeyDatabaseOperator().open();
            String[] stringArray = new String[]{string5};
            keyDatabase.importFromKeyDb(keyDatabase2, stringArray);
            ikeycmd.debugMsg("Getting label: " + string5);
            keyDatabase.getKeyDatabaseOperator().close();
            keyDatabase2.getKeyDatabaseOperator().close();
        } else if (n == 1 && n2 == 3) {
            ikeycmd.debugMsg("KeyDbFileName: " + string);
            ikeycmd.debugMsg("keyDbPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            ikeycmd.debugMsg("Exporting From CMS to PKCS12 file: " + string3);
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2, l);
            cMSKeyDatabase.getKeyDatabaseOperator().open();
            Date date = new Date();
            String string6 = new String("temp." + date.getTime());
            File file = new File(string6);
            ikeycmd.debugMsg("calling exportPCKS12File(" + string6 + ", " + string4 + ", " + string5 + ")");
            cMSKeyDatabase.exportPKCSFile(string6, string4, string5, n3);
            ikeycmd.debugMsg("KeyDbFileName: " + string3);
            ikeycmd.debugMsg("keyDbPassword: " + string4);
            ikeycmd.debugMsg("keyDbType:  " + n2);
            ikeycmd.debugMsg("\n");
            SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string3, string4);
            sSLightKeyDatabase.getKeyDatabaseOperator().open();
            ikeycmd.debugMsg("calling importFromPFXFile(" + string6 + ", " + string4 + ")\n");
            sSLightKeyDatabase.importFromPFXFile(string6, string4);
            sSLightKeyDatabase.getKeyDatabaseOperator().close();
            cMSKeyDatabase.getKeyDatabaseOperator().close();
            ikeycmd.debugMsg("Deleting tempfile " + string6 + "\n");
            file.delete();
        } else if (n == 3 && n2 == 1) {
            ikeycmd.debugMsg("KeyDbFileName: " + string);
            ikeycmd.debugMsg("keyDbPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            ikeycmd.debugMsg("Exporting From CMS to PKCS12 file: " + string3);
            SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string, string2);
            sSLightKeyDatabase.getKeyDatabaseOperator().open();
            String[] stringArray = new String[]{string5};
            Date date = new Date();
            String string7 = new String("temp." + date.getTime());
            File file = new File(string7);
            ikeycmd.debugMsg("calling exportPCKS12File(" + string7 + ", " + string4 + ", " + stringArray[0] + ")");
            sSLightKeyDatabase.exportToPFXFile(string7, string4, stringArray);
            ikeycmd.debugMsg("KeyDbFileName: " + string3);
            ikeycmd.debugMsg("keyDbPassword: " + string4);
            ikeycmd.debugMsg("keyDbType:  " + n2);
            ikeycmd.debugMsg("\n");
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string3, string4);
            KMpkcs12 kMpkcs12 = new KMpkcs12(string7, string4);
            cMSKeyDatabase.getKeyDatabaseOperator().open();
            ikeycmd.debugMsg("calling importPCKS12File(pkcs)\nfilename: " + string3 + "\n " + "password: " + string4);
            cMSKeyDatabase.importFromPKCSFile(kMpkcs12);
            cMSKeyDatabase.getKeyDatabaseOperator().close();
            sSLightKeyDatabase.getKeyDatabaseOperator().close();
            ikeycmd.debugMsg("Deleting tempfile " + string7 + "\n");
            file.delete();
        } else {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_WEBDB_NOT_SUPPORTED"));
        }
    }

    public static void export(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        String string3 = cLICertificateInfo.getTargetDb();
        String string4 = cLICertificateInfo.getTargetPassword();
        int n2 = cLICertificateInfo.getTargetDbType();
        String string5 = cLICertificateInfo.getLabel();
        int n3 = cLICertificateInfo.getEncryption();
        boolean bl = cLICertificateInfo.getFormat();
        boolean bl2 = cLICertificateInfo.getDefault();
        if (n2 == 4) {
            switch (n) {
                case 1: {
                    ikeycmd.debugMsg("KeyDbFileName: " + string);
                    ikeycmd.debugMsg("keyDbPassword: " + string2);
                    ikeycmd.debugMsg("keyDbType:  " + n);
                    ikeycmd.debugMsg("\n");
                    ikeycmd.debugMsg("Exporting From CMS to PKCS12 file: " + string3);
                    CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2, l);
                    cMSKeyDatabase.getKeyDatabaseOperator().open();
                    ikeycmd.debugMsg("calling exportPCKS12File(" + string3 + ", " + string4 + ", " + string5 + ")");
                    cMSKeyDatabase.exportPKCSFile(string3, string4, string5, n3);
                    cMSKeyDatabase.getKeyDatabaseOperator().close();
                    break;
                }
                case 3: {
                    ikeycmd.debugMsg("KeyDbFileName: " + string);
                    ikeycmd.debugMsg("keyDbPassword: " + string2);
                    ikeycmd.debugMsg("keyDbType:  " + n);
                    ikeycmd.debugMsg("\n");
                    ikeycmd.debugMsg("Exporting From SSLight to PKCS12 file: " + string3);
                    SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string, string2, l);
                    sSLightKeyDatabase.getKeyDatabaseOperator().open();
                    String[] stringArray = new String[]{string5};
                    ikeycmd.debugMsg("calling exportToPFXFile(" + string3 + ", " + string4 + ", " + string5 + ")\n");
                    sSLightKeyDatabase.exportToPFXFile(string3, string4, stringArray);
                    sSLightKeyDatabase.getKeyDatabaseOperator().close();
                    break;
                }
                case 2: {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_WEBDB_NOT_SUPPORTED"));
                }
                default: {
                    ikeycmd.debugMsg("Impossible");
                    break;
                }
            }
        } else if (n == 1 && n2 == 1) {
            ikeycmd.debugMsg("KeyDbFileName: " + string);
            ikeycmd.debugMsg("keyDbPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
            keyDatabase.getKeyDatabaseOperator().open();
            ikeycmd.debugMsg("Source database " + string + " opened\n");
            ikeycmd.debugMsg("Target filename: " + string3);
            ikeycmd.debugMsg("Target password: " + string4);
            ikeycmd.debugMsg("Target type: " + n2 + "\n");
            KeyDatabase keyDatabase2 = CLIDatabaseManager.makeKeyDatabase(n2, string3, string4, l);
            File file = new File(string3);
            ikeycmd.debugMsg("\nChecking for the existence of: " + string3);
            if (!file.exists()) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
            }
            keyDatabase2.getKeyDatabaseOperator().open();
            String[] stringArray = new String[]{string5};
            keyDatabase.exportToKeyDb(keyDatabase2, stringArray);
            keyDatabase2.getKeyDatabaseOperator().close();
            keyDatabase.getKeyDatabaseOperator().close();
        } else if (n == 1 && n2 == 3) {
            ikeycmd.debugMsg("KeyDbFileName: " + string);
            ikeycmd.debugMsg("keyDbPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            ikeycmd.debugMsg("Exporting From CMS to PKCS12 file: " + string3);
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2, l);
            cMSKeyDatabase.getKeyDatabaseOperator().open();
            Date date = new Date();
            String string6 = new String("temp." + date.getTime());
            File file = new File(string6);
            ikeycmd.debugMsg("calling exportPCKS12File(" + string6 + ", " + string4 + ", " + string5 + ")\n");
            cMSKeyDatabase.exportPKCSFile(string6, string4, string5, n3);
            ikeycmd.debugMsg("KeyDbFileName: " + string3);
            ikeycmd.debugMsg("keyDbPassword: " + string4);
            ikeycmd.debugMsg("keyDbType:  " + n2);
            ikeycmd.debugMsg("\n");
            SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string3, string4);
            sSLightKeyDatabase.getKeyDatabaseOperator().open();
            sSLightKeyDatabase.importFromPFXFile(string6, string4);
            sSLightKeyDatabase.getKeyDatabaseOperator().close();
            cMSKeyDatabase.getKeyDatabaseOperator().close();
            ikeycmd.debugMsg("Deleting tempfile " + string6 + "\n");
            file.delete();
        } else if (n == 3 && n2 == 1) {
            ikeycmd.debugMsg("KeyDbFileName: " + string);
            ikeycmd.debugMsg("keyDbPassword: " + string2);
            ikeycmd.debugMsg("keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            ikeycmd.debugMsg("Exporting From CMS to PKCS12 file: " + string3 + "\n");
            SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string, string2);
            sSLightKeyDatabase.getKeyDatabaseOperator().open();
            String[] stringArray = new String[]{string5};
            Date date = new Date();
            String string7 = new String("temp." + date.getTime());
            File file = new File(string7);
            ikeycmd.debugMsg("calling exportPCKS12File(" + string7 + ", " + string4 + ", " + string5 + ")\n");
            sSLightKeyDatabase.exportToPFXFile(string7, string4, stringArray);
            ikeycmd.debugMsg("KeyDbFileName: " + string3);
            ikeycmd.debugMsg("keyDbPassword: " + string4);
            ikeycmd.debugMsg("keyDbType:  " + n2);
            ikeycmd.debugMsg("\n");
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string3, string4);
            KMpkcs12 kMpkcs12 = new KMpkcs12(string7, string4);
            cMSKeyDatabase.getKeyDatabaseOperator().open();
            ikeycmd.debugMsg("calling importPCKS12File(pkcs)\nfilename: " + string3 + "\n " + "password: " + string4 + "\n");
            cMSKeyDatabase.importFromPKCSFile(kMpkcs12);
            cMSKeyDatabase.getKeyDatabaseOperator().close();
            sSLightKeyDatabase.getKeyDatabaseOperator().close();
            ikeycmd.debugMsg("Deleting tempfile " + string7 + "\n");
            file.delete();
        } else {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_WEBDB_NOT_SUPPORTED"));
        }
    }

    public static void extract(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        String string4 = cLICertificateInfo.getExtractTarget();
        boolean bl = cLICertificateInfo.getFormat();
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("Calling extractCertificate(" + string3 + ", " + string4 + ", " + bl + ")\n");
        keyDatabase.getKeyDatabaseOperator().extractCertificate(string3, string4, bl);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void sign(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        ikeycmd.debugMsg("Verifying that we have a CMS database\n");
        if (n != 1) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_SIGN_DB_TYPE"));
        }
        CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        int n2 = cLICertificateInfo.getVersion();
        cMSKeyDatabase.getKeyDatabaseOperator().open();
        KeyItem keyItem = cMSKeyDatabase.getKeyItemByLabel(string3);
        if (keyItem != null && keyItem.hasCertificate()) {
            Vector vector = keyItem.getCertificateChain();
            if (vector != null && vector.size() > 0) {
                CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                String string4 = certificateItem.getSerialNumber();
                int n3 = (int)cLICertificateInfo.getExpire();
                String string5 = cLICertificateInfo.getTargetDb();
                String string6 = cLICertificateInfo.getFileName();
                boolean bl = cLICertificateInfo.getFormat();
                ikeycmd.debugMsg("Calling issueCertificate with params: ");
                ikeycmd.debugMsg("label: " + string3 + " \nversion: " + n2 + " \nserialNumber: " + string4 + " \nexpire: " + n3 + " \ntarget: " + string5 + " \ncertFileName: " + string6 + " \nis base 64 armored: " + bl + "\n");
                cMSKeyDatabase.issueCertificate(string3, n2, string4, n3, string6, string5, bl);
                cMSKeyDatabase.getKeyDatabaseOperator().close();
            }
        } else {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
        }
    }

    public static void setDefault(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("Calling setDefaultKey(" + string3 + ")\n");
        keyDatabase.getKeyDatabaseOperator().setDefaultKey(string3);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void getDefault(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        keyDatabase.getKeyDatabaseOperator().open();
        KeyItem keyItem = keyDatabase.getKeyDatabaseOperator().getDefaultKeyItem();
        String string3 = keyItem.getKeyLabel();
        ikeycmd.debugMsg("Calling setLabel(" + string3 + ")\n");
        cLICertificateInfo.setLabel(string3);
        CLICertificateManager.details(cLICertificateInfo);
        keyDatabase.getKeyDatabaseOperator().close();
    }
}

