/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.BERObjectParser;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMUtil;

public class CertificateRequestItem
extends BERObject
implements BERObjectParser {
    public static final short REQ_TYPE_PKCS10 = 1;
    public static final short REQ_TYPE_PEM = 2;
    private short requestType;
    private byte[] certReqInfoBER;
    private byte[] signature;
    private BERObject sigAlgIdBER;
    private String sigAlgIdOID;
    private String sigAlgIdOIDName;
    private short keySize;
    private DNItem subject;
    private BERObject spkiBER;
    private BERObject attribBER;
    private boolean isAttribPresent;

    public CertificateRequestItem(byte[] byArray) {
        super(byArray);
    }

    public CertificateRequestItem() {
        this(0, null, null, null, null, null, null, null, null, null);
    }

    public CertificateRequestItem(short s, DNItem dNItem, BERObject bERObject, BERObject bERObject2, byte[] byArray, BERObject bERObject3, String string, String string2) {
        this(s, dNItem, bERObject, bERObject2, byArray, bERObject3, string, string2, null, null);
        this.collapse();
    }

    public CertificateRequestItem(short s, DNItem dNItem, BERObject bERObject, BERObject bERObject2, byte[] byArray, BERObject bERObject3, String string, String string2, byte[] byArray2, byte[] byArray3) {
        this.requestType = 1;
        this.keySize = s;
        this.subject = dNItem;
        this.signature = byArray;
        this.sigAlgIdBER = bERObject3;
        this.sigAlgIdOID = string;
        this.sigAlgIdOIDName = string2;
        this.spkiBER = bERObject;
        this.attribBER = bERObject2;
        this.isAttribPresent = this.attribBER != null;
        this.setEncoded(byArray2);
        this.certReqInfoBER = byArray3;
    }

    public void expand() {
    }

    public void collapse() {
        this.berData = null;
    }

    public short getReqType() {
        return this.requestType;
    }

    public byte[] getCertReqInfoBER() {
        return this.certReqInfoBER;
    }

    public String getFingerPrint() {
        return KMUtil.getMD5(this.certReqInfoBER);
    }

    public short getKeySize() {
        return this.keySize;
    }

    public DNItem getSubject() {
        return this.subject;
    }

    public BERObject getSubjectPublicKeyInfoBER() {
        return this.spkiBER;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSigAlgorithmIdOID() {
        return this.sigAlgIdOID;
    }

    public String getSigAlgorithmIdOIDName() {
        return this.sigAlgIdOIDName;
    }

    public BERObject getAttribute() {
        return this.attribBER;
    }

    public boolean isAttributePresent() {
        return this.isAttribPresent;
    }

    public String toString() {
        return this.paramString();
    }

    public String getTypeName() {
        return this.requestType == 1 ? "PKCS10 Request" : "PEM Request";
    }

    public String paramString() {
        String string = this.subject == null ? "null" : this.subject.toString();
        try {
            return super.toString() + ", type=" + this.getTypeName() + ", keySize=" + this.keySize + ", isAttribPresent=" + this.isAttribPresent + ", subject=" + string + ", signature algorithm=" + this.sigAlgIdOIDName + "(" + this.sigAlgIdOID + ")";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
        return null;
    }
}

