/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.IkeymanLogger;
import com.ibm.gsk.ikeyman.basic.KMExtensionItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KMpkcs12;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class CMSKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    public native int c_CreateNewKeyDb(String var1, String var2, long var3);

    public native int c_CreateNewKeyDbFIPS(String var1, String var2, long var3);

    public native int c_OpenKeyDb(String var1, String var2);

    public native int c_GetKeyDbPwdExpireTime(String var1, String var2, Object var3);

    public native int c_BuildKeyLabelList(String var1, String var2);

    public native KeyItem c_GetKeyItemByLabel(String var1, String var2, String var3, boolean var4);

    public native KeyItem c_GetDefaultKeyItem(String var1, String var2);

    public native KeyItem[] c_GetKeyItemsByPublicKey(String var1, String var2, int var3, byte[] var4);

    public native boolean c_ChangeKeyDbPwd(String var1, String var2, String var3, long var4);

    public static native boolean c_StashKeyDbPwd(String var0, String var1);

    public native int c_CreateNewSelfSignedCertificate(String var1, String var2, int var3, String var4, boolean var5, int var6, DNItem var7, int var8, String var9, boolean var10);

    public native int c_CreateNewSelfSignedCertificateSigExt(String var1, String var2, int var3, String var4, boolean var5, int var6, DNItem var7, int var8, int var9, int var10, byte[] var11, String var12, boolean var13);

    public native int c_CreateNewCertRequest(String var1, String var2, String var3, int var4, DNItem var5, String var6, boolean var7);

    public native int c_CreateNewCertRequestSigExt(String var1, String var2, String var3, int var4, DNItem var5, int var6, int var7, byte[] var8, String var9, boolean var10);

    public native int c_IssueCertificate(String var1, String var2, String var3, int var4, String var5, int var6, String var7, String var8, boolean var9);

    public native int c_IssueCertificateSig(String var1, String var2, String var3, int var4, String var5, int var6, int var7, String var8, String var9, boolean var10);

    public native boolean c_IsPrivateKeyPresent(String var1, String var2, String var3);

    public native int c_InsertKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7, boolean var8, boolean var9);

    public native int c_InsertReqKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7);

    public native int c_DeleteKeyByLabel(String var1, String var2, String var3, boolean var4);

    public native int c_SetDefaultKey(String var1, String var2, String var3);

    public native int c_SetKeyTrust(String var1, String var2, String var3, boolean var4);

    public native int c_ExportToPFXFile(String var1, String var2, String var3, String var4, String[] var5);

    public native int c_ImportFromPFXFile(String var1, String var2, String var3, String var4);

    public native int c_ReceiveCert(String var1, String var2, String var3, boolean var4, boolean var5);

    public native int c_AddCaCert(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ExtractCert(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ExtractCertReq(String var1, String var2, String var3, String var4);

    public native int c_ExtractCertReqSig(String var1, String var2, String var3, int var4, String var5);

    public native boolean c_CheckCertAsRenewal(String var1, String var2, int var3, byte[] var4);

    public native int c_RenewCert(String var1, String var2, int var3, byte[] var4);

    public static native int c_Kyr2Kdb(String var0, String var1, String var2, String var3);

    public static native int c_Kdb2Kyr(String var0, String var1, String var2, String var3);

    public static native PrivateKeyInfoItem c_DecryptPrivateKey(int var0, byte[] var1, String var2);

    public static native EncryptedPrivateKeyInfoItem c_EncryptPrivateKey(int var0, byte[] var1, String var2);

    public native KeyItem[] c_GetKeyItemListByLabel(String var1, String var2, String var3);

    public static native CertificateItem[] c_ExtractCertFromPKCS7Data(String var0, boolean var1);

    public native boolean c_ValidateCertificateChain(String var1, String var2, byte[] var3, int var4);

    public static native boolean c_IsPasswordRequired(String var0);

    public CMSKeyDatabase() {
        this.type = 1;
        this.op = this;
    }

    public CMSKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 1;
        this.op = this;
    }

    public CMSKeyDatabase(String string, String string2) {
        super(1, string, string2);
        this.op = this;
    }

    public CMSKeyDatabase(String string, String string2, long l) {
        super(1, string, string2, l);
        this.op = this;
    }

    public CMSKeyDatabase(String string) {
        super(1, string);
        this.op = this;
    }

    public static boolean isPasswordNeeded(String string) {
        KMUtil.debugMsg("CMSKeyDatabase::isPasswordNeeded(), before calling c_IsPasswordRequired()");
        return CMSKeyDatabase.c_IsPasswordRequired(string);
    }

    public void create() throws CMSKeyDatabaseException {
        KMUtil.debugMsg("CMSKeyDatabase::create() 0000");
        int n = KMSystem.getInitSetting("DEFAULT_CMS_STORE_VER_V4") == null ? this.c_CreateNewKeyDb(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime) : this.c_CreateNewKeyDbFIPS(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
        if (n != 0) {
            KMUtil.debugMsg("CMSKeyDatabase::create() 9999-1, errCode=" + n);
            IkeymanLogger.error("CMSKeyDatabase", "create() Line 235", "Could not create a CMS database: keyDbFileName=" + this.keyDbFileName + "keyDbPwd=" + this.keyDbPwd + " errCode=" + n);
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE"));
        }
        this.buildKeyLabelList();
        KMUtil.debugMsg("CMSKeyDatabase::create() 9999");
    }

    public void createFIPS() throws CMSKeyDatabaseException {
        KMUtil.debugMsg("CMSKeyDatabase::createFIPS() 0000");
        int n = this.c_CreateNewKeyDbFIPS(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
        if (n != 0) {
            KMUtil.debugMsg("CMSKeyDatabase::createFIPS() 9999-1, errCode=" + n);
            IkeymanLogger.error("CMSKeyDatabase", "createFIPS() Line 253", "Could not create a CMS FIPS database: keyDbFileName=" + this.keyDbFileName + "keyDbPwd=" + this.keyDbPwd + " errCode=" + n);
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE"));
        }
        this.buildKeyLabelList();
        KMUtil.debugMsg("CMSKeyDatabase::createFIPS() 9999");
    }

    public void open() throws CMSKeyDatabaseException {
        KMUtil.debugMsg("CMSKeyDatabase::open() 0000, keyDbFileName=" + this.keyDbFileName + ", keyDbPwd=" + this.keyDbPwd);
        int n = this.c_OpenKeyDb(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            KMUtil.debugMsg("CMSKeyDatabase::open() 9999-1, errCode=" + n);
            IkeymanLogger.error("CMSKeyDatabase", "open() Line 256", "Could not open a CMS database: keyDbFileName=" + this.keyDbFileName + "keyDbPwd=" + this.keyDbPwd + " errCode=" + n);
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        this.buildKeyLabelList();
        KMUtil.debugMsg("CMSKeyDatabase::open() 9999");
    }

    public void close() {
    }

    public void save() {
    }

    public void rename(String string) throws IOException {
        File file = new File(this.keyDbFileName);
        String string2 = file.getCanonicalPath();
        String string3 = KMUtil.changeFileNameExtension(string2, ".rdb");
        String string4 = KMUtil.changeFileNameExtension(string2, ".crl");
        File file2 = new File(string3);
        File file3 = new File(string4);
        File file4 = new File(string);
        String string5 = file4.getCanonicalPath();
        String string6 = KMUtil.changeFileNameExtension(string5, ".rdb");
        String string7 = KMUtil.changeFileNameExtension(string5, ".crl");
        File file5 = new File(string6);
        File file6 = new File(string7);
        if (file.exists()) {
            file.renameTo(file4);
        }
        if (file2.exists()) {
            file2.renameTo(file5);
        }
        if (file3.exists()) {
            file3.renameTo(file6);
        }
    }

    public void delete() throws IOException, CMSKeyDatabaseException {
        String string;
        File file;
        File file2 = new File(this.keyDbFileName);
        String string2 = file2.getCanonicalPath();
        if (!file2.exists()) {
            IkeymanLogger.error("CMSKeyDatabase", "delete() Line 303", "Could note delete a CMS database: keyDbFileName=" + this.keyDbFileName + " because it does not exist.  Please check spelling or path.");
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
        file2.delete();
        String string3 = KMUtil.changeFileNameExtension(string2, ".rdb");
        File file3 = new File(string3);
        if (file3.exists()) {
            file3.delete();
        }
        if ((file = new File(string = KMUtil.changeFileNameExtension(string2, ".crl"))).exists()) {
            file.delete();
        }
    }

    public void makeCopyFromKyr(WEBDBKeyDatabase wEBDBKeyDatabase) throws CMSKeyDatabaseException {
        try {
            String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS);
            int n = CMSKeyDatabase.c_Kyr2Kdb(wEBDBKeyDatabase.getKeyDbFileName(), wEBDBKeyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
            if (n != 0) {
                IkeymanLogger.error("CMSKeyDatabase", "makeCopyFromKyr(WEBDBKeyDatabase) Line 326", "An error occurred while copying a Kyr to a Kdb of the same name: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " kyrDb name=" + wEBDBKeyDatabase.getKeyDbFileName() + " kyrDb password=" + wEBDBKeyDatabase.getKeyDbPwd() + " errCode=" + n);
                throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KYR2KDB"));
            }
            CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, this.keyDbPwd, 0L);
            cMSKeyDatabase.buildKeyLabelList();
            try {
                this.delete();
            }
            catch (KeyDatabaseException keyDatabaseException) {
                // empty catch block
            }
            this.copyKeyLabelLists(cMSKeyDatabase);
            cMSKeyDatabase.rename(this.keyDbFileName);
        }
        catch (IOException iOException) {
            IkeymanLogger.error("CMSKeyDatabase", "makeCopyFromKyr(WEBDBKeyDatabase) Line 347", "IO error, check file keyDbFileName=" + this.keyDbFileName + " or that you have read/write permissions to the path/file.");
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void reCreate(KeyDatabase var1_1) throws CMSKeyDatabaseException {
        block32: {
            if (this.keyDbFileName == null || this.keyDbFileName.equals(var1_1.getKeyDbFileName())) {
                IkeymanLogger.error("CMSKeyDatabase", "reCreate(KeyDatabase) Line 368", "Error while saving as a different file, check that you aren't using the same filename for the target file or that it's not null: target keyDbFileName=" + this.keyDbFileName + " source file=" + var1_1.getKeyDbFileName());
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
            }
            var2_2 = (KeyDatabaseOperator)var1_1;
            try {
                block34: {
                    block35: {
                        if (this.type == var1_1.getType()) break block34;
                        if (var1_1.getType() == 2) {
                            var3_3 = CMSKeyDatabase.c_Kyr2Kdb(var1_1.getKeyDbFileName(), var1_1.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                            if (var3_3 != 0) {
                                throw new CMSKeyDatabaseException(var3_3, KMSystem.getNLSErrString("GSKKM_ERR_KYR2KDB"));
                            }
                            this.buildKeyLabelList();
                            break block32;
                        }
                        if (var1_1.getType() != 3) break block35;
                        var2_2.open();
                        this.create();
                        var3_4 = this.getKeyLabelList();
                        var4_6 = new String[30];
                        var5_8 = new Vector<KeyItem>();
                        var6_11 = 0;
                        while (var6_11 < var3_4.size()) {
                            var4_6[var6_11] = (String)var3_4.elementAt(var6_11);
                            ++var6_11;
                        }
                        var7_12 = 0;
                        while (var7_12 < var4_6.length) {
                            this.deleteKeyByLabel(var4_6[var7_12]);
                            ++var7_12;
                        }
                        var8_13 = null;
                        var9_14 = new Enumeration[3];
                        var10_15 = var1_1.getCaCertLabelList();
                        if (var10_15 != null) {
                            var9_14[0] = var10_15.elements();
                        }
                        if ((var10_15 = var1_1.getMyCertLabelList()) != null) {
                            var9_14[1] = var10_15.elements();
                        }
                        if ((var10_15 = var1_1.getReqKeyLabelList()) != null) {
                            var9_14[2] = var10_15.elements();
                        }
                        var11_16 = 0;
                        while (var11_16 < 3) {
                            block36: {
                                if (var9_14[var11_16] != null) ** GOTO lbl92
                                break block36;
lbl-1000:
                                // 1 sources

                                {
                                    var12_17 = (String)var9_14[var11_16].nextElement();
                                    var13_19 = var2_2.getKeyItemByLabel(var12_17);
                                    if (var13_19.isDefault()) {
                                        var8_13 = var13_19.getKeyLabel();
                                    }
                                    if (var13_19.hasPrivateKey()) {
                                        var14_20 = var13_19.getEncryptedPrivateKeyInfoItem();
                                        var16_23 = new PrivateKeyInfo(var14_20.getEncoded());
                                        var17_25 = var16_23.getKeyBytes();
                                        var15_21 = new PrivateKeyInfoItem(var17_25);
                                        var18_27 = this.encryptPrivateKey((PrivateKeyInfoItem)var15_21);
                                        var13_19.setEncryptedPrivateKeyInfoItem((EncryptedPrivateKeyInfoItem)var18_27);
                                    }
                                    if (var11_16 == 1 && var13_19.hasMultipleCertificateChain()) {
                                        var14_20 = var13_19.getKeyItemsForCertChain();
                                        var15_22 = ((KeyItem[])var14_20).length - 1;
                                        while (var15_22 >= 0) {
                                            block33: {
                                                if (var14_20[var15_22].getKeyLabel() != null) {
                                                    try {
                                                        var14_20[var15_22].setTrusted(true);
                                                        this.insertKey((KeyItem)var14_20[var15_22]);
                                                        break block33;
                                                    }
                                                    catch (CMSKeyDatabaseException var16_24) {
                                                        var17_26 = var16_24.getErrCode();
                                                        var18_27 = CMSKeyDatabaseException.getErrKey(var17_26);
                                                        if (var18_27.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                                                            if (var15_22 == 0) {
                                                                throw var16_24;
                                                            }
                                                            break block33;
                                                        }
                                                        if (var18_27.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY_SIGNATURE")) break block33;
                                                        var19_28 = ((Object)var14_20).length - 1;
                                                        ** while (var19_28 >= var15_22)
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        try {
                                                            this.deleteKeyByLabel(var14_20[var11_16].getKeyLabel());
                                                        }
                                                        catch (CMSKeyDatabaseException var20_29) {
                                                            // empty catch block
                                                        }
                                                        --var19_28;
                                                        continue;
                                                    }
lbl79:
                                                    // 1 sources

                                                    throw var16_24;
                                                }
                                            }
                                            --var15_22;
                                        }
                                        continue;
                                    }
                                    if (var11_16 == 0) {
                                        var14_20 = ((CertificateItem)var13_19.getCertificateChain().elementAt(0)).getIssuer().toString();
                                        if (var14_20.equals(var15_21 = ((CertificateItem)var13_19.getCertificateChain().elementAt(0)).getSubject().toString())) {
                                            this.insertKey(var13_19);
                                            continue;
                                        }
                                        var5_8.addElement(var13_19);
                                        continue;
                                    }
                                    this.insertKey(var13_19);
lbl92:
                                    // 5 sources

                                    ** while (var9_14[var11_16].hasMoreElements())
                                }
lbl93:
                                // 1 sources

                                if (var5_8 != null) {
                                    var12_18 = 0;
                                    while (var12_18 < var5_8.size()) {
                                        this.insertKey((KeyItem)var5_8.elementAt(var12_18));
                                        ++var12_18;
                                    }
                                    var5_8 = null;
                                }
                            }
                            ++var11_16;
                        }
                        var2_2.close();
                        this.save();
                        if (var8_13 != null) {
                            this.setDefaultKey(var8_13);
                        }
                        this.buildKeyLabelList();
                        break block32;
                    }
                    throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
                }
                CMSKeyDatabase.c_Kdb2Kyr(var1_1.getKeyDbFileName(), var1_1.getKeyDbPwd(), "temp", "0909");
                CMSKeyDatabase.c_Kyr2Kdb("temp", "0909", this.keyDbFileName, this.keyDbPwd);
                this.buildKeyLabelList();
                var5_9 = new File("temp");
                if (var5_9.exists()) {
                    var5_9.delete();
                }
            }
            catch (CMSKeyDatabaseException var3_5) {
                var3_5.printStackTrace();
                throw var3_5;
            }
            catch (KeyDatabaseException var4_7) {
                var4_7.printStackTrace();
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
            catch (IOException var5_10) {
                var5_10.printStackTrace();
            }
        }
    }

    public void changeKeyDbPwd(String string, long l) throws CMSKeyDatabaseException {
        this.changeKeyDbPwd(null, string, l);
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws CMSKeyDatabaseException {
        if (string != null && !string.equals(this.keyDbPwd)) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_OLD_PASSWORD"));
        }
        if (!this.c_ChangeKeyDbPwd(this.keyDbFileName, this.keyDbPwd, string2, l)) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_PWDCHG"));
        }
        this.keyDbPwd = string2;
        this.keyDbPwdExpireTime = l;
    }

    public static boolean stashKeyDbPwd(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || string2.length() == 0 || string.length() == 0) {
            return false;
        }
        bl = CMSKeyDatabase.c_StashKeyDbPwd(string, string2);
        return bl;
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws CMSKeyDatabaseException {
        int n4 = this.c_CreateNewSelfSignedCertificate(this.keyDbFileName, this.keyDbPwd, n - 1, string, bl, n2, dNItem, n3, string2, bl2);
        if (n4 != 0) {
            IkeymanLogger.error("CMSKeyDatabase", "createNewSelfSignedCertificate() Line 676", "Error creating new self signed certificate using these parameters: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keyLabel=" + string + " keySize=" + n2 + " numValidDays=" + n3 + " certFileName=" + string2 + " base64Armored=" + bl2);
            throw new CMSKeyDatabaseException(n4, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT"));
        }
        this.addKeyLabelAt(string, 0);
        this.addMyCertLabelAt(string, 0);
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, int n4, String string2, boolean bl2, Vector vector) throws CMSKeyDatabaseException {
        int n5;
        byte[] byArray = this.encodeExtensions(vector);
        int n6 = 0;
        if (byArray != null) {
            n6 = byArray.length;
        }
        if ((n5 = this.c_CreateNewSelfSignedCertificateSigExt(this.keyDbFileName, this.keyDbPwd, n - 1, string, bl, n2, dNItem, n3, n4, n6, byArray, string2, bl2)) != 0) {
            IkeymanLogger.error("CMSKeyDatabase", "createNewSelfSignedCertificate() Line 695", "Error creating new self signed certificate using these parameters: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keyLabel=" + string + " keySize=" + n2 + " numValidDays=" + n3 + " certFileName=" + string2 + " signatureAlg=" + n4 + " extDataLen=" + n6 + " extDataBER=" + byArray + " base64Armored=" + bl2);
            throw new CMSKeyDatabaseException(n5, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT"));
        }
        this.addKeyLabelAt(string, 0);
        this.addMyCertLabelAt(string, 0);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n2 = this.c_CreateNewCertRequest(this.keyDbFileName, this.keyDbPwd, string, n, dNItem, string2, bl);
        if (n2 != 0) {
            IkeymanLogger.error("CMSKeyDatabase", "createNewCertRequest() Line 709", "Error creating new certificate request using these parameters: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keyLabel=" + string + " keySize=" + n + " certReqFileName=" + string2 + " isNewKeyPair=" + bl);
            throw new CMSKeyDatabaseException(n2, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_CERTREQ"));
        }
        if (bl) {
            this.addReqKeyLabelAt(string, 0);
        }
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, int n2, String string2, boolean bl, Vector vector) throws CMSKeyDatabaseException {
        int n3;
        byte[] byArray = this.encodeAttributes(vector);
        int n4 = 0;
        if (byArray != null) {
            n4 = byArray.length;
        }
        if ((n3 = this.c_CreateNewCertRequestSigExt(this.keyDbFileName, this.keyDbPwd, string, n, dNItem, n2, n4, byArray, string2, bl)) != 0) {
            IkeymanLogger.error("CMSKeyDatabase", "createNewCertRequest() Line 727", "Error creating new certificate request using these parameters: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keyLabel=" + string + " keySize=" + n + " certReqFileName=" + string2 + " isNewKeyPair=" + bl);
            throw new CMSKeyDatabaseException(n3, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_CERTREQ"));
        }
        if (bl) {
            this.addReqKeyLabelAt(string, 0);
        }
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, int n2, String string2, boolean bl, byte[] byArray) throws CMSKeyDatabaseException {
        int n3;
        int n4 = 0;
        if (byArray != null) {
            n4 = byArray.length;
        }
        if ((n3 = this.c_CreateNewCertRequestSigExt(this.keyDbFileName, this.keyDbPwd, string, n, dNItem, n2, n4, byArray, string2, bl)) != 0) {
            throw new CMSKeyDatabaseException(n3, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_CERTREQ"));
        }
        if (bl) {
            this.addReqKeyLabelAt(string, 0);
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws CMSKeyDatabaseException {
        int n3 = this.c_IssueCertificate(this.keyDbFileName, this.keyDbPwd, string, n - 1, string2, n2, string3, string4, bl);
        if (n3 != 0) {
            throw new CMSKeyDatabaseException(n3);
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, int n3, String string3, String string4, boolean bl) throws CMSKeyDatabaseException {
        int n4 = this.c_IssueCertificateSig(this.keyDbFileName, this.keyDbPwd, string, n - 1, string2, n2, n3, string3, string4, bl);
        if (n4 != 0) {
            throw new CMSKeyDatabaseException(n4);
        }
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.c_IsPrivateKeyPresent(this.keyDbFileName, this.keyDbPwd, string);
    }

    public void buildKeyLabelList() throws CMSKeyDatabaseException {
        KMUtil.debugMsg("CMSKeyDatabase::buildKeyLabelList() 0000");
        if (this.keyLabelList != null) {
            KMUtil.debugMsg("CMSKeyDatabase::buildKeyLabelList() 9999-1");
            return;
        }
        this.keyLabelList = new Vector();
        int n = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            KMUtil.debugMsg("CMSKeyDatabase::buildKeyLabelList() 9999-2, errCode=" + n);
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
        KMUtil.debugMsg("CMSKeyDatabase::buildKeyLabelList() 9999");
    }

    public void classifyKeyLabels() {
        KMUtil.debugMsg("CMSKeyDatabase::classifyKeyLabels() 0000");
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        if (this.keyLabelList == null) {
            KMUtil.debugMsg("CMSKeyDatabase::classifyKeyLabels() 9999-1");
            return;
        }
        int n = this.keyLabelList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.keyLabelList.elementAt(n2);
            if (this.isPrivateKeyPresent(string)) {
                this.addMyCertLabel(string);
            } else {
                this.addCaCertLabel(string);
            }
            ++n2;
        }
        KMUtil.debugMsg("CMSKeyDatabase::classifyKeyLabels() 9999");
    }

    public void refreshKeyLabelList() throws CMSKeyDatabaseException {
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        } else {
            this.keyLabelList.removeAllElements();
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        } else {
            this.reqKeyLabelList.removeAllElements();
        }
        int n = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        this.classifyKeyLabels();
    }

    public KeyItem getKeyItemByLabel(String string) throws CMSKeyDatabaseException {
        KeyItem keyItem;
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((keyItem = this.c_GetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL"));
        }
        return keyItem;
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws CMSKeyDatabaseException {
        byte[] byArray = bERObject.getEncoded();
        int n = bERObject.getLength();
        KeyItem[] keyItemArray = this.c_GetKeyItemsByPublicKey(this.keyDbFileName, this.keyDbPwd, n, byArray);
        if (keyItemArray == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_PUBKEY"));
        }
        Vector<KeyItem> vector = new Vector<KeyItem>(keyItemArray.length);
        int n2 = 0;
        while (n2 < keyItemArray.length) {
            vector.addElement(keyItemArray[n2]);
            ++n2;
        }
        return vector;
    }

    public KeyItem getDefaultKeyItem() throws CMSKeyDatabaseException {
        KeyItem keyItem = this.c_GetDefaultKeyItem(this.keyDbFileName, this.keyDbPwd);
        if (keyItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_DEFAULT_KEY"));
        }
        return keyItem;
    }

    public synchronized KeyItem getFirstKeyItem() throws CMSKeyDatabaseException {
        this.currentKeyIndex = 0;
        if (this.keyLabelList == null) {
            return null;
        }
        String string = (String)this.keyLabelList.elementAt(0);
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getNextKeyItem() throws CMSKeyDatabaseException {
        ++this.currentKeyIndex;
        if (this.currentKeyIndex < this.keyLabelList.size()) {
            String string = (String)this.keyLabelList.elementAt(this.currentKeyIndex);
            if (string == null) {
                return null;
            }
            return this.getKeyItemByLabel(string);
        }
        return null;
    }

    public void deleteKeyByLabel(String string) throws CMSKeyDatabaseException {
        int n;
        if (string == null) {
            return;
        }
        boolean bl = false;
        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((n = this.c_DeleteKeyByLabel(this.keyDbFileName, this.keyDbPwd, string, bl)) != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_DELETE"));
        }
        if (bl) {
            this.reqKeyLabelList.removeElement(string);
        } else {
            this.keyLabelList.removeElement(string);
            if (this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
                this.caCertLabelList.removeElement(string);
            } else if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
                this.myCertLabelList.removeElement(string);
            } else {
                throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_LABEL_LIST_CORRUPT"));
            }
        }
    }

    public void insertKey(KeyItem keyItem) throws CMSKeyDatabaseException {
        KMUtil.debugMsg("CMSKeyDatabase::insertKey 0000");
        int n = 0;
        if (keyItem == null) {
            return;
        }
        String string = keyItem.getKeyLabel();
        int n2 = 0;
        byte[] byArray = null;
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
        if (encryptedPrivateKeyInfoItem != null) {
            byArray = encryptedPrivateKeyInfoItem.getEncoded();
            n2 = encryptedPrivateKeyInfoItem.getLength();
        }
        KMUtil.debugMsg("CMSKeyDatabase::insertKey 0100");
        if (keyItem.hasCertificate()) {
            KMUtil.debugMsg("CMSKeyDatabase::insertKey 0110");
            CertificateItem certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0);
            int n3 = certificateItem.getLength();
            byte[] byArray2 = certificateItem.getEncoded();
            boolean bl = keyItem.isTrusted();
            boolean bl2 = keyItem.isDefault();
            KMUtil.debugMsg("CMSKeyDatabase::insertKey 0200, keyLabel=" + string);
            n = this.c_InsertKey(this.keyDbFileName, this.keyDbPwd, string, n3, byArray2, n2, byArray, bl, bl2);
            if (n == 0) {
                KMUtil.debugMsg("CMSKeyDatabase::insertKey 0210, keyLabel=" + string);
                this.addKeyLabelAt(string, 0);
                if (n2 > 0) {
                    this.addMyCertLabelAt(string, 0);
                } else {
                    this.addCaCertLabelAt(string, 0);
                }
            }
        } else if (keyItem.getCertificateRequestItem() != null) {
            KMUtil.debugMsg("CMSKeyDatabase::insertKey 0220");
            CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
            int n4 = certificateRequestItem.getLength();
            byte[] byArray3 = certificateRequestItem.getEncoded();
            KMUtil.debugMsg("CMSKeyDatabase::insertKey 0300");
            n = this.c_InsertReqKey(this.keyDbFileName, this.keyDbPwd, string, n4, byArray3, n2, byArray);
            if (n == 0) {
                KMUtil.debugMsg("CMSKeyDatabase::insertKey 0310");
                this.addReqKeyLabelAt(string, 0);
            }
        }
        if (n != 0) {
            KMUtil.debugMsg("CMSKeyDatabase::insertKey 1000, errCode=" + n);
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        KMUtil.debugMsg("CMSKeyDatabase::insertKey 9999");
    }

    public void setDefaultKey(String string) throws CMSKeyDatabaseException {
        int n = this.c_SetDefaultKey(this.keyDbFileName, this.keyDbPwd, string);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
        }
    }

    public void setKeyTrust(String string, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_SetKeyTrust(this.keyDbFileName, this.keyDbPwd, string, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_TRUST_KEY"));
        }
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws CMSKeyDatabaseException {
        try {
            int n = 0;
            while (n < stringArray.length) {
                this.exportPKCSFile(string, string2, stringArray[n], 1);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
    }

    public void exportPKCSFile(String string, String string2, String string3, int n) throws CMSKeyDatabaseException, Exception {
        KeyItem[] keyItemArray = null;
        if (string3 != null && string3.length() > 0) {
            keyItemArray = this.getKeyItemListByLabel(string3);
            if (keyItemArray != null && keyItemArray.length > 0) {
                int n2 = 0;
                String string4 = null;
                if (n == 1) {
                    string4 = KeyDatabase.DEFAULT_1_BROWSER_ENC_ALGORITHM;
                    n2 = KeyDatabase.DEFAULT_1_BROWSER_ITERATION_COUNT;
                } else {
                    string4 = KeyDatabase.DEFAULT_2_IKEYMAN_ENC_ALGORITHM;
                    n2 = KeyDatabase.DEFAULT_2_IKEYMAN_ITERATION_COUNT;
                }
                EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItemArray[0].getEncryptedPrivateKeyInfoItem();
                PrivateKeyInfoItem privateKeyInfoItem = this.decryptPrivateKey(encryptedPrivateKeyInfoItem);
                KMpkcs12 kMpkcs12 = new KMpkcs12(string, string2, keyItemArray, privateKeyInfoItem);
                kMpkcs12.setIteration(n2);
                kMpkcs12.setEncAlg(string4);
                kMpkcs12.encode();
                kMpkcs12.destroyPvtKey();
                kMpkcs12.writeFile();
            }
        } else {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
    }

    public void importFromPFXFile(String string, String string2) throws CMSKeyDatabaseException {
        try {
            KMpkcs12 kMpkcs12 = new KMpkcs12(string, string2);
            this.importFromPKCSFile(kMpkcs12);
        }
        catch (Exception exception) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
        }
    }

    public void importFromPKCSFile(KMpkcs12 kMpkcs12) throws KeyDatabaseException, Exception {
        kMpkcs12.decode();
        KeyItem[] keyItemArray = kMpkcs12.getKeyItemChain();
        PrivateKeyInfoItem privateKeyInfoItem = kMpkcs12.getPvtKey();
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = this.encryptPrivateKey(privateKeyInfoItem);
        kMpkcs12.destroyPvtKey();
        if (keyItemArray != null && keyItemArray.length > 0) {
            keyItemArray[0].setEncryptedPrivateKeyInfoItem(encryptedPrivateKeyInfoItem);
            boolean[] blArray = this.insertKeyItemList(keyItemArray, true);
            if (blArray != null && blArray.length > 0) {
                Vector<String> vector = new Vector<String>();
                int n = blArray.length - 1;
                while (n > 0) {
                    if (blArray[n]) {
                        vector.addElement(keyItemArray[n].getKeyLabel());
                    }
                    --n;
                }
            }
        }
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws CMSKeyDatabaseException {
        KeyItem[] keyItemArray = this.c_GetKeyItemListByLabel(this.keyDbFileName, this.keyDbPwd, string);
        if (keyItemArray == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
        return keyItemArray;
    }

    public PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) throws CMSKeyDatabaseException {
        PrivateKeyInfoItem privateKeyInfoItem = null;
        byte[] byArray = null;
        int n = 0;
        if (encryptedPrivateKeyInfoItem != null) {
            byArray = encryptedPrivateKeyInfoItem.getEncoded();
            n = encryptedPrivateKeyInfoItem.getLength();
            privateKeyInfoItem = CMSKeyDatabase.c_DecryptPrivateKey(n, byArray, this.keyDbPwd);
        }
        if (privateKeyInfoItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        }
        return privateKeyInfoItem;
    }

    public EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem) throws CMSKeyDatabaseException {
        return CMSKeyDatabase.encryptPrivateKey(privateKeyInfoItem, this.keyDbPwd);
    }

    public static EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem, String string) throws CMSKeyDatabaseException {
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
        byte[] byArray = null;
        int n = 0;
        if (privateKeyInfoItem != null) {
            byArray = privateKeyInfoItem.getEncoded();
            n = privateKeyInfoItem.getLength();
            encryptedPrivateKeyInfoItem = CMSKeyDatabase.c_EncryptPrivateKey(n, byArray, string);
        }
        if (encryptedPrivateKeyInfoItem == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
        }
        return encryptedPrivateKeyInfoItem;
    }

    public String resolveLabelConflict(KeyItem keyItem) {
        int n = 0;
        KeyItem keyItem2 = null;
        Vector vector = this.getKeyLabelList();
        String string = keyItem.getKeyLabel();
        if (string == null) {
            CertificateItem certificateItem;
            DNItem dNItem;
            if (keyItem.hasCertificate() && (dNItem = (certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0)).getSubject()) != null) {
                string = dNItem.getCommonName();
            }
            if (string == null || string.equals("")) {
                string = "Dummy Key Label_" + Integer.toString(Math.abs(new Random().nextInt()));
            }
        }
        if (vector != null && vector.contains(string)) {
            try {
                keyItem2 = this.getKeyItemByLabel(string);
            }
            catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
                keyItem2 = null;
            }
            if (keyItem2 != null && !keyItem.equalsCert(keyItem2)) {
                while (vector.contains(string) && n < 1000) {
                    string = string + "_" + Integer.toString(new Random().nextInt());
                    ++n;
                }
            } else {
                string = null;
            }
        }
        return string;
    }

    public boolean[] insertKeyItemList(KeyItem[] keyItemArray) throws CMSKeyDatabaseException {
        return this.insertKeyItemList(keyItemArray, false);
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] insertKeyItemList(KeyItem[] var1_1, boolean var2_2) throws CMSKeyDatabaseException {
        var3_3 = null;
        if (var1_1 != null && var1_1.length > 0) {
            var3_3 = new boolean[var1_1.length];
            var4_4 = var1_1.length - 1;
            while (var4_4 >= 0) {
                block12: {
                    var3_3[var4_4] = false;
                    if (var1_1[var4_4].getKeyLabel() == null && !var2_2) {
                        var1_1[var4_4].setKeyLabel(this.resolveLabelConflict(var1_1[var4_4]));
                    }
                    if (var1_1[var4_4].getKeyLabel() != null) {
                        try {
                            var1_1[var4_4].setTrusted(true);
                            this.insertKey(var1_1[var4_4]);
                            var3_3[var4_4] = true;
                            break block12;
                        }
                        catch (CMSKeyDatabaseException var5_5) {
                            var6_6 = var5_5.getErrCode();
                            var7_7 = CMSKeyDatabaseException.getErrKey(var6_6);
                            if (var7_7.equals("GSKKM_ERR_DATABASE_DUPLICATE_KEY")) {
                                var3_3[var4_4] = false;
                                if (var4_4 == 0) {
                                    throw var5_5;
                                }
                                break block12;
                            }
                            var3_3[var4_4] = false;
                            var8_8 = var1_1.length - 1;
                            ** while (var8_8 >= var4_4)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (var3_3[var8_8]) {
                                try {
                                    this.deleteKeyByLabel(var1_1[var8_8].getKeyLabel());
                                    var3_3[var8_8] = false;
                                }
                                catch (CMSKeyDatabaseException var9_9) {
                                    // empty catch block
                                }
                            }
                            --var8_8;
                            continue;
                        }
lbl35:
                        // 1 sources

                        throw var5_5;
                    }
                }
                --var4_4;
            }
        }
        return var3_3;
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws CMSKeyDatabaseException {
        int n = this.c_ReceiveCert(this.keyDbFileName, this.keyDbPwd, string, bl, bl2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
        }
        this.refreshKeyLabelList();
    }

    public void addCACertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_AddCaCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
        }
        this.addCaCertLabelAt(string, 0);
        this.addKeyLabelAt(string, 0);
    }

    public void extractCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        int n = this.c_ExtractCert(this.keyDbFileName, this.keyDbPwd, string, string2, bl);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYREC_EXTRACT_CERT"));
        }
    }

    public void extractCertificateRequest(String string, String string2) throws CMSKeyDatabaseException {
        int n = this.c_ExtractCertReq(this.keyDbFileName, this.keyDbPwd, string, string2);
        if (n != 0) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
        }
    }

    public void extractCertificateRequest(String string, int n, String string2) throws CMSKeyDatabaseException {
        int n2 = this.c_ExtractCertReqSig(this.keyDbFileName, this.keyDbPwd, string, n, string2);
        if (n2 != 0) {
            throw new CMSKeyDatabaseException(n2, KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
        }
    }

    public boolean checkCertAsRenewal(String string, boolean bl) throws CMSKeyDatabaseException {
        byte[] byArray;
        try {
            byArray = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string) : SSLightKeyDatabase.fileToBuf(string);
        }
        catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
            throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (byArray != null && byArray.length > 0) {
            return this.c_CheckCertAsRenewal(this.keyDbFileName, this.keyDbPwd, byArray.length, byArray);
        }
        throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
    }

    public void renewCert(String string, boolean bl) throws CMSKeyDatabaseException {
        byte[] byArray;
        int n = 0;
        try {
            byArray = bl ? SSLightKeyDatabase.base64DearmorFileToBuf(string) : SSLightKeyDatabase.fileToBuf(string);
        }
        catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (byArray != null && byArray.length > 0) {
            n = this.c_RenewCert(this.keyDbFileName, this.keyDbPwd, byArray.length, byArray);
            if (n != 0) {
                throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_RENEW_CERT"));
            }
        } else {
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
        }
    }

    public CertificateItem[] receivePKCS7CertChain(String string, boolean bl) throws CMSKeyDatabaseException {
        return CMSKeyDatabase.buildPKCS7CertChain(string, bl);
    }

    public static CertificateItem[] buildPKCS7CertChain(String string, boolean bl) throws CMSKeyDatabaseException {
        KMUtil.debugMsg("CMSKeyDatabase::buildPKCS7CertChain() 0000, inputCertFileName=" + string + ", isBase64Armored=" + bl);
        if (string == null) {
            KMUtil.debugMsg("CMSKeyDatabase::buildPKCS7CertChain() 9999-1");
            throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
        }
        CertificateItem[] certificateItemArray = CMSKeyDatabase.c_ExtractCertFromPKCS7Data(string, bl);
        if (certificateItemArray != null) {
            KMUtil.debugMsg("CMSKeyDatabase::buildPKCS7CertChain() 9999-2");
            return certificateItemArray;
        }
        KMUtil.debugMsg("CMSKeyDatabase::buildPKCS7CertChain() 9999-3, errCoe=0");
        throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
    }

    public void addSiteCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public boolean ValidateKeyItemList(KeyItem[] keyItemArray) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = keyItemArray.length;
        CertificateItem[] certificateItemArray = new CertificateItem[n4];
        CertificateItem[] certificateItemArray2 = new CertificateItem[n4];
        System.out.println("Start ValidateKeyItemList()");
        int n5 = 0;
        while (n5 < n4) {
            Vector vector = keyItemArray[n5].getCertificateChain();
            CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
            n += certificateItem.berData.length;
            certificateItemArray[n5] = certificateItem;
            ++n5;
        }
        if (n == 0) {
            return false;
        }
        System.out.println("The total cert length is " + n);
        DNItem dNItem = null;
        DNItem dNItem2 = null;
        DNItem dNItem3 = null;
        n5 = 0;
        while (n5 < n4) {
            dNItem2 = certificateItemArray[n5].getSubject();
            dNItem = certificateItemArray[n5].getIssuer();
            if (dNItem2.toString().equals(dNItem.toString())) {
                n2 = n4 - 1;
                certificateItemArray2[n2] = certificateItemArray[n5];
                n3 = n5;
                dNItem3 = dNItem;
                break;
            }
            ++n5;
        }
        if (n3 == -1) {
            System.out.println("Root not found in the chain, validation failed..");
            return false;
        }
        if (n4 != 1) {
            n5 = 0;
            while (n2 != 0) {
                if (n5 != n3 && (dNItem = certificateItemArray[n5].getIssuer()).toString().equals(dNItem3.toString())) {
                    certificateItemArray2[--n2] = certificateItemArray[n5];
                    dNItem3 = certificateItemArray[n5].getSubject();
                }
                if (++n5 != n4) continue;
                n5 = 0;
            }
        }
        byte[] byArray = new byte[n + n4 * 3];
        int n6 = 0;
        n5 = 0;
        while (n5 < n4) {
            int n7 = 3;
            do {
                byArray[n6++] = (byte)(certificateItemArray2[n5].berData.length >>> --n7 * 8);
            } while (n7 > 0);
            System.arraycopy(certificateItemArray2[n5].berData, 0, byArray, n6, certificateItemArray2[n5].berData.length);
            n6 += certificateItemArray2[n5].berData.length;
            ++n5;
        }
        System.out.println("Upon to call ValidateCertificateChain()");
        return this.ValidateCertificateChain(byArray);
    }

    public boolean ValidateCertificateChain(byte[] byArray) {
        int n = byArray.length;
        System.out.println("Start ValidateCertificateChain() with byte length " + n);
        return this.c_ValidateCertificateChain(this.keyDbFileName, this.keyDbPwd, byArray, n);
    }

    public byte[] encodeExtensions(Vector vector) throws CMSKeyDatabaseException {
        byte[] byArray = null;
        try {
            if (vector != null && vector.size() > 0) {
                DerOutputStream derOutputStream;
                CertificateExtensions certificateExtensions;
                GeneralNames generalNames = new GeneralNames();
                BasicConstraintsExtension basicConstraintsExtension = null;
                int n = 0;
                while (n < vector.size()) {
                    certificateExtensions = null;
                    int n2 = ((KMExtensionItem)vector.elementAt(n)).getFieldType();
                    if (n2 == Integer.MIN_VALUE) {
                        basicConstraintsExtension = (BasicConstraintsExtension)((KMExtensionItem)vector.elementAt(n)).getFieldValue();
                    } else {
                        String string = (String)((KMExtensionItem)vector.elementAt(n)).getFieldValue();
                        if (n2 == 1) {
                            certificateExtensions = new RFC822Name(string);
                        } else if (n2 == 7) {
                            int n3 = new StringTokenizer(string, ".").countTokens();
                            if (n3 == 4) {
                                KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate an Valid ipv4" + string);
                                String string2 = string;
                                byte[] byArray2 = new byte[4];
                                int n4 = 0;
                                while (n4 < 3) {
                                    int n5 = string2.indexOf(".");
                                    String string3 = string2.substring(0, n5);
                                    string2 = string2.substring(n5 + 1);
                                    byArray2[n4] = (byte)Integer.parseInt(string3);
                                    ++n4;
                                }
                                byArray2[n4] = (byte)Integer.parseInt(string2);
                                DerValue derValue = new DerValue(4, byArray2);
                                certificateExtensions = new IPAddressName(derValue);
                            } else {
                                certificateExtensions = new IPAddressName(string);
                            }
                        } else if (n2 == 2) {
                            certificateExtensions = new DNSName(string);
                        }
                        derOutputStream = new GeneralName((GeneralNameInterface)certificateExtensions);
                        generalNames.addElement(derOutputStream);
                    }
                    ++n;
                }
                certificateExtensions = new CertificateExtensions();
                if (generalNames.size() > 0) {
                    certificateExtensions.set("SubjectAlternativeName", (Object)new SubjectAlternativeNameExtension(generalNames));
                }
                if (basicConstraintsExtension != null) {
                    certificateExtensions.set("BasicConstraints", basicConstraintsExtension);
                }
                derOutputStream = new DerOutputStream();
                certificateExtensions.encode((OutputStream)derOutputStream, true);
                BERObject bERObject = new BERObject(derOutputStream.toByteArray());
                byArray = bERObject.getEncoded();
            }
        }
        catch (Exception exception) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        return byArray;
    }

    public byte[] encodeAttributes(Vector vector) throws CMSKeyDatabaseException {
        byte[] byArray = null;
        try {
            if (vector != null && vector.size() > 0) {
                Object var4_3 = null;
                Object var5_5 = null;
                Object var6_6 = null;
                String string = "";
                int n = 0;
                while (n < vector.size()) {
                    string = string + "<" + (String)((KMExtensionItem)vector.elementAt(n)).getFieldValue() + ">";
                    ++n;
                }
                DerValue derValue = new DerValue(19, string);
                DerValue derValue2 = new DerValue(49, derValue.toByteArray());
                PKCSAttribute pKCSAttribute = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)derValue2.toByteArray());
                PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
                PKCSAttributes pKCSAttributes = new PKCSAttributes(pKCSAttributeArray);
                byArray = pKCSAttributes.generateDerEncoding();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }
}

