/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFilenameFilter;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public class GenkeyDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    public static final int CREATE_NEW_SELFSIGNED_CERTIFICATE = 1;
    public static final int CREATE_NEW_KEYPAIR_AND_CERTREQ = 2;
    public static final int[] KEYSIZE_CHOICE = new int[]{512, 1024};
    public static final int KEYSIZE_EXPORT_MAX = 512;
    public static final int KEYSIZE_EXPORT_DEFAULT = 512;
    public static final int KEYSIZE_US_DEFAULT = 1024;
    public static final int MAX_NUMBER_CERTIFICATE_VALID_DAYS = 7300;
    private KeyStoreManager keyDb;
    private String currWorkingDirName;
    private String defaultCertReqFileFullPathName;
    private int mode;
    private JLabel titleLabel;
    private JLabel versionLabel;
    private JLabel keyLabelLabel;
    private JLabel keySizeLabel;
    private JLabel commonNameLabel;
    private JLabel orgLabel;
    private JLabel optionLabel1;
    private JLabel optionLabel2;
    private JLabel optionLabel3;
    private JLabel optionLabel4;
    private JLabel optionLabel5;
    private JLabel optionLabel6;
    private JLabel optionLabel7;
    private JLabel orgUnitLabel;
    private JLabel localityLabel;
    private JLabel stateLabel;
    private JLabel zipCodeLabel;
    private JLabel countryLabel;
    private JLabel validityPeriodLabel;
    private JLabel daysLabel;
    private JLabel subjectAlternativeNamesLabel;
    private JLabel emailAddressLabel;
    private JLabel ipAddressLabel;
    private JLabel dnsNameLabel;
    private JTextField labelField;
    private JComboBox certVersionChoice;
    private JComboBox keySizeChoice;
    private int defIdx = 0;
    private JTextField commonNameField;
    private JTextField orgField;
    private JTextField orgUnitField;
    private JTextField localityField;
    private JTextField stateField;
    private JTextField zipCodeField;
    private JComboBox countryCodeChoices;
    private JTextField emailAddressField;
    private JTextField ipAddressField;
    private JTextField dnsNameField;
    private boolean includeSubjectAlternativeName;
    private JTextField validityPeriodField;
    private JLabel certReqFileNameLabel = null;
    private JTextField certReqFileNameField = null;
    private KMButton browseButton = null;
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton resetButton;
    private KMButton helpButton;
    private JPanel keyInfoInputPanel;
    private String keyLabel = null;
    private DNItem subjectDNItem = null;
    private int keySize = 0;
    private int certVersion = 0;
    private String certReqFileName = null;
    private int numValidDays = 365;
    private JTextField invalidInputField;
    private String invalidInputFieldName;
    private JDialog diagInstance;

    public GenkeyDialog(JFrame jFrame, KeyStoreManager keyStoreManager, int n) {
        super(jFrame, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_NEW_SSCERT"), true);
        String string;
        this.keyDb = keyStoreManager;
        this.mode = n;
        this.diagInstance = this;
        if (n == 2) {
            this.setTitle(Ikeyman.getNLSResString("GUI_DIALOG_TITLE_NEW_CERTREQ"));
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_SUBJECT_ALTERNATIVE_NAME_SUPPORT")) == null) {
            string = "false";
        }
        if (string.equalsIgnoreCase("true")) {
            this.includeSubjectAlternativeName = true;
            if (KeyStoreManager.isJSSECryptokiOpened || KeyStoreManager.isCMSCryptokiOpened) {
                this.includeSubjectAlternativeName = false;
            }
        } else {
            this.includeSubjectAlternativeName = false;
        }
        this.populateFields();
        this.commonNameField.setText(KMSystem.getHostName());
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......KMSystem.getCountryName() returns " + KMSystem.getCountryName());
        }
        this.countryCodeChoices.setSelectedItem(KMSystem.getCountryName());
        this.validityPeriodField.setText("365");
        this.keyInfoInputPanel = new KeyInfoInputPanel();
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.resetButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.equalizeButtons();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.keyInfoInputPanel, gridBagConstraints);
        jPanel.add(this.keyInfoInputPanel);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(kMHorizontalButtonPanel, gridBagConstraints);
        jPanel.add(kMHorizontalButtonPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.labelField.requestFocus();
    }

    protected void populateFields() {
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields() {
        int n;
        if (this.mode == 1) {
            this.certVersionChoice = new JComboBox();
            this.certVersionChoice.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_VERSION"));
            n = CertificateItem.CERTIFICATE_VERSIONS.length - 1;
            while (n >= 0) {
                this.certVersionChoice.addItem(CertificateItem.CERTIFICATE_VERSIONS[n]);
                --n;
            }
        }
        this.keySizeChoice = new JComboBox();
        this.keySizeChoice.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_KEY_SIZE"));
        n = KMSystem.isUSVersion();
        int n2 = 0;
        while (n2 < KEYSIZE_CHOICE.length) {
            if (n == 0 && KEYSIZE_CHOICE[n2] > 512) break;
            this.keySizeChoice.addItem(String.valueOf(KEYSIZE_CHOICE[n2]));
            ++n2;
        }
        this.keySizeChoice.addItemListener(this);
        int n3 = 0;
        while (n3 < KEYSIZE_CHOICE.length) {
            if (n == 0) {
                if (KEYSIZE_CHOICE[n3] == 512) {
                    this.defIdx = n3;
                    break;
                }
            } else if (KEYSIZE_CHOICE[n3] == 1024) {
                this.defIdx = n3;
                break;
            }
            ++n3;
        }
        this.keySizeChoice.setSelectedIndex(this.defIdx);
        this.titleLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ENTER_INFO"));
        this.versionLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VERSION"));
        this.keyLabelLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_KEY_LABEL"));
        this.keySizeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_KEY_SIZE"));
        this.commonNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_COMMON_NAME"));
        this.orgLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ORG"));
        String string = Ikeyman.getNLSResString("GUI_LABEL_OPTIONAL");
        this.optionLabel1 = new JLabel(string);
        this.optionLabel2 = new JLabel(string);
        this.optionLabel3 = new JLabel(string);
        this.optionLabel4 = new JLabel(string);
        if (this.includeSubjectAlternativeName) {
            this.optionLabel5 = new JLabel(string);
            this.optionLabel6 = new JLabel(string);
            this.optionLabel7 = new JLabel(string);
        }
        this.orgUnitLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ORG_UNIT"));
        this.localityLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCALITY"));
        this.stateLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_STATE"));
        this.zipCodeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_ZIPCODE"));
        this.countryLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_COUNTRY"));
        this.validityPeriodLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VALIDITY_PERIOD"));
        this.daysLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_EXPIRE_DAYS"));
        if (this.includeSubjectAlternativeName) {
            this.subjectAlternativeNamesLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_ALTERNATIVE_NAMES1"));
            this.emailAddressLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1"));
            this.ipAddressLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_IP_ADDRESS1"));
            this.dnsNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_DNS_NAME1"));
        }
        int n4 = 35;
        if (Ikeyman.screenSize.width < 800) {
            n4 = 25;
        }
        this.labelField = new JTextField(n4);
        this.labelField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_KEY_LABEL"));
        this.commonNameField = new JTextField(n4);
        this.commonNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_COMMON_NAME"));
        this.orgField = new JTextField(n4);
        this.orgField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_ORG"));
        this.orgUnitField = new JTextField(n4);
        this.orgUnitField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_ORG_UNIT"));
        this.localityField = new JTextField(n4);
        this.localityField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_LOCALITY"));
        this.stateField = new JTextField(10);
        this.stateField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_STATE"));
        this.zipCodeField = new JTextField(10);
        this.zipCodeField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_ZIPCODE"));
        this.countryCodeChoices = new JComboBox<String>(KMSystem.ISO_3166_ORDERED_COUNTRY_CODES);
        this.countryCodeChoices.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_COUNTRY"));
        this.countryCodeChoices.addItemListener(this);
        this.validityPeriodField = new JTextField(5);
        this.validityPeriodField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_VALIDITY_PERIOD"));
        if (this.includeSubjectAlternativeName) {
            this.emailAddressField = new JTextField(n4);
            this.emailAddressField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1"));
            this.ipAddressField = new JTextField(n4);
            this.ipAddressField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_IP_ADDRESS1"));
            this.dnsNameField = new JTextField(n4);
            this.dnsNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_DNS_NAME1"));
        }
        if (this.mode == 2) {
            this.certReqFileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_FILE_NAME"));
            int n5 = 0;
            if (this.keyDb != null) {
                n5 = this.keyDb.getType();
            }
            this.currWorkingDirName = KeyStoreManager.getDefaultKeyDbFileLocation(n5);
            this.defaultCertReqFileFullPathName = this.currWorkingDirName + KeyStoreManager.DEFAULT_CERTREQ_NAME;
            this.certReqFileNameField = new JTextField(this.defaultCertReqFileFullPathName, n4 + 5);
            this.certReqFileNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_FILENAME"));
            String string2 = Locale.getDefault().getLanguage();
            if (string2.equals("ko") || string2.equals("ja")) {
                this.certReqFileNameField.setFont(Ikeyman.defaultMonospacedFont);
            }
            this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
            this.browseButton.setActionCommand("Browse");
            this.browseButton.addActionListener(this);
        }
    }

    protected void populateButtons() {
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.resetButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_RESET"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.okButton.setActionCommand("OK");
        this.resetButton.setActionCommand("Reset");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.okButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        this.labelField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_KEY_LABEL"));
        if (this.mode == 1) {
            this.certVersionChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CERT_VERSION"));
        }
        this.keySizeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_KEY_SIZE_CHOICE"));
        this.commonNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_COMMON_NAME"));
        this.orgField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_ORG_NAME"));
        this.orgUnitField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_ORG_UNIT_NAME"));
        this.localityField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_LOCALITY"));
        this.stateField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_STATE"));
        this.zipCodeField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_ZIPCODE"));
        this.countryCodeChoices.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_COUNTRY_NAME"));
        if (this.mode == 1) {
            this.validityPeriodField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CERT_VALID_DAYS"));
        }
        if (this.includeSubjectAlternativeName) {
            this.emailAddressField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_EMAIL_ADDRESS"));
            this.ipAddressField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_IP_ADDRESS"));
            this.dnsNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DNS_NAME"));
        }
        if (this.mode == 2) {
            this.certReqFileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CERTREQ_FILE"));
        }
    }

    private void layoutKeyInfoWithGridLayout() {
        this.keyInfoInputPanel = new JPanel();
        this.keyInfoInputPanel.setLayout(new GridLayout(11, 1));
        this.keyInfoInputPanel.add(this.titleLabel);
        this.keyInfoInputPanel.add(new JLabel());
        if (this.mode == 1) {
            this.keyInfoInputPanel.add(this.versionLabel);
            this.keyInfoInputPanel.add(this.certVersionChoice);
        }
        this.keyInfoInputPanel.add(this.keyLabelLabel);
        this.keyInfoInputPanel.add(this.labelField);
        this.keyInfoInputPanel.add(this.keySizeLabel);
        this.keyInfoInputPanel.add(this.keySizeChoice);
        this.keyInfoInputPanel.add(this.commonNameLabel);
        this.keyInfoInputPanel.add(this.commonNameField);
        this.keyInfoInputPanel.add(this.orgLabel);
        this.keyInfoInputPanel.add(this.orgField);
        this.keyInfoInputPanel.add(this.orgUnitLabel);
        this.keyInfoInputPanel.add(this.orgUnitField);
        this.keyInfoInputPanel.add(this.localityLabel);
        this.keyInfoInputPanel.add(this.localityField);
        this.keyInfoInputPanel.add(this.stateLabel);
        this.keyInfoInputPanel.add(this.stateField);
        this.keyInfoInputPanel.add(this.zipCodeLabel);
        this.keyInfoInputPanel.add(this.zipCodeField);
        this.keyInfoInputPanel.add(this.countryLabel);
        this.keyInfoInputPanel.add(this.countryCodeChoices);
        if (this.includeSubjectAlternativeName) {
            this.keyInfoInputPanel.add(this.subjectAlternativeNamesLabel);
            this.keyInfoInputPanel.add(this.emailAddressLabel);
            this.keyInfoInputPanel.add(this.emailAddressField);
            this.keyInfoInputPanel.add(this.ipAddressLabel);
            this.keyInfoInputPanel.add(this.ipAddressField);
            this.keyInfoInputPanel.add(this.dnsNameLabel);
            this.keyInfoInputPanel.add(this.dnsNameField);
        }
        if (this.mode == 2) {
            this.keyInfoInputPanel.add(this.certReqFileNameLabel);
            this.keyInfoInputPanel.add(this.certReqFileNameField);
        }
    }

    public int getCertificateVersion() {
        return this.certVersion;
    }

    public void setCertificateVersion(int n) {
        if (n < 1 || n > CertificateItem.CERTIFICATE_VERSIONS.length) {
            return;
        }
        this.certVersionChoice.setSelectedIndex(CertificateItem.CERTIFICATE_VERSIONS.length - n);
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public void setKeyLabel(String string) {
        this.labelField.setText(string);
    }

    public String getCertReqFileName() {
        return this.certReqFileName;
    }

    public void setCertReqFileName(String string) {
        this.certReqFileNameField.setText(string);
        this.certReqFileName = string;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int n) {
        int n2 = 0;
        while (n2 < KEYSIZE_CHOICE.length) {
            if (n == KEYSIZE_CHOICE[n2]) {
                this.keySizeChoice.setSelectedIndex(n2);
                this.keySize = n;
                break;
            }
            ++n2;
        }
    }

    public DNItem getSubjectDNItem() {
        return this.subjectDNItem;
    }

    public int getNumberOfValidDays() {
        return this.numValidDays;
    }

    public void setSubjectDNItem(DNItem dNItem) {
        this.subjectDNItem = dNItem;
        this.commonNameField.setText(dNItem.getCommonName());
        this.orgField.setText(dNItem.getOrganization());
        this.orgUnitField.setText(dNItem.getOrganizationUnit());
        this.localityField.setText(dNItem.getLocality());
        this.stateField.setText(dNItem.getState());
        this.zipCodeField.setText(dNItem.getZipCode());
        this.countryCodeChoices.setSelectedItem(dNItem.getCountryName());
    }

    public String[] getEmailAddresses() {
        if (this.includeSubjectAlternativeName) {
            return KMUtil.getStrings(this.emailAddressField.getText());
        }
        return null;
    }

    public String[] getIPAddresses() {
        if (this.includeSubjectAlternativeName) {
            return KMUtil.getStrings(this.ipAddressField.getText());
        }
        return null;
    }

    public String[] getDNSNames() {
        if (this.includeSubjectAlternativeName) {
            return KMUtil.getStrings(this.dnsNameField.getText());
        }
        return null;
    }

    private boolean isInputValid() {
        this.invalidInputField = null;
        if (KMUtil.trimBlankSpace(this.labelField.getText()) == null) {
            this.invalidInputField = this.labelField;
            this.invalidInputFieldName = this.keyLabelLabel.getText();
        } else if (KMUtil.trimBlankSpace(this.commonNameField.getText()) == null) {
            this.invalidInputField = this.commonNameField;
            this.invalidInputFieldName = this.commonNameLabel.getText();
        } else if (KMUtil.trimBlankSpace(this.orgField.getText()) == null) {
            this.invalidInputField = this.orgField;
            this.invalidInputFieldName = this.orgLabel.getText();
        } else if (this.mode == 2) {
            if (KMUtil.trimBlankSpace(this.certReqFileNameField.getText()) == null) {
                this.invalidInputField = this.certReqFileNameField;
                this.invalidInputFieldName = this.certReqFileNameLabel.getText();
            }
        } else if (this.mode == 1) {
            try {
                this.numValidDays = Integer.parseInt(this.validityPeriodField.getText());
                if (this.numValidDays <= 0 || this.numValidDays > 7300) {
                    this.invalidInputField = this.validityPeriodField;
                    this.invalidInputFieldName = this.validityPeriodLabel.getText();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.invalidInputField = this.validityPeriodField;
                this.invalidInputFieldName = this.validityPeriodLabel.getText();
            }
        }
        boolean bl = false;
        if (this.labelField.getText() != null && KMUtil.isDBCSString(this.labelField.getText())) {
            bl = true;
            this.invalidInputField = this.labelField;
            this.invalidInputFieldName = this.keyLabelLabel.getText();
        } else if (this.commonNameField.getText() != null && KMUtil.isDBCSString(this.commonNameField.getText())) {
            bl = true;
            this.invalidInputField = this.commonNameField;
            this.invalidInputFieldName = this.commonNameLabel.getText();
        } else if (this.orgField.getText() != null && KMUtil.isDBCSString(this.orgField.getText())) {
            bl = true;
            this.invalidInputField = this.orgField;
            this.invalidInputFieldName = this.orgLabel.getText();
        } else if (this.orgUnitField.getText() != null && KMUtil.isDBCSString(this.orgUnitField.getText())) {
            bl = true;
            this.invalidInputField = this.orgUnitField;
            this.invalidInputFieldName = this.orgUnitLabel.getText();
        } else if (this.localityField.getText() != null && KMUtil.isDBCSString(this.localityField.getText())) {
            bl = true;
            this.invalidInputField = this.localityField;
            this.invalidInputFieldName = this.localityLabel.getText();
        } else if (this.stateField.getText() != null && KMUtil.isDBCSString(this.stateField.getText())) {
            bl = true;
            this.invalidInputField = this.stateField;
            this.invalidInputFieldName = this.stateLabel.getText();
        } else if (this.zipCodeField.getText() != null && KMUtil.isDBCSString(this.zipCodeField.getText())) {
            bl = true;
            this.invalidInputField = this.zipCodeField;
            this.invalidInputFieldName = this.zipCodeLabel.getText();
        } else if (this.validityPeriodField.getText() != null && KMUtil.isDBCSString(this.validityPeriodField.getText())) {
            bl = true;
            this.invalidInputField = this.validityPeriodField;
            this.invalidInputFieldName = this.validityPeriodLabel.getText();
        } else if (this.mode == 2 && this.certReqFileNameField.getText() != null && KMUtil.isDBCSString(this.certReqFileNameField.getText())) {
            bl = true;
            this.invalidInputField = this.certReqFileNameField;
            this.invalidInputFieldName = this.certReqFileNameLabel.getText();
        }
        if (this.includeSubjectAlternativeName) {
            if (this.emailAddressField.getText() != null && KMUtil.isDBCSString(this.emailAddressField.getText())) {
                bl = true;
                this.invalidInputField = this.emailAddressField;
                this.invalidInputFieldName = this.emailAddressLabel.getText();
            } else if (this.ipAddressField.getText() != null && !this.ipAddressField.getText().equals("")) {
                if (KMUtil.isDBCSString(this.ipAddressField.getText()) || KMUtil.isInvalidIPAddressValid(this.ipAddressField.getText())) {
                    bl = true;
                    this.invalidInputField = this.ipAddressField;
                    this.invalidInputFieldName = this.ipAddressLabel.getText();
                }
            } else if (this.dnsNameField.getText() != null && KMUtil.isDBCSString(this.dnsNameField.getText())) {
                bl = true;
                this.invalidInputField = this.dnsNameField;
                this.invalidInputFieldName = this.dnsNameLabel.getText();
            }
        }
        if (this.invalidInputField == null && !bl) {
            return true;
        }
        if (bl) {
            return false;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("evt=" + actionEvent + ", arg=" + string);
        }
        if (!(object instanceof JTextField) && object instanceof KMButton) {
            if (string.equals("OK")) {
                if (this.isInputValid()) {
                    if (this.keyDb.getMyCertLabelList() != null && this.keyDb.getMyCertLabelList().contains(this.labelField.getText())) {
                        KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                        return;
                    }
                    if (this.keyDb.getReqKeyLabelList() != null && this.keyDb.getReqKeyLabelList().contains(this.labelField.getText())) {
                        KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                        return;
                    }
                    if (this.keyDb.getCaCertLabelList() != null && this.keyDb.getCaCertLabelList().contains(this.labelField.getText())) {
                        KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                        return;
                    }
                    if (this.mode == 1) {
                        this.certVersion = CertificateItem.CERTIFICATE_VERSIONS.length - this.certVersionChoice.getSelectedIndex();
                    }
                    this.keyLabel = KMUtil.trimBlankSpace(this.labelField.getText());
                    this.keySize = KEYSIZE_CHOICE[this.keySizeChoice.getSelectedIndex()];
                    this.certReqFileName = this.mode != 1 ? KMUtil.trimBlankSpace(this.certReqFileNameField.getText()) : null;
                    this.subjectDNItem = new DNItem(KMUtil.trimBlankSpace(this.commonNameField.getText()), KMUtil.trimBlankSpace(this.orgUnitField.getText()), KMUtil.trimBlankSpace(this.orgField.getText()), KMUtil.trimBlankSpace(this.localityField.getText()), KMUtil.trimBlankSpace(this.stateField.getText()), KMUtil.trimBlankSpace(this.zipCodeField.getText()), (String)this.countryCodeChoices.getSelectedItem(), null, null);
                    if (this.mode == 1) {
                        try {
                            this.numValidDays = Integer.parseInt(this.validityPeriodField.getText());
                            if (this.numValidDays == 0) {
                                this.validityPeriodField.setText("");
                                this.validityPeriodField.requestFocus();
                                return;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.validityPeriodField.setText("");
                            this.validityPeriodField.requestFocus();
                            return;
                        }
                    }
                    ((Component)this).setVisible(false);
                } else {
                    String string2;
                    if (this.invalidInputField == this.validityPeriodField && this.numValidDays > 7300) {
                        string2 = KMSystem.getNLSErrString("GSKKM_ERR_EXPIRE_DAYS_TOO_LARGE");
                    } else {
                        if (this.invalidInputFieldName == null) {
                            this.invalidInputFieldName = "";
                        }
                        String string3 = KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT");
                        Object[] objectArray = new Object[]{this.invalidInputFieldName};
                        string2 = MessageFormat.format(string3, objectArray);
                    }
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), string2);
                    if (Ikeyman.printDebugMsg) {
                        Ikeyman.debugMsg("DEBUG......invalidInputField: " + this.invalidInputField);
                    }
                    if (this.invalidInputField != null) {
                        this.invalidInputField.requestFocus();
                    }
                }
            } else if (string.equals("Cancel")) {
                this.keyLabel = null;
                this.subjectDNItem = null;
                this.certReqFileName = null;
                ((Component)this).setVisible(false);
            } else if (string.equals("Reset")) {
                this.labelField.setText("");
                this.keySizeChoice.setSelectedIndex(this.defIdx);
                this.orgUnitField.setText("");
                this.orgField.setText("");
                this.localityField.setText("");
                this.stateField.setText("");
                this.zipCodeField.setText("");
                this.commonNameField.setText(KMSystem.getHostName());
                this.countryCodeChoices.setSelectedItem(KMSystem.getCountryName());
                if (this.mode == 1) {
                    this.validityPeriodField.setText("365");
                }
                if (this.includeSubjectAlternativeName) {
                    this.emailAddressField.setText("");
                    this.ipAddressField.setText("");
                    this.dnsNameField.setText("");
                }
                if (this.mode != 1) {
                    this.certReqFileNameField.setText(this.defaultCertReqFileFullPathName);
                } else {
                    this.certVersionChoice.setSelectedIndex(0);
                }
            } else if (string.equals("Help")) {
                String string4 = "packages.html";
                Ikeyman.showHelpWindow(this, string4);
            } else if (string.equals("Browse")) {
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("Browse button is hit\n");
                }
                JFileChooser jFileChooser = new JFileChooser(KMSystem.getWorkingDirName());
                if (KMFrame.isWindowLookAndFeel()) {
                    jFileChooser.setPreferredSize(new Dimension(((JComponent)object).getWidth() * 6, ((JComponent)object).getHeight() * 10));
                }
                KMFilenameFilter kMFilenameFilter = new KMFilenameFilter(".arm", Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE"));
                jFileChooser.addChoosableFileFilter(kMFilenameFilter);
                jFileChooser.setDialogTitle(Ikeyman.getNLSResString("GUI_MSG_TIP_NEW_CERTREQ"));
                Dimension dimension = jFileChooser.getSize();
                jFileChooser.setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    this.certReqFileNameField.setText(jFileChooser.getSelectedFile().toString());
                    KMSystem.setCurrentWorkingDirName(jFileChooser.getCurrentDirectory().toString() + File.separator, this.keyDb.getType());
                } else if (n != 1) {
                    if (n == -1) {
                        KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_NOT_OPENED"));
                    } else {
                        KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                    }
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange());
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.labelField.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            GenkeyDialog.this.keyLabel = null;
            GenkeyDialog.this.subjectDNItem = null;
            GenkeyDialog.this.certReqFileName = null;
            ((Component)GenkeyDialog.this).setVisible(false);
        }
    }

    class KeyInfoInputPanel
    extends JPanel {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        public KeyInfoInputPanel() {
            super(true);
            JSeparator jSeparator;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(this.gbl);
            this.gbc.anchor = 17;
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 0;
            JSeparator jSeparator2 = new JSeparator();
            this.gbl.setConstraints(jSeparator2, this.gbc);
            jPanel.add(jSeparator2);
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.titleLabel, this.gbc);
            jPanel.add(GenkeyDialog.this.titleLabel);
            this.add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel();
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new SoftBevelBorder(1));
            jPanel2.setBorder(compoundBorder);
            jPanel2.setLayout(this.gbl);
            this.gbc.insets = new Insets(5, 5, 2, 5);
            this.gbc.gridwidth = 3;
            this.gbl.setConstraints(GenkeyDialog.this.keyLabelLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.keyLabelLabel);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.labelField, this.gbc);
            jPanel2.add(GenkeyDialog.this.labelField);
            this.gbc.insets = new Insets(2, 5, 2, 5);
            this.gbc.fill = 0;
            if (GenkeyDialog.this.mode == 1) {
                this.gbc.gridwidth = 3;
                this.gbl.setConstraints(GenkeyDialog.this.versionLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.versionLabel);
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.certVersionChoice, this.gbc);
                jPanel2.add(GenkeyDialog.this.certVersionChoice);
            }
            this.gbc.fill = 0;
            this.gbc.gridwidth = 3;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.keySizeLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.keySizeLabel);
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.keySizeChoice, this.gbc);
            jPanel2.add(GenkeyDialog.this.keySizeChoice);
            this.gbc.gridwidth = 3;
            this.gbl.setConstraints(GenkeyDialog.this.commonNameLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.commonNameLabel);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.commonNameField, this.gbc);
            jPanel2.add(GenkeyDialog.this.commonNameField);
            this.gbc.fill = 0;
            this.gbc.gridwidth = 3;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.orgLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.orgLabel);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.orgField, this.gbc);
            jPanel2.add(GenkeyDialog.this.orgField);
            this.gbc.fill = 0;
            this.gbc.weightx = 0.0;
            this.gbc.gridwidth = 2;
            this.gbl.setConstraints(GenkeyDialog.this.orgUnitLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.orgUnitLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel1, this.gbc);
            jPanel2.add(GenkeyDialog.this.optionLabel1);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.orgUnitField, this.gbc);
            jPanel2.add(GenkeyDialog.this.orgUnitField);
            this.gbc.fill = 0;
            this.gbc.gridwidth = 2;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.localityLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.localityLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel2, this.gbc);
            jPanel2.add(GenkeyDialog.this.optionLabel2);
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.localityField, this.gbc);
            jPanel2.add(GenkeyDialog.this.localityField);
            this.gbc.fill = 0;
            this.gbc.gridwidth = 2;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.stateLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.stateLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel3, this.gbc);
            jPanel2.add(GenkeyDialog.this.optionLabel3);
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.stateField, this.gbc);
            jPanel2.add(GenkeyDialog.this.stateField);
            this.gbc.gridwidth = 2;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.zipCodeLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.zipCodeLabel);
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(GenkeyDialog.this.optionLabel4, this.gbc);
            jPanel2.add(GenkeyDialog.this.optionLabel4);
            this.gbc.weightx = 0.0;
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.zipCodeField, this.gbc);
            jPanel2.add(GenkeyDialog.this.zipCodeField);
            this.gbc.gridwidth = 3;
            this.gbc.weightx = 0.0;
            this.gbl.setConstraints(GenkeyDialog.this.countryLabel, this.gbc);
            jPanel2.add(GenkeyDialog.this.countryLabel);
            this.gbc.gridwidth = 0;
            this.gbl.setConstraints(GenkeyDialog.this.countryCodeChoices, this.gbc);
            jPanel2.add(GenkeyDialog.this.countryCodeChoices);
            if (GenkeyDialog.this.mode == 1) {
                this.gbc.gridwidth = 3;
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.validityPeriodLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.validityPeriodLabel);
                this.gbl.setConstraints(GenkeyDialog.this.validityPeriodField, this.gbc);
                jPanel2.add(GenkeyDialog.this.validityPeriodField);
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.daysLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.daysLabel);
            }
            if (GenkeyDialog.this.includeSubjectAlternativeName) {
                this.gbc.fill = 2;
                this.gbc.weightx = 1.0;
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.subjectAlternativeNamesLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.subjectAlternativeNamesLabel);
                this.gbc.insets = new Insets(2, 15, 2, 5);
                this.gbc.fill = 0;
                this.gbc.gridwidth = 2;
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.emailAddressLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.emailAddressLabel);
                this.gbc.insets = new Insets(2, 5, 2, 5);
                this.gbc.gridwidth = 1;
                this.gbl.setConstraints(GenkeyDialog.this.optionLabel5, this.gbc);
                jPanel2.add(GenkeyDialog.this.optionLabel5);
                this.gbc.fill = 2;
                this.gbc.weightx = 1.0;
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.emailAddressField, this.gbc);
                jPanel2.add(GenkeyDialog.this.emailAddressField);
                this.gbc.insets = new Insets(2, 15, 2, 5);
                this.gbc.fill = 0;
                this.gbc.gridwidth = 2;
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.ipAddressLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.ipAddressLabel);
                this.gbc.insets = new Insets(2, 5, 2, 5);
                this.gbc.gridwidth = 1;
                this.gbl.setConstraints(GenkeyDialog.this.optionLabel6, this.gbc);
                jPanel2.add(GenkeyDialog.this.optionLabel6);
                this.gbc.fill = 2;
                this.gbc.weightx = 1.0;
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.ipAddressField, this.gbc);
                jPanel2.add(GenkeyDialog.this.ipAddressField);
                this.gbc.insets = new Insets(2, 15, 2, 5);
                this.gbc.fill = 0;
                this.gbc.gridwidth = 2;
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.dnsNameLabel, this.gbc);
                jPanel2.add(GenkeyDialog.this.dnsNameLabel);
                this.gbc.insets = new Insets(2, 5, 2, 5);
                this.gbc.gridwidth = 1;
                this.gbl.setConstraints(GenkeyDialog.this.optionLabel7, this.gbc);
                jPanel2.add(GenkeyDialog.this.optionLabel7);
                this.gbc.fill = 2;
                this.gbc.weightx = 1.0;
                this.gbc.gridwidth = 0;
                this.gbl.setConstraints(GenkeyDialog.this.dnsNameField, this.gbc);
                jPanel2.add(GenkeyDialog.this.dnsNameField);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
            this.add((Component)jScrollPane, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(this.gbl);
            if (GenkeyDialog.this.mode == 2) {
                jSeparator = new JSeparator();
                this.gbc.weightx = 1.0;
                this.gbc.gridwidth = 0;
                this.gbc.insets = new Insets(10, 5, 10, 5);
                this.gbc.fill = 2;
                this.gbl.setConstraints(jSeparator, this.gbc);
                jPanel3.add(jSeparator);
                this.gbc.insets = new Insets(2, 5, 2, 5);
                this.gbc.weightx = 0.0;
                this.gbl.setConstraints(GenkeyDialog.this.certReqFileNameLabel, this.gbc);
                jPanel3.add(GenkeyDialog.this.certReqFileNameLabel);
                JPanel jPanel4 = new JPanel();
                jPanel4.setLayout(new BorderLayout());
                jPanel4.add((Component)GenkeyDialog.this.certReqFileNameField, "Center");
                jPanel4.add((Component)GenkeyDialog.this.browseButton, "East");
                this.gbc.weightx = 1.0;
                this.gbc.insets = new Insets(2, 10, 2, 5);
                this.gbl.setConstraints(jPanel4, this.gbc);
                jPanel3.add(jPanel4);
            }
            jSeparator = new JSeparator();
            this.gbc.insets = new Insets(10, 5, 10, 5);
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.fill = 2;
            this.gbl.setConstraints(jSeparator, this.gbc);
            jPanel3.add(jSeparator);
            this.add((Component)jPanel3, "South");
        }

        private void add(JComponent jComponent, int n, int n2, float f, float f2, int n3, Insets insets) {
            this.gbc.anchor = n;
            this.gbc.fill = n2;
            this.gbc.weightx = f;
            this.gbc.weighty = f2;
            this.gbc.gridwidth = n3;
            this.gbc.insets = insets;
            this.gbl.setConstraints(jComponent, this.gbc);
            this.add(jComponent);
        }

        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }
    }
}

