/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ib;
import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;

public class PKCS12KeyStoreV2
extends KeyStoreSpi {
    private static Date a;
    private static volatile int b;
    private SecureRandom c;
    private Map<String, Object> d = new HashMap<String, Object>();
    private CertificateFactory e = null;
    private static Class f;
    private static String[] z;

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey privateKey = null;
        Object object = this.d.get(string.toLowerCase());
        if (object == null || !(object instanceof ib)) {
            return null;
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = ((ib)object).a;
        if (encryptedPrivateKeyInfo == null) {
            return null;
        }
        byte[] byArray = encryptedPrivateKeyInfo.getEncryptedData();
        AlgorithmId algorithmId = encryptedPrivateKeyInfo.getAlgorithmId();
        AlgorithmParameters algorithmParameters = algorithmId.getAlgParameters();
        try {
            SecretKey secretKey = this.a(cArray);
            Cipher cipher = Cipher.getInstance(algorithmId.getName());
            cipher.init(2, (Key)secretKey, algorithmParameters);
            byte[] byArray2 = cipher.doFinal(byArray);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            DerValue derValue = new DerValue(byArray2);
            DerInputStream derInputStream = derValue.toDerInputStream();
            derInputStream.getInteger();
            DerValue[] derValueArray = derInputStream.getSequence(2);
            AlgorithmId algorithmId2 = new AlgorithmId(derValueArray[0].getOID());
            String string2 = algorithmId2.getName();
            KeyFactory keyFactory = KeyFactory.getInstance(string2);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException(z[23] + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return privateKey;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object object = this.d.get(string.toLowerCase());
        if (object != null && object instanceof ib && ((ib)object).c != null) {
            certificateArray = (Certificate[])((ib)object).c.clone();
        }
        if (certificateArray != null && this.e != null && certificateArray[0] != null && f != null && !f.isInstance(certificateArray[0])) {
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                if (certificateArray[i2] == null) continue;
                Certificate certificate = certificateArray[i2];
                try {
                    byte[] byArray = certificateArray[i2].getEncoded();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    certificateArray[i2] = this.e.generateCertificate(byteArrayInputStream);
                    continue;
                }
                catch (Exception exception) {
                    certificateArray[i2] = certificate;
                }
            }
        }
        return certificateArray;
    }

    public Certificate engineGetCertificate(String string) {
        Object object = this.d.get(string.toLowerCase());
        if (object != null && object instanceof ib) {
            if (((ib)object).c == null) {
                return null;
            }
            return ((ib)object).c[0];
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Map<String, Object> map = this.d;
        synchronized (map) {
            try {
                ib ib2 = new ib(this);
                if (key instanceof PrivateKey) {
                    if (!key.getFormat().equals(z[7]) && !key.getFormat().equals(z[4])) {
                        throw new KeyStoreException(z[8]);
                    }
                    ib2.a = this.a(key.getEncoded(), cArray);
                    if (certificateArray != null) {
                        if (certificateArray.length > 1 && !this.a(certificateArray)) {
                            throw new KeyStoreException(z[5]);
                        }
                        ib2.c = (Certificate[])certificateArray.clone();
                    }
                } else {
                    throw new KeyStoreException(z[9]);
                }
                this.d.put(string.toLowerCase(), ib2);
            }
            catch (Exception exception) {
                KeyStoreException keyStoreException = new KeyStoreException(z[6] + exception);
                keyStoreException.initCause(exception);
                throw keyStoreException;
            }
        }
    }

    private EncryptedPrivateKeyInfo a(byte[] byArray, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
        try {
            AlgorithmParameters algorithmParameters = this.a(z[19]);
            SecretKey secretKey = this.a(cArray);
            Cipher cipher = Cipher.getInstance(z[18]);
            cipher.init(1, (Key)secretKey, algorithmParameters);
            byte[] byArray2 = cipher.doFinal(byArray);
            AlgorithmId algorithmId = new AlgorithmId(PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID, algorithmParameters.getEncoded());
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmId, byArray2);
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException(z[20] + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return encryptedPrivateKeyInfo;
    }

    private AlgorithmParameters a(String string) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.a(), 1024);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(z[3] + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private byte[] a() {
        byte[] byArray = new byte[20];
        if (this.c == null) {
            this.c = new SecureRandom();
        }
        byArray = this.c.generateSeed(20);
        return byArray;
    }

    private SecretKey a(char[] cArray) throws IOException {
        SecretKey secretKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(z[10]);
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(z[11] + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return secretKey;
    }

    private boolean a(Certificate[] certificateArray) {
        for (int i2 = 0; i2 < certificateArray.length - 1; ++i2) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i2]).getIssuerX500Principal();
            if (x500Principal2.equals(x500Principal = ((X509Certificate)certificateArray[i2 + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException(z[17]);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Object object = this.d.get(string.toLowerCase());
        if (object != null && object instanceof ib) {
            throw new KeyStoreException(z[22]);
        }
        throw new KeyStoreException(z[21]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Map<String, Object> map = this.d;
        synchronized (map) {
            this.d.remove(string.toLowerCase());
        }
    }

    public Enumeration engineAliases() {
        return Collections.enumeration(this.d.keySet());
    }

    public boolean engineContainsAlias(String string) {
        return this.d.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.d.size();
    }

    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object object = this.d.get(string.toLowerCase());
        if (object != null && object instanceof ib) {
            bl = true;
        }
        return bl;
    }

    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration<String> enumeration = Collections.enumeration(this.d.keySet());
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = enumeration.nextElement();
            Object object = this.d.get(string);
            if (!(object instanceof ib) || ((ib)object).c == null || !(certificate2 = ((ib)object).c[0]).equals(certificate)) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Map<String, Object> map = this.d;
        synchronized (map) {
            if (cArray == null) {
                throw new IllegalArgumentException(z[1]);
            }
            try {
                PFX pFX = new PFX();
                Enumeration<String> enumeration = Collections.enumeration(this.d.keySet());
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    Object object = this.d.get(string);
                    if (!(object instanceof ib)) continue;
                    pFX.addShroudedKey(((ib)object).a, string, ((ib)object).b);
                    Certificate[] certificateArray = ((ib)object).c;
                    if (certificateArray == null) continue;
                    for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                        pFX.addCertificate(certificateArray[i2], string, ((ib)object).b);
                    }
                }
                pFX.protect(z[0], cArray);
                pFX.encode(outputStream);
            }
            catch (Exception exception) {
                throw new IOException(z[2] + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Map<String, Object> map = this.d;
        synchronized (map) {
            if (inputStream == null || cArray == null) {
                throw new IllegalArgumentException(z[14]);
            }
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            inputStream.read(byArray);
            PFX pFX = new PFX(byArray);
            if (!pFX.verifyMac(cArray)) {
                throw new IOException(z[16]);
            }
            EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray = null;
            try {
                encryptedPrivateKeyInfoArray = pFX.getShroudedKeys(cArray);
            }
            catch (Exception exception) {
                throw new IOException(z[15] + exception.getMessage());
            }
            if (encryptedPrivateKeyInfoArray != null) {
                try {
                    for (int i2 = 0; i2 < encryptedPrivateKeyInfoArray.length; ++i2) {
                        String string;
                        ib ib2 = new ib(this);
                        ib2.a = encryptedPrivateKeyInfoArray[i2];
                        ib2.b = pFX.getLocalKeyIdOfShroudedKey(ib2.a, cArray);
                        Certificate[] certificateArray = this.a(ib2.a, ib2.b, cArray, pFX);
                        if (certificateArray != null) {
                            ib2.c = (Certificate[])certificateArray.clone();
                        }
                        if ((string = pFX.getFriendlyNameOfShroudedKey(ib2.a, cArray)) == null) {
                            string = ib2.c == null ? this.c() : ((X509Certificate)ib2.c[0]).getSerialNumber().toString() + ((Object)((X509Certificate)ib2.c[0]).getSubjectDN()).toString() + ((Object)((X509Certificate)ib2.c[0]).getIssuerDN()).toString();
                        }
                        this.d.put(string.toLowerCase(), ib2);
                    }
                }
                catch (Exception exception) {
                    throw new IOException(z[15] + exception.getMessage());
                }
            }
        }
    }

    private PrivateKey a(PrivateKey privateKey) throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm(), z[13]);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    private Certificate[] a(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, byte[] byArray, char[] cArray, PFX pFX) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        int n2;
        Certificate[] certificateArray;
        Serializable serializable2 = null;
        Certificate[] certificateArray2 = pFX.getCertificatesByLocalKeyId(cArray, byArray);
        if (certificateArray2 != null) {
            certificateArray = certificateArray2;
            n2 = certificateArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                serializable = certificateArray[i2];
                object2 = Signature.getInstance(((X509Certificate)serializable).getSigAlgName(), z[13]);
                ((Signature)object2).initSign(this.a((PrivateKey)new PrivateKeyInfo(encryptedPrivateKeyInfo.decrypt(cArray))));
                ((Signature)object2).update(z[12].getBytes());
                object = ((Signature)object2).sign();
                ((Signature)object2).initVerify(((Certificate)serializable).getPublicKey());
                ((Signature)object2).update(z[12].getBytes());
                if (!((Signature)object2).verify((byte[])object)) continue;
                serializable2 = serializable;
                break;
            }
        }
        if (serializable2 != null) {
            try {
                serializable2.verify(serializable2.getPublicKey());
                certificateArray = new Certificate[]{certificateArray2[0]};
                return certificateArray;
            }
            catch (Exception exception) {
                boolean bl = false;
                Certificate certificate = certificateArray2[0];
                serializable = new LinkedList();
                ((LinkedList)serializable).add(certificateArray2[0]);
                object2 = ((X509Certificate)certificate).getIssuerDN();
                for (n2 = 0; !bl && n2 < certificateArray2.length; ++n2) {
                    object = ((X509Certificate)certificateArray2[n2]).getSubjectDN();
                    if (!object.equals(object2)) continue;
                    ((LinkedList)serializable).add(certificateArray2[n2]);
                    object2 = ((X509Certificate)certificateArray2[n2]).getIssuerDN();
                    if (object.equals(object2)) {
                        bl = true;
                    }
                    n2 = -1;
                }
                object = new Certificate[((LinkedList)serializable).size()];
                for (int i3 = 0; i3 < ((Certificate[])object).length; ++i3) {
                    object[i3] = (Certificate)((LinkedList)serializable).get(i3);
                }
                ((LinkedList)serializable).clear();
                return object;
            }
        }
        return null;
    }

    private String c() {
        return String.valueOf(++b);
    }

    static {
        String[] stringArray = new String[24];
        Object var1 = null;
        stringArray[0] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("V\u0016\u0013R\u00150ec"));
        var1 = null;
        stringArray[1] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("\u0012G\"H\u0016\rT5\u001b\u0002\u0003H?T\u0015BD4\u001b\u000f\u0017J="));
        var1 = null;
        stringArray[2] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("'T#T\u0013BO?\u001b\u0012\u0016I#R\u000f\u0005\u0006%S\u0004BM4BA\u0011R>I\u0004X\u0006"));
        var1 = null;
        stringArray[3] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("\u0005C%z\r\u0005I#R\u0015\nK\u0001Z\u0013\u0003K4O\u0004\u0010Uq]\u0000\u000bJ4_[B"));
        var1 = null;
        stringArray[4] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("2m\u0012hY"));
        var1 = null;
        stringArray[5] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("!C#O\b\u0004O2Z\u0015\u0007\u00062S\u0000\u000bHqR\u0012BO?M\u0000\u000eO5"));
        var1 = null;
        stringArray[6] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z(")C(\u001b\u0011\u0010I%^\u0002\u0016O>UABG=\\\u000e\u0010O%S\fBH>OA\u0004I$U\u0005X\u0006"));
        var1 = null;
        stringArray[7] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("2m\u0012hBZ"));
        var1 = null;
        stringArray[8] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z(")C(\u001b\b\u0011\u0006?T\u0015BC?X\u000e\u0006C5\u001b\b\f\u0006\u0001p\"1\u0005i\u001b\u0007\rT<Z\u0015"));
        var1 = null;
        stringArray[9] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z(")C(\u001b\b\u0011\u0006?T\u0015BGqk\u0013\u000bP0O\u0004)C("));
        var1 = null;
        stringArray[10] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("2d\u0014"));
        var1 = null;
        stringArray[11] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("\u0005C%h\u0004\u0001T4O*\u0007_q]\u0000\u000bJ4_[B"));
        var1 = null;
        stringArray[12] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("\u0016C\"O\b\fAqY\u0018\u0016C\""));
        var1 = null;
        stringArray[13] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("+d\u001cq\"'"));
        var1 = null;
        stringArray[14] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z(",S=WA\u0012G#Z\f\u0007R4IA\u0012T>M\b\u0006C5"));
        var1 = null;
        stringArray[15] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("'T#T\u0013BO?\u001b\r\rG5R\u000f\u0005\u0006%S\u0004BM4B\u0012\u0016I#^[B"));
        var1 = null;
        stringArray[16] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("7H0Y\r\u0007\u0006%TA\u0014C#R\u0007\u001b\u0006\u001cz\"L"));
        var1 = null;
        stringArray[17] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("6N8HA\u000fC%S\u000e\u0006\u00068HA\fI%\u001b\u0012\u0017V!T\u0013\u0016C5"));
        var1 = null;
        stringArray[18] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("2d\u0014l\b\u0016N\u0002s #H5\b*\u0007_\u0005I\b\u0012J4\u007f$1"));
        var1 = null;
        stringArray[19] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("2d\u0014l\b\u0016N\u0002s Sg?_%'u4_\u0004"));
        var1 = null;
        stringArray[20] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("'H2I\u0018\u0012Rqk\u0013\u000bP0O\u0004Bm4BA\u0004G8W\u0004\u0006\u001cq"));
        var1 = null;
        stringArray[21] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("6T$H\u0015\u0007B\u0012^\u0013\u0016c?O\u0013\u001b\u0006?T\u0015BU$K\u0011\rT%^\u0005"));
        var1 = null;
        stringArray[22] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("!G?U\u000e\u0016\u0006>M\u0004\u0010Q#R\u0015\u0007\u0006>L\u000fBE4I\u0015\u000b@8X\u0000\u0016C"));
        var1 = null;
        stringArray[23] = PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("%C%\u001b*\u0007_q]\u0000\u000bJ4_[B"));
        z = stringArray;
        a = new Date(0L);
        b = 0;
        f = null;
        try {
            var1 = null;
            f = Class.forName(PKCS12KeyStoreV2.z(PKCS12KeyStoreV2.z("\u0011S?\u0015\u0012\u0007E$I\b\u0016_\u007fCTR\u001f\u007fcTR\u001f\u0012^\u0013\u0016o<K\r")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static char[] z(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x61);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block9: {
            int n2;
            int n3;
            block8: {
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray2 = cArray2;
                int n5 = n2;
                char c2 = cArray2[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 98;
                        break;
                    }
                    case 1: {
                        n4 = 38;
                        break;
                    }
                    case 2: {
                        n4 = 81;
                        break;
                    }
                    case 3: {
                        n4 = 59;
                        break;
                    }
                    default: {
                        n4 = 97;
                    }
                }
                cArray2[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

