/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.k;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();
    private static String[] z;

    IdentityDatabase() throws InvalidParameterException {
        this(z[23]);
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(z[3], classNotFoundException);
            IdentityDatabase.b(z[6]);
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(z[3], invalidClassException);
            IdentityDatabase.b(z[4]);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(z[7], streamCorruptedException);
            IdentityDatabase.b(z[5]);
        }
        if (identityDatabase != null) return identityDatabase;
        return new IdentityDatabase(z[8]);
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(z[9]);
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(z[9]);
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.c(z[15]);
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = z[14];
        }
        if (identity3 != null) {
            string = z[13];
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.c(z[11]);
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(z[10] + string + z[12] + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(z[3], invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException(z[22]);
        }
        this.b(this.sourceFile);
    }

    private static File c() {
        String string = Security.getProperty(z[1]);
        if (string == null) {
            string = System.getProperty(z[0]) + File.separatorChar + z[2];
        }
        return new File(string);
    }

    private static void d() {
        File file = IdentityDatabase.c();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(z[18] + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(z[20] + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(z[19] + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(z[21] + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return z[17] + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.e();
            securityManager.checkSecurityAccess(string);
        }
    }

    String e() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(z[16]);
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void f() {
        IdentityDatabase.d();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block239: {
            int n2;
            int n3;
            block238: {
                char[] cArray2;
                Object var0;
                block237: {
                    int n4;
                    block236: {
                        char[] cArray3;
                        block235: {
                            int n5;
                            block234: {
                                char[] cArray4;
                                block233: {
                                    int n6;
                                    block232: {
                                        char[] cArray5;
                                        block231: {
                                            int n7;
                                            block230: {
                                                char[] cArray6;
                                                block229: {
                                                    int n8;
                                                    block228: {
                                                        char[] cArray7;
                                                        block227: {
                                                            int n9;
                                                            block226: {
                                                                char[] cArray8;
                                                                block225: {
                                                                    int n10;
                                                                    block224: {
                                                                        char[] cArray9;
                                                                        block223: {
                                                                            int n11;
                                                                            block222: {
                                                                                char[] cArray10;
                                                                                block221: {
                                                                                    int n12;
                                                                                    block220: {
                                                                                        char[] cArray11;
                                                                                        block219: {
                                                                                            int n13;
                                                                                            block218: {
                                                                                                char[] cArray12;
                                                                                                block217: {
                                                                                                    int n14;
                                                                                                    block216: {
                                                                                                        char[] cArray13;
                                                                                                        block215: {
                                                                                                            int n15;
                                                                                                            block214: {
                                                                                                                char[] cArray14;
                                                                                                                block213: {
                                                                                                                    int n16;
                                                                                                                    block212: {
                                                                                                                        char[] cArray15;
                                                                                                                        block211: {
                                                                                                                            int n17;
                                                                                                                            block210: {
                                                                                                                                char[] cArray16;
                                                                                                                                block209: {
                                                                                                                                    int n18;
                                                                                                                                    block208: {
                                                                                                                                        char[] cArray17;
                                                                                                                                        block207: {
                                                                                                                                            int n19;
                                                                                                                                            block206: {
                                                                                                                                                char[] cArray18;
                                                                                                                                                block205: {
                                                                                                                                                    int n20;
                                                                                                                                                    block204: {
                                                                                                                                                        char[] cArray19;
                                                                                                                                                        block203: {
                                                                                                                                                            int n21;
                                                                                                                                                            block202: {
                                                                                                                                                                char[] cArray20;
                                                                                                                                                                block201: {
                                                                                                                                                                    int n22;
                                                                                                                                                                    block200: {
                                                                                                                                                                        char[] cArray21;
                                                                                                                                                                        block199: {
                                                                                                                                                                            int n23;
                                                                                                                                                                            block198: {
                                                                                                                                                                                char[] cArray22;
                                                                                                                                                                                block197: {
                                                                                                                                                                                    int n24;
                                                                                                                                                                                    block196: {
                                                                                                                                                                                        char[] cArray23;
                                                                                                                                                                                        block195: {
                                                                                                                                                                                            int n25;
                                                                                                                                                                                            block194: {
                                                                                                                                                                                                char[] cArray24;
                                                                                                                                                                                                block193: {
                                                                                                                                                                                                    int n26;
                                                                                                                                                                                                    block192: {
                                                                                                                                                                                                        stringArray = new String[24];
                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                        char[] cArray25 = ")WzZ\"4KrM".toCharArray();
                                                                                                                                                                                                        cArray24 = cArray25;
                                                                                                                                                                                                        n26 = cArray25.length;
                                                                                                                                                                                                        n3 = 0;
                                                                                                                                                                                                        if (!true) break block192;
                                                                                                                                                                                                        n26 = n26;
                                                                                                                                                                                                        if (n26 <= n3) break block193;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    do {
                                                                                                                                                                                                        int n27;
                                                                                                                                                                                                        cArray24 = cArray24;
                                                                                                                                                                                                        int n28 = n3;
                                                                                                                                                                                                        char c2 = cArray24[n28];
                                                                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                                                                            case 0: {
                                                                                                                                                                                                                n27 = 92;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            case 1: {
                                                                                                                                                                                                                n27 = 36;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            case 2: {
                                                                                                                                                                                                                n27 = 31;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            case 3: {
                                                                                                                                                                                                                n27 = 40;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            default: {
                                                                                                                                                                                                                n27 = 12;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                        cArray24[n28] = (char)(c2 ^ n27);
                                                                                                                                                                                                        ++n3;
                                                                                                                                                                                                        n26 = n26;
                                                                                                                                                                                                    } while (n26 > n3);
                                                                                                                                                                                                }
                                                                                                                                                                                                stringArray[0] = new String(cArray24).intern();
                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                char[] cArray26 = "5@zFx5Pf\u0006h=P~Jm/A".toCharArray();
                                                                                                                                                                                                cArray23 = cArray26;
                                                                                                                                                                                                n25 = cArray26.length;
                                                                                                                                                                                                n3 = 0;
                                                                                                                                                                                                if (!true) break block194;
                                                                                                                                                                                                n25 = n25;
                                                                                                                                                                                                if (n25 <= n3) break block195;
                                                                                                                                                                                            }
                                                                                                                                                                                            do {
                                                                                                                                                                                                int n29;
                                                                                                                                                                                                cArray23 = cArray23;
                                                                                                                                                                                                int n30 = n3;
                                                                                                                                                                                                char c3 = cArray23[n30];
                                                                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                                                                    case 0: {
                                                                                                                                                                                                        n29 = 92;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    case 1: {
                                                                                                                                                                                                        n29 = 36;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    case 2: {
                                                                                                                                                                                                        n29 = 31;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    case 3: {
                                                                                                                                                                                                        n29 = 40;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    default: {
                                                                                                                                                                                                        n29 = 12;
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                                cArray23[n30] = (char)(c3 ^ n29);
                                                                                                                                                                                                ++n3;
                                                                                                                                                                                                n25 = n25;
                                                                                                                                                                                            } while (n25 > n3);
                                                                                                                                                                                        }
                                                                                                                                                                                        stringArray[1] = new String(cArray23).intern();
                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                        char[] cArray27 = "5@zFx5PfLnrK}B".toCharArray();
                                                                                                                                                                                        cArray22 = cArray27;
                                                                                                                                                                                        n24 = cArray27.length;
                                                                                                                                                                                        n3 = 0;
                                                                                                                                                                                        if (!true) break block196;
                                                                                                                                                                                        n24 = n24;
                                                                                                                                                                                        if (n24 <= n3) break block197;
                                                                                                                                                                                    }
                                                                                                                                                                                    do {
                                                                                                                                                                                        int n31;
                                                                                                                                                                                        cArray22 = cArray22;
                                                                                                                                                                                        int n32 = n3;
                                                                                                                                                                                        char c4 = cArray22[n32];
                                                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                                                            case 0: {
                                                                                                                                                                                                n31 = 92;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            case 1: {
                                                                                                                                                                                                n31 = 36;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            case 2: {
                                                                                                                                                                                                n31 = 31;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            case 3: {
                                                                                                                                                                                                n31 = 40;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            default: {
                                                                                                                                                                                                n31 = 12;
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                        cArray22[n32] = (char)(c4 ^ n31);
                                                                                                                                                                                        ++n3;
                                                                                                                                                                                        n24 = n24;
                                                                                                                                                                                    } while (n24 > n3);
                                                                                                                                                                                }
                                                                                                                                                                                stringArray[2] = new String(cArray22).intern();
                                                                                                                                                                                var0 = null;
                                                                                                                                                                                char[] cArray28 = "\bLv[,/Lp]`8\u0004qGx|Fz\bd=ToMb5Jx\u0006".toCharArray();
                                                                                                                                                                                cArray21 = cArray28;
                                                                                                                                                                                n23 = cArray28.length;
                                                                                                                                                                                n3 = 0;
                                                                                                                                                                                if (!true) break block198;
                                                                                                                                                                                n23 = n23;
                                                                                                                                                                                if (n23 <= n3) break block199;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                int n33;
                                                                                                                                                                                cArray21 = cArray21;
                                                                                                                                                                                int n34 = n3;
                                                                                                                                                                                char c5 = cArray21[n34];
                                                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                                                    case 0: {
                                                                                                                                                                                        n33 = 92;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    case 1: {
                                                                                                                                                                                        n33 = 36;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    case 2: {
                                                                                                                                                                                        n33 = 31;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    case 3: {
                                                                                                                                                                                        n33 = 40;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    default: {
                                                                                                                                                                                        n33 = 12;
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                cArray21[n34] = (char)(c5 ^ n33);
                                                                                                                                                                                ++n3;
                                                                                                                                                                                n23 = n23;
                                                                                                                                                                            } while (n23 > n3);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[3] = new String(cArray21).intern();
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray29 = "\tJ~J`9\u0004kG,5Jv\\e=HvRi|Wf[x9I?Ah9JkAx%\u0004lKc,A%\b,\u0015JiI`5@\\Dm/WZPo9TkAc2\n?\"X4Ml\be/\u0004rG\u007f(\u0004sAg9Hf\bh)A?\\c|E?[i.M~De&EkAc2\u0004iM~/MpFe2C?X~3FsMaf\u0004~\bo0El[,)WzL,5J?Ci%\u0004rIb=CzEi2P?_m/\u0004pJ\u007f3Hz\\i8".toCharArray();
                                                                                                                                                                        cArray20 = cArray29;
                                                                                                                                                                        n22 = cArray29.length;
                                                                                                                                                                        n3 = 0;
                                                                                                                                                                        if (!true) break block200;
                                                                                                                                                                        n22 = n22;
                                                                                                                                                                        if (n22 <= n3) break block201;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        int n35;
                                                                                                                                                                        cArray20 = cArray20;
                                                                                                                                                                        int n36 = n3;
                                                                                                                                                                        char c6 = cArray20[n36];
                                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                                            case 0: {
                                                                                                                                                                                n35 = 92;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            case 1: {
                                                                                                                                                                                n35 = 36;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            case 2: {
                                                                                                                                                                                n35 = 31;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            case 3: {
                                                                                                                                                                                n35 = 40;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            default: {
                                                                                                                                                                                n35 = 12;
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        cArray20[n36] = (char)(c6 ^ n35);
                                                                                                                                                                        ++n3;
                                                                                                                                                                        n22 = n22;
                                                                                                                                                                    } while (n22 > n3);
                                                                                                                                                                }
                                                                                                                                                                stringArray[4] = new String(cArray20).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray30 = "\tJ~J`9\u0004kG,5Jv\\e=HvRi|Wf[x9I?Ah9JkAx%\u0004lKc,A1\b_(VzIa\u001fKmZ|)PzLI$GzXx5Kq\u0006".toCharArray();
                                                                                                                                                                cArray19 = cArray30;
                                                                                                                                                                n21 = cArray30.length;
                                                                                                                                                                n3 = 0;
                                                                                                                                                                if (!true) break block202;
                                                                                                                                                                n21 = n21;
                                                                                                                                                                if (n21 <= n3) break block203;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                int n37;
                                                                                                                                                                cArray19 = cArray19;
                                                                                                                                                                int n38 = n3;
                                                                                                                                                                char c7 = cArray19[n38];
                                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                                    case 0: {
                                                                                                                                                                        n37 = 92;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    case 1: {
                                                                                                                                                                        n37 = 36;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    case 2: {
                                                                                                                                                                        n37 = 31;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    case 3: {
                                                                                                                                                                        n37 = 40;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    default: {
                                                                                                                                                                        n37 = 12;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                cArray19[n38] = (char)(c7 ^ n37);
                                                                                                                                                                ++n3;
                                                                                                                                                                n21 = n21;
                                                                                                                                                            } while (n21 > n3);
                                                                                                                                                        }
                                                                                                                                                        stringArray[5] = new String(cArray19).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray31 = "\bLz\bz9VlAc2\u0004pN,(Lz\bh=P~Jm/A?A\u007f|K}[c0AkM\"|g~Fb3P?Ab5PvI`5^z\u0006".toCharArray();
                                                                                                                                                        cArray18 = cArray31;
                                                                                                                                                        n20 = cArray31.length;
                                                                                                                                                        n3 = 0;
                                                                                                                                                        if (!true) break block204;
                                                                                                                                                        n20 = n20;
                                                                                                                                                        if (n20 <= n3) break block205;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        int n39;
                                                                                                                                                        cArray18 = cArray18;
                                                                                                                                                        int n40 = n3;
                                                                                                                                                        char c8 = cArray18[n40];
                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                            case 0: {
                                                                                                                                                                n39 = 92;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 1: {
                                                                                                                                                                n39 = 36;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 2: {
                                                                                                                                                                n39 = 31;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 3: {
                                                                                                                                                                n39 = 40;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            default: {
                                                                                                                                                                n39 = 12;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                        cArray18[n40] = (char)(c8 ^ n39);
                                                                                                                                                        ++n3;
                                                                                                                                                        n20 = n20;
                                                                                                                                                    } while (n20 > n3);
                                                                                                                                                }
                                                                                                                                                stringArray[6] = new String(cArray18).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray32 = "\bLz\b\u007f9VvI`5^~\\e3J?[x.A~E,5W?Kc.VjXx9@1\bY2E}Di|Pp\b`3E{\u0006".toCharArray();
                                                                                                                                                cArray17 = cArray32;
                                                                                                                                                n19 = cArray32.length;
                                                                                                                                                n3 = 0;
                                                                                                                                                if (!true) break block206;
                                                                                                                                                n19 = n19;
                                                                                                                                                if (n19 <= n3) break block207;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                int n41;
                                                                                                                                                cArray17 = cArray17;
                                                                                                                                                int n42 = n3;
                                                                                                                                                char c9 = cArray17[n42];
                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                    case 0: {
                                                                                                                                                        n41 = 92;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 1: {
                                                                                                                                                        n41 = 36;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 2: {
                                                                                                                                                        n41 = 31;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 3: {
                                                                                                                                                        n41 = 40;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    default: {
                                                                                                                                                        n41 = 12;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                cArray17[n42] = (char)(c9 ^ n41);
                                                                                                                                                ++n3;
                                                                                                                                                n19 = n19;
                                                                                                                                            } while (n19 > n3);
                                                                                                                                        }
                                                                                                                                        stringArray[7] = new String(cArray17).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray33 = ")JvFe(M~De&A{".toCharArray();
                                                                                                                                        cArray16 = cArray33;
                                                                                                                                        n18 = cArray33.length;
                                                                                                                                        n3 = 0;
                                                                                                                                        if (!true) break block208;
                                                                                                                                        n18 = n18;
                                                                                                                                        if (n18 <= n3) break block209;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        int n43;
                                                                                                                                        cArray16 = cArray16;
                                                                                                                                        int n44 = n3;
                                                                                                                                        char c10 = cArray16[n44];
                                                                                                                                        switch (n3 % 5) {
                                                                                                                                            case 0: {
                                                                                                                                                n43 = 92;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 1: {
                                                                                                                                                n43 = 36;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 2: {
                                                                                                                                                n43 = 31;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 3: {
                                                                                                                                                n43 = 40;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                n43 = 12;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        cArray16[n44] = (char)(c10 ^ n43);
                                                                                                                                        ++n3;
                                                                                                                                        n18 = n18;
                                                                                                                                    } while (n18 > n3);
                                                                                                                                }
                                                                                                                                stringArray[8] = new String(cArray16).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray34 = ";Ak\u0006\u007f5CqM~".toCharArray();
                                                                                                                                cArray15 = cArray34;
                                                                                                                                n17 = cArray34.length;
                                                                                                                                n3 = 0;
                                                                                                                                if (!true) break block210;
                                                                                                                                n17 = n17;
                                                                                                                                if (n17 <= n3) break block211;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                int n45;
                                                                                                                                cArray15 = cArray15;
                                                                                                                                int n46 = n3;
                                                                                                                                char c11 = cArray15[n46];
                                                                                                                                switch (n3 % 5) {
                                                                                                                                    case 0: {
                                                                                                                                        n45 = 92;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 1: {
                                                                                                                                        n45 = 36;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 2: {
                                                                                                                                        n45 = 31;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 3: {
                                                                                                                                        n45 = 40;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    default: {
                                                                                                                                        n45 = 12;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                cArray15[n46] = (char)(c11 ^ n45);
                                                                                                                                ++n3;
                                                                                                                                n17 = n17;
                                                                                                                            } while (n17 > n3);
                                                                                                                        }
                                                                                                                        stringArray[9] = new String(cArray15).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray35 = "(LzZi|Ml\bb3\u0004vLi2Pv\\u|J~Ei8\u0004".toCharArray();
                                                                                                                        cArray14 = cArray35;
                                                                                                                        n16 = cArray35.length;
                                                                                                                        n3 = 0;
                                                                                                                        if (!true) break block212;
                                                                                                                        n16 = n16;
                                                                                                                        if (n16 <= n3) break block213;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        int n47;
                                                                                                                        cArray14 = cArray14;
                                                                                                                        int n48 = n3;
                                                                                                                        char c12 = cArray14[n48];
                                                                                                                        switch (n3 % 5) {
                                                                                                                            case 0: {
                                                                                                                                n47 = 92;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                n47 = 36;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 2: {
                                                                                                                                n47 = 31;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 3: {
                                                                                                                                n47 = 40;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            default: {
                                                                                                                                n47 = 12;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        cArray14[n48] = (char)(c12 ^ n47);
                                                                                                                        ++n3;
                                                                                                                        n16 = n16;
                                                                                                                    } while (n16 > n3);
                                                                                                                }
                                                                                                                stringArray[10] = new String(cArray14).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray36 = ".ArGz9\nvLi2Pv\\u".toCharArray();
                                                                                                                cArray13 = cArray36;
                                                                                                                n15 = cArray36.length;
                                                                                                                n3 = 0;
                                                                                                                if (!true) break block214;
                                                                                                                n15 = n15;
                                                                                                                if (n15 <= n3) break block215;
                                                                                                            }
                                                                                                            do {
                                                                                                                int n49;
                                                                                                                cArray13 = cArray13;
                                                                                                                int n50 = n3;
                                                                                                                char c13 = cArray13[n50];
                                                                                                                switch (n3 % 5) {
                                                                                                                    case 0: {
                                                                                                                        n49 = 92;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 1: {
                                                                                                                        n49 = 36;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        n49 = 31;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3: {
                                                                                                                        n49 = 40;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        n49 = 12;
                                                                                                                    }
                                                                                                                }
                                                                                                                cArray13[n50] = (char)(c13 ^ n49);
                                                                                                                ++n3;
                                                                                                                n15 = n15;
                                                                                                            } while (n15 > n3);
                                                                                                        }
                                                                                                        stringArray[11] = new String(cArray13).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray37 = "|Mq\b".toCharArray();
                                                                                                        cArray12 = cArray37;
                                                                                                        n14 = cArray37.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block216;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block217;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n51;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n52 = n3;
                                                                                                        char c14 = cArray12[n52];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n51 = 92;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n51 = 36;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n51 = 31;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n51 = 40;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n51 = 12;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n52] = (char)(c14 ^ n51);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[12] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray38 = "7Af\bo3JyDe?P".toCharArray();
                                                                                                cArray11 = cArray38;
                                                                                                n13 = cArray38.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block218;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block219;
                                                                                            }
                                                                                            do {
                                                                                                int n53;
                                                                                                cArray11 = cArray11;
                                                                                                int n54 = n3;
                                                                                                char c15 = cArray11[n54];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n53 = 92;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n53 = 36;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n53 = 31;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n53 = 40;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n53 = 12;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n54] = (char)(c15 ^ n53);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[13] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray39 = "2ErM,?KqN`5Gk".toCharArray();
                                                                                        cArray10 = cArray39;
                                                                                        n12 = cArray39.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block220;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block221;
                                                                                    }
                                                                                    do {
                                                                                        int n55;
                                                                                        cArray10 = cArray10;
                                                                                        int n56 = n3;
                                                                                        char c16 = cArray10[n56];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n55 = 92;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n55 = 36;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n55 = 31;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n55 = 40;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n55 = 12;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n56] = (char)(c16 ^ n55);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[14] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray40 = "=@{\u0006e8Aq\\e(]".toCharArray();
                                                                                cArray9 = cArray40;
                                                                                n11 = cArray40.length;
                                                                                n3 = 0;
                                                                                if (!true) break block222;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block223;
                                                                            }
                                                                            do {
                                                                                int n57;
                                                                                cArray9 = cArray9;
                                                                                int n58 = n3;
                                                                                char c17 = cArray9[n58];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n57 = 92;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n57 = 36;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n57 = 31;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n57 = 40;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n57 = 12;
                                                                                    }
                                                                                }
                                                                                cArray9[n58] = (char)(c17 ^ n57);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[15] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray41 = "/AmAm0MeM\"5@zFx5Pf\u0006h=P~Jm/A".toCharArray();
                                                                        cArray8 = cArray41;
                                                                        n10 = cArray41.length;
                                                                        n3 = 0;
                                                                        if (!true) break block224;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block225;
                                                                    }
                                                                    do {
                                                                        int n59;
                                                                        cArray8 = cArray8;
                                                                        int n60 = n3;
                                                                        char c18 = cArray8[n60];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n59 = 92;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n59 = 36;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n59 = 31;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n59 = 40;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n59 = 12;
                                                                            }
                                                                        }
                                                                        cArray8[n60] = (char)(c18 ^ n59);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[16] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray42 = "?Kr\u0006e>I1K~%TkG\",Vp^e8Am\u0006E8Aq\\e(][Ix=F~[ip\u0004lGy.Gz\bj5Hz\u0012,".toCharArray();
                                                                cArray7 = cArray42;
                                                                n9 = cArray42.length;
                                                                n3 = 0;
                                                                if (!true) break block226;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block227;
                                                            }
                                                            do {
                                                                int n61;
                                                                cArray7 = cArray7;
                                                                int n62 = n3;
                                                                char c19 = cArray7[n62];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n61 = 92;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n61 = 36;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n61 = 31;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n61 = 40;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n61 = 12;
                                                                    }
                                                                }
                                                                cArray7[n62] = (char)(c19 ^ n61);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[17] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray43 = "0K~Le2C?[u/PzE,8EkIn=Wz\bj.Kr\bj5Hz\u0012,".toCharArray();
                                                        cArray6 = cArray43;
                                                        n8 = cArray43.length;
                                                        n3 = 0;
                                                        if (!true) break block228;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block229;
                                                    }
                                                    do {
                                                        int n63;
                                                        cArray6 = cArray6;
                                                        int n64 = n3;
                                                        char c20 = cArray6[n64];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n63 = 92;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n63 = 36;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n63 = 31;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n63 = 40;
                                                                break;
                                                            }
                                                            default: {
                                                                n63 = 12;
                                                            }
                                                        }
                                                        cArray6[n64] = (char)(c20 ^ n63);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[18] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray44 = "\u0019VmG~|MqAx5EsAv5Jx\be8Aq\\e(]?Lm(E}I\u007f9\u001e?".toCharArray();
                                                cArray5 = cArray44;
                                                n7 = cArray44.length;
                                                n3 = 0;
                                                if (!true) break block230;
                                                n7 = n7;
                                                if (n7 <= n3) break block231;
                                            }
                                            do {
                                                int n65;
                                                cArray5 = cArray5;
                                                int n66 = n3;
                                                char c21 = cArray5[n66];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n65 = 92;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n65 = 36;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n65 = 31;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n65 = 40;
                                                        break;
                                                    }
                                                    default: {
                                                        n65 = 12;
                                                    }
                                                }
                                                cArray5[n66] = (char)(c21 ^ n65);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[19] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray45 = "\u000f]l\\i1\u0004{Ix=F~[i|MqAx5EsAv9@%\b".toCharArray();
                                        cArray4 = cArray45;
                                        n6 = cArray45.length;
                                        n3 = 0;
                                        if (!true) break block232;
                                        n6 = n6;
                                        if (n6 <= n3) break block233;
                                    }
                                    do {
                                        int n67;
                                        cArray4 = cArray4;
                                        int n68 = n3;
                                        char c22 = cArray4[n68];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n67 = 92;
                                                break;
                                            }
                                            case 1: {
                                                n67 = 36;
                                                break;
                                            }
                                            case 2: {
                                                n67 = 31;
                                                break;
                                            }
                                            case 3: {
                                                n67 = 40;
                                                break;
                                            }
                                            default: {
                                                n67 = 12;
                                            }
                                        }
                                        cArray4[n68] = (char)(c22 ^ n67);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[20] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray46 = "\u0019VmG~|PmQe2C?\\c|Mq[x=JkAm(A?I,/]l\\i1\u0004vLi2Pv\\e9W?Ln|Mq\b".toCharArray();
                                cArray3 = cArray46;
                                n5 = cArray46.length;
                                n3 = 0;
                                if (!true) break block234;
                                n5 = n5;
                                if (n5 <= n3) break block235;
                            }
                            do {
                                int n69;
                                cArray3 = cArray3;
                                int n70 = n3;
                                char c23 = cArray3[n70];
                                switch (n3 % 5) {
                                    case 0: {
                                        n69 = 92;
                                        break;
                                    }
                                    case 1: {
                                        n69 = 36;
                                        break;
                                    }
                                    case 2: {
                                        n69 = 31;
                                        break;
                                    }
                                    case 3: {
                                        n69 = 40;
                                        break;
                                    }
                                    default: {
                                        n69 = 12;
                                    }
                                }
                                cArray3[n70] = (char)(c23 ^ n69);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[21] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray47 = "(Lv[,8EkIn=Wz\bd=W?Fc|Wp]~?A?Ne0A".toCharArray();
                        cArray2 = cArray47;
                        n4 = cArray47.length;
                        n3 = 0;
                        if (!true) break block236;
                        n4 = n4;
                        if (n4 <= n3) break block237;
                    }
                    do {
                        int n71;
                        cArray2 = cArray2;
                        int n72 = n3;
                        char c24 = cArray2[n72];
                        switch (n3 % 5) {
                            case 0: {
                                n71 = 92;
                                break;
                            }
                            case 1: {
                                n71 = 36;
                                break;
                            }
                            case 2: {
                                n71 = 31;
                                break;
                            }
                            case 3: {
                                n71 = 40;
                                break;
                            }
                            default: {
                                n71 = 12;
                            }
                        }
                        cArray2[n72] = (char)(c24 ^ n71);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[22] = new String(cArray2).intern();
                var0 = null;
                char[] cArray48 = ".Al\\c.MqO\"r\n".toCharArray();
                cArray = cArray48;
                n2 = cArray48.length;
                n3 = 0;
                if (!true) break block238;
                n2 = n2;
                if (n2 <= n3) break block239;
            }
            do {
                int n73;
                cArray = cArray;
                int n74 = n3;
                char c25 = cArray[n74];
                switch (n3 % 5) {
                    case 0: {
                        n73 = 92;
                        break;
                    }
                    case 1: {
                        n73 = 36;
                        break;
                    }
                    case 2: {
                        n73 = 31;
                        break;
                    }
                    case 3: {
                        n73 = 40;
                        break;
                    }
                    default: {
                        n73 = 12;
                    }
                }
                cArray[n74] = (char)(c25 ^ n73);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[23] = new String(cArray).intern();
        z = stringArray;
        AccessController.doPrivileged(new k());
    }
}

