/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.LaunchDownload;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.jnlp.JNLPClassLoader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private DownloadServiceListener _defaultProgress = null;

    private DownloadServiceImpl() {
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    public DownloadServiceListener getDefaultProgressWindow() {
        if (this._defaultProgress == null) {
            this._defaultProgress = (DownloadServiceListener)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new DefaultProgressImpl(new DownloadWindow(JNLPClassLoader.getInstance().getLaunchDesc(), false));
                }
            });
        }
        return this._defaultProgress;
    }

    public boolean isResourceCached(final URL uRL, final String string) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadProtocol.isInCache(uRL, string, 0) || DownloadProtocol.isInCache(uRL, string, 1)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public boolean isPartCached(String string) {
        return this.isPartCached(new String[]{string});
    }

    public boolean isPartCached(final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        return this.isExtensionPartCached(uRL, string, new String[]{string2});
    }

    public boolean isExtensionPartCached(final URL uRL, final String string, final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public void loadResource(final URL uRL, final String string, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isResourceCached(uRL, string)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        JNLPClassLoader.getInstance().downloadResource(uRL, string, new ProgressHelper(downloadServiceListener), true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadPart(new String[]{string}, downloadServiceListener);
    }

    public void loadPart(final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isPartCached(stringArray)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        JNLPClassLoader.getInstance().downloadParts(stringArray, new ProgressHelper(downloadServiceListener), true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadExtensionPart(uRL, string, new String[]{string2}, downloadServiceListener);
    }

    public void loadExtensionPart(final URL uRL, final String string, final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        JNLPClassLoader.getInstance().downloadExtensionParts(uRL, string, stringArray, new ProgressHelper(downloadServiceListener), true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeResource(final URL uRL, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removePart(String string) throws IOException {
        this.removePart(new String[]{string});
    }

    public void removePart(final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        this.removeExtensionPart(uRL, string, new String[]{string2});
    }

    public void removeExtensionPart(final URL uRL, final String string, final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void removeJARFromCache(JARDesc[] jARDescArray) throws IOException {
        if (jARDescArray == null) {
            return;
        }
        if (jARDescArray.length == 0) {
            return;
        }
        DiskCacheEntry diskCacheEntry = null;
        for (int i = 0; i < jARDescArray.length; ++i) {
            int n = jARDescArray[i].isNativeLib() ? 1 : 0;
            try {
                diskCacheEntry = DownloadProtocol.getResource(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n, true, null);
            }
            catch (JNLPException jNLPException) {
                throw new IOException(jNLPException.getMessage());
            }
            if (diskCacheEntry == null) continue;
            Cache.removeEntry(diskCacheEntry);
        }
    }

    private boolean isJARInCache(JARDesc[] jARDescArray, boolean bl) {
        if (jARDescArray == null) {
            return false;
        }
        if (jARDescArray.length == 0) {
            return false;
        }
        boolean bl2 = true;
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (jARDescArray[i].isNativeLib()) {
                if (DownloadProtocol.isInCache(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), 1)) {
                    if (bl) continue;
                    return true;
                }
                bl2 = false;
                continue;
            }
            if (DownloadProtocol.isInCache(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), 0)) {
                if (bl) continue;
                return true;
            }
            bl2 = false;
        }
        return bl2;
    }

    private class ProgressHelper
    implements LaunchDownload.DownloadProgress {
        DownloadServiceListener _dsp = null;

        public ProgressHelper(DownloadServiceListener downloadServiceListener) {
            this._dsp = downloadServiceListener;
            this._dsp.progress(null, null, 0L, 0L, -1);
        }

        public void extensionDownload(String string, int n) {
        }

        public void jreDownload(String string, URL uRL) {
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            if (this._dsp != null) {
                this._dsp.progress(uRL, string, l, l2, n);
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            if (this._dsp != null) {
                this._dsp.validating(uRL, string, l, l2, n);
            }
        }

        public void patching(URL uRL, String string, int n, int n2) {
            if (this._dsp != null) {
                this._dsp.upgradingArchive(uRL, string, n, n2);
            }
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._dsp != null) {
                this._dsp.downloadFailed(uRL, string);
            }
        }
    }

    private class DefaultProgressImpl
    implements DownloadServiceListener {
        private DownloadWindow _dw = null;

        DefaultProgressImpl(final DownloadWindow downloadWindow) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DefaultProgressImpl.this._dw = downloadWindow;
                    DefaultProgressImpl.this._dw.buildIntroScreen();
                    DefaultProgressImpl.this._dw.showLoadingProgressScreen();
                    return null;
                }
            });
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            if (l == 0L) {
                this._dw.resetDownloadTimer();
            }
            this._dw.progress(uRL, string, l, l2, n);
            if (n >= 100) {
                this.hideFrame();
            }
            if (this._dw.isCanceled()) {
                this.hideFrame();
                throw new RuntimeException("canceled by user");
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            this._dw.validating(uRL, string, l, l2, n);
            if (l >= l2 && (n < 0 || n >= 99)) {
                this.hideFrame();
            }
        }

        public void upgradingArchive(URL uRL, String string, int n, int n2) {
            this.ensureVisible();
            this._dw.patching(uRL, string, n, n2);
            if (n2 >= 100) {
                this.hideFrame();
            }
        }

        public void downloadFailed(URL uRL, String string) {
            this.hideFrame();
        }

        private void ensureVisible() {
            if (!this._dw.getFrame().isVisible()) {
                this._dw.getFrame().setVisible(true);
                this._dw.getFrame().toFront();
            }
        }

        private synchronized void hideFrame() {
            this._dw.resetCancled();
            this._dw.getFrame().hide();
        }
    }
}

