/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.CacheImageLoader;
import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

class CacheObject {
    private static final DateFormat _df = DateFormat.getDateInstance();
    private static final String[] COLUMN_KEYS = new String[]{"jnlp.viewer.app.column", "jnlp.viewer.vendor.column", "jnlp.viewer.type.column", "jnlp.viewer.date.column", "jnlp.viewer.size.column", "jnlp.viewer.status.column"};
    private static final int _columns = COLUMN_KEYS.length;
    private static TLabel _title;
    private static TLabel _vendor;
    private static TLabel _type;
    private static TLabel _date;
    private static TLabel _size;
    private static TLabel _status;
    private static ImageIcon _onlineIcon;
    private static ImageIcon _offlineIcon;
    private static ImageIcon _noLaunchIcon;
    private static ImageIcon _java32;
    private final DiskCacheEntry _dce;
    private final AbstractTableModel _model;
    private final int ICON_W = 32;
    private final int ICON_H = 32;
    private String _titleString = null;
    private ImageIcon _icon = null;
    private String _vendorString = null;
    private String _typeString = null;
    private Date _theDate = null;
    private String _dateString = null;
    private long _theSize = 0L;
    private String _sizeString = null;
    private int _statusInt = -1;
    private ImageIcon _statusIcon = null;
    private String _statusText = "";
    private static final float[] dash;
    private static final BasicStroke _dashed;
    LaunchDesc _ld = null;
    LocalApplicationProperties _lap = null;

    public CacheObject(DiskCacheEntry diskCacheEntry, AbstractTableModel abstractTableModel) {
        this._dce = diskCacheEntry;
        this._model = abstractTableModel;
        if (_title == null) {
            _title = new TLabel(2);
            _vendor = new TLabel(2);
            _type = new TLabel(0);
            _date = new TLabel(4);
            _size = new TLabel(4);
            _status = new TLabel(0);
            _java32 = new ViewerIcon(0, 0, ResourceManager.class.getResource("image/java32.png"));
            _onlineIcon = new ViewerIcon(0, 0, ResourceManager.class.getResource("image/online.gif"));
            _offlineIcon = new ViewerIcon(0, 0, ResourceManager.class.getResource("image/offline.gif"));
            _noLaunchIcon = null;
        }
    }

    public static String getColumnName(int n) {
        return ResourceManager.getMessage((String)COLUMN_KEYS[n]);
    }

    public static int getColumnCount() {
        return _columns;
    }

    public static String getHeaderToolTipText(int n) {
        return ResourceManager.getString((String)(COLUMN_KEYS[n] + ".tooltip"));
    }

    public static int getPreferredWidth(int n) {
        if (n < _columns) {
            switch (n) {
                case 0: {
                    return 192;
                }
                case 1: {
                    return 140;
                }
                case 2: {
                    return 70;
                }
                case 3: {
                    return 70;
                }
                case 4: {
                    return 64;
                }
                case 5: {
                    return 64;
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException("column index: " + n);
    }

    public static Class getClass(int n) {
        if (n < _columns) {
            switch (n) {
                case 0: {
                    return JLabel.class;
                }
                case 1: {
                    return JLabel.class;
                }
                case 2: {
                    return JLabel.class;
                }
                case 3: {
                    return JLabel.class;
                }
                case 4: {
                    return JLabel.class;
                }
                case 5: {
                    return JLabel.class;
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException("column index: " + n);
    }

    public Object getObject(int n) {
        if (n < _columns) {
            switch (n) {
                case 0: {
                    return this.getTitleLabel();
                }
                case 1: {
                    return this.getVendorLabel();
                }
                case 2: {
                    return this.getTypeLabel();
                }
                case 3: {
                    return this.getDateLabel();
                }
                case 4: {
                    return this.getSizeLabel();
                }
                case 5: {
                    return this.getStatusLabel();
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException("column index: " + n);
    }

    public boolean isEditable(int n) {
        return false;
    }

    public void setValue(int n, Object object) {
    }

    public String getTitleString() {
        if (this._titleString == null) {
            this._titleString = this.getTitle();
        }
        return this._titleString;
    }

    private JLabel getTitleLabel() {
        if (this._icon == null) {
            File file = this.getIconFile();
            if (file != null) {
                this._icon = new ViewerIcon(32, 32, file.getPath());
            }
            if (this._icon == null) {
                this._icon = _java32;
            }
        }
        if (this._icon != null && this._icon.getIconWidth() > 0 && this._icon.getIconHeight() > 0) {
            _title.setIcon(this._icon);
        }
        _title.setText(this.getTitleString());
        return _title;
    }

    public String getVendorString() {
        if (this._vendorString == null) {
            this._vendorString = this.getVendor();
        }
        return this._vendorString;
    }

    private TLabel getVendorLabel() {
        _vendor.setText(this.getVendorString());
        return _vendor;
    }

    public String getTypeString() {
        if (this._typeString == null) {
            this._typeString = CacheObject.getLaunchTypeString(this.getLaunchDesc().getLaunchType());
        }
        return this._typeString;
    }

    public static String getLaunchTypeString(int n) {
        switch (n) {
            case 1: {
                return ResourceManager.getMessage((String)"jnlp.viewer.application");
            }
            case 2: {
                return ResourceManager.getMessage((String)"jnlp.viewer.applet");
            }
            case 3: {
                return ResourceManager.getMessage((String)"jnlp.viewer.extension");
            }
            case 4: {
                return ResourceManager.getMessage((String)"jnlp.viewer.installer");
            }
        }
        return "";
    }

    private TLabel getTypeLabel() {
        _type.setText(this.getTypeString());
        return _type;
    }

    public Date getDate() {
        if (this._dateString == null) {
            this._theDate = this.getLastAccesed();
            this._dateString = this._theDate != null ? _df.format(this._theDate) : "";
        }
        return this._theDate;
    }

    private TLabel getDateLabel() {
        this.getDate();
        _date.setText(this._dateString);
        return _date;
    }

    public long getSize() {
        if (this._sizeString == null) {
            this._theSize = this.getResourceSize();
            this._sizeString = this._theSize > 10240L ? " " + this._theSize / 1024L + " KB" : " " + this._theSize / 1024L + "." + this._theSize % 1024L / 102L + " KB";
        }
        return this._theSize;
    }

    private TLabel getSizeLabel() {
        this.getSize();
        _size.setText(this._sizeString);
        return _size;
    }

    public int getStatus() {
        if (this._statusInt < 0) {
            this._statusInt = this.canLaunchOffline() ? 2 : (this.hasHref() ? 1 : 0);
            switch (this._statusInt) {
                case 0: {
                    this._statusIcon = _noLaunchIcon;
                    if (this.getLaunchDesc().isApplicationDescriptor()) {
                        this._statusText = ResourceManager.getString((String)"jnlp.viewer.norun1.tooltip", (String)this.getTypeString());
                        break;
                    }
                    this._statusText = ResourceManager.getString((String)"jnlp.viewer.norun2.tooltip");
                    break;
                }
                case 1: {
                    this._statusIcon = _onlineIcon;
                    this._statusText = ResourceManager.getString((String)"jnlp.viewer.online.tooltip", (String)this.getTypeString());
                    break;
                }
                case 2: {
                    this._statusIcon = _offlineIcon;
                    this._statusText = ResourceManager.getString((String)"jnlp.viewer.offline.tooltip", (String)this.getTypeString());
                }
            }
        }
        return this._statusInt;
    }

    private TLabel getStatusLabel() {
        this.getStatus();
        if (this._statusIcon == null || this._statusIcon.getIconWidth() > 0 && this._statusIcon.getIconHeight() > 0) {
            _status.setIcon(this._statusIcon);
            _status.setToolTipText(this._statusText);
        }
        return _status;
    }

    public static void hasFocus(Component component, boolean bl) {
        if (component instanceof TLabel) {
            ((TLabel)component).hasFocus(bl);
        }
    }

    public int compareColumns(CacheObject cacheObject, int n) {
        switch (n) {
            case 0: {
                return this.compareStrings(this.getTitleString(), cacheObject.getTitleString());
            }
            case 1: {
                return this.compareStrings(this.getVendorString(), cacheObject.getVendorString());
            }
            case 2: {
                return this.compareStrings(this.getTypeString(), cacheObject.getTypeString());
            }
            case 3: {
                return this.compareDates(this.getDate(), cacheObject.getDate());
            }
            case 4: {
                return this.compareLong(this.getSize(), cacheObject.getSize());
            }
        }
        return this.compareInt(this.getStatus(), cacheObject.getStatus());
    }

    private int compareStrings(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    private int compareDates(Date date, Date date2) {
        if (date == date2) {
            return 0;
        }
        if (date == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        return this.compareLong(date.getTime(), date2.getTime());
    }

    private int compareLong(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        return l < l2 ? -1 : 1;
    }

    private int compareInt(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    public DiskCacheEntry getDCE() {
        return this._dce;
    }

    public LaunchDesc getLaunchDesc() {
        if (this._ld == null) {
            try {
                this._ld = LaunchDescFactory.buildDescriptor(this._dce.getFile());
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
        return this._ld;
    }

    public LocalApplicationProperties getLocalApplicationProperties() {
        if (this._lap == null) {
            this._lap = Cache.getLocalApplicationProperties(this._dce, this.getLaunchDesc());
        }
        return this._lap;
    }

    public File getJnlpFile() {
        return this._dce.getFile();
    }

    public String getTitle() {
        try {
            return this.getLaunchDesc().getInformation().getTitle();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getVendor() {
        try {
            return this.getLaunchDesc().getInformation().getVendor();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getHref() {
        URL uRL = this.getLaunchDesc().getLocation();
        if (uRL != null) {
            return uRL.toString();
        }
        return null;
    }

    public File getIconFile() {
        try {
            IconDesc iconDesc = this.getLaunchDesc().getInformation().getIconLocation(1, 0);
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(iconDesc.getLocation(), iconDesc.getVersion(), 2);
            if (diskCacheEntry != null) {
                return diskCacheEntry.getFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Date getLastAccesed() {
        return this.getLocalApplicationProperties().getLastAccessed();
    }

    public long getResourceSize() {
        return LaunchDownload.getCachedSize(this.getLaunchDesc());
    }

    public boolean inFilter(int n) {
        return n == 0 || n == this.getLaunchDesc().getLaunchType();
    }

    public boolean hasHref() {
        if (this.getLaunchDesc().isApplicationDescriptor()) {
            return this._ld.getLocation() != null;
        }
        return false;
    }

    public boolean canLaunchOffline() {
        if (this.getLaunchDesc().isApplicationDescriptor()) {
            return this._ld.getInformation().supportsOfflineOperation();
        }
        return false;
    }

    static {
        dash = new float[]{1.0f, 2.0f};
        _dashed = new BasicStroke(1.0f, 2, 0, 10.0f, dash, 0.0f);
    }

    private class ViewerIcon
    extends ImageIcon
    implements CacheImageLoaderCallback {
        private int _width;
        private int _height;

        public ViewerIcon(int n, int n2, String string) {
            this._width = n;
            this._height = n2;
            try {
                URL uRL = new File(string).toURL();
                if (uRL != null) {
                    CacheImageLoader.getInstance().loadImage(uRL, (CacheImageLoaderCallback)this);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }

        public ViewerIcon(int n, int n2, URL uRL) {
            this._width = n;
            this._height = n2;
            if (uRL != null) {
                CacheImageLoader.getInstance().loadImage(uRL, (CacheImageLoaderCallback)this);
            }
        }

        public void imageAvailable(IconDesc iconDesc, Image image, File file) {
            final int n = image.getWidth(null);
            final int n2 = image.getHeight(null);
            final Image image2 = image;
            new Thread(new Runnable(){

                public void run() {
                    Image image = image2;
                    if (ViewerIcon.this._width > 0 && ViewerIcon.this._height > 0 && (ViewerIcon.this._width != n || ViewerIcon.this._height != n2)) {
                        image = image2.getScaledInstance(ViewerIcon.this._width, ViewerIcon.this._height, 1);
                    }
                    ViewerIcon.this.setImage(image);
                    CacheObject.this._model.fireTableDataChanged();
                }
            }).start();
        }

        public void finalImageAvailable(IconDesc iconDesc, Image image, File file) {
        }
    }

    private class TLabel
    extends JLabel {
        boolean _focus = false;

        public TLabel(int n) {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.setHorizontalAlignment(n);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this._focus && graphics instanceof Graphics2D) {
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                ((Graphics2D)graphics).setStroke(_dashed);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                ((Graphics2D)graphics).setStroke(stroke);
            }
        }

        public void hasFocus(boolean bl) {
            this._focus = bl;
        }
    }
}

