/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.cookie.DeployCookieSelector;
import com.sun.deploy.net.proxy.DeployProxySelector;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.net.proxy.StaticProxyManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.ConsoleController;
import com.sun.deploy.util.ConsoleHelper;
import com.sun.deploy.util.ConsoleTraceListener;
import com.sun.deploy.util.ConsoleWindow;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.FileTraceListener;
import com.sun.deploy.util.LoggerTraceListener;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.SocketTraceListener;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.TraceListener;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JPDA;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.Launcher;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.OperaSupport;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.CouldNotLoadArgumentException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.TooManyArgumentsException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.ui.CacheViewer;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.JavawsDialogListener;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JnlpLookupStub;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.jnlp.ServiceManager;
import javax.net.ssl.SSLException;

public class Main {
    private static boolean _isViewer = false;
    private static boolean _launchingAllowed = false;
    private static ThreadGroup _systemTG;
    private static ThreadGroup _securityTG;
    private static ThreadGroup _launchTG;
    private static String[] _tempfile;
    private static DataInputStream _tckStream;
    private static long t0;
    private static long t1;
    private static long t2;
    private static long t3;
    private static long t4;
    private static long t5;
    private static boolean _timeing;
    private static boolean uninstall;

    public static void main(String[] stringArray) {
        PerfLogger.setStartTime((String)"JavaWebStart main started");
        Thread.currentThread().setContextClassLoader(JNLPClassLoader.createClassLoader());
        if (_timeing) {
            t0 = new Date().getTime();
        }
        Toolkit.getDefaultToolkit();
        if (_timeing) {
            t1 = new Date().getTime();
        }
        _launchingAllowed = Config.isConfigValid();
        if (_timeing) {
            t2 = new Date().getTime();
        }
        JPDA.setup();
        stringArray = Globals.parseOptions(stringArray);
        if (_timeing) {
            t3 = new Date().getTime();
        }
        Main.initTrace();
        if (_timeing) {
            t4 = new Date().getTime();
        }
        Main.updateCache();
        stringArray = Main.parseArgs(stringArray);
        if (stringArray.length > 0) {
            Main._tempfile[0] = stringArray[0];
        }
        if (Cache.canWrite()) {
            Main.setupBrowser();
            JnlpxArgs.verify();
            Main.initializeExecutionEnvironment();
            if (uninstall) {
                Main.uninstallCache(stringArray.length > 0 ? stringArray[0] : null);
            }
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Java Started");
            }
            if (stringArray.length == 0) {
                _isViewer = true;
            }
            if (!_isViewer) {
                Main.launchApp(stringArray, true);
            }
            if (_isViewer) {
                JnlpxArgs.removeArgumentFile(stringArray);
                try {
                    if (_timeing) {
                        t5 = new Date().getTime();
                        Trace.println((String)("startup times: \n      toolkit: " + (t1 - t0) + "\n" + "       config: " + (t2 - t1) + "\n" + "         args: " + (t3 - t2) + "\n" + "        trace: " + (t4 - t3) + "\n" + "     the rest: " + (t5 - t4) + "\n" + ""), (TraceLevel)TraceLevel.BASIC);
                    }
                    Trace.println((String)"Launching Cache Viewer", (TraceLevel)TraceLevel.BASIC);
                    Trace.flush();
                    CacheViewer.main(stringArray);
                }
                catch (Exception exception) {
                    LaunchErrorDialog.show(null, exception, true);
                }
            }
        } else {
            LaunchErrorDialog.show(null, new CacheAccessException(Globals.isSystemCache()), true);
        }
        Trace.flush();
    }

    public static void launchApp(String[] stringArray, boolean bl) {
        if (stringArray.length > 1) {
            JnlpxArgs.removeArgumentFile(stringArray);
            LaunchErrorDialog.show(null, new TooManyArgumentsException(stringArray), bl);
            return;
        }
        LaunchDesc launchDesc = null;
        try {
            launchDesc = LaunchDescFactory.buildDescriptor(stringArray[0]);
        }
        catch (IOException iOException) {
            JNLPException jNLPException = null;
            JnlpxArgs.removeArgumentFile(stringArray);
            jNLPException = new CouldNotLoadArgumentException(stringArray[0], iOException);
            if (Globals.isJavaVersionAtLeast14() && (iOException instanceof SSLException || iOException.getMessage() != null && iOException.getMessage().toLowerCase().indexOf("https") != -1)) {
                try {
                    jNLPException = new FailedDownloadingResourceException(new URL(stringArray[0]), null, iOException);
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignoredException((Exception)malformedURLException);
                }
            }
            LaunchErrorDialog.show(null, jNLPException, bl);
            return;
        }
        catch (JNLPException jNLPException) {
            JnlpxArgs.removeArgumentFile(stringArray);
            LaunchErrorDialog.show(null, jNLPException, bl);
            return;
        }
        Globals.setCodebase(launchDesc.getCodebase());
        if (launchDesc.getLaunchType() == 5) {
            JnlpxArgs.removeArgumentFile(stringArray);
            String string = launchDesc.getInternalCommand();
            if (string.equals("viewer")) {
                _isViewer = true;
            } else if (string.equals("player")) {
                _isViewer = true;
            } else {
                Main.launchJavaControlPanel(string);
                Main.systemExit(0);
            }
        } else if (_launchingAllowed) {
            new Launcher(launchDesc).launch(stringArray, bl);
        } else {
            LaunchErrorDialog.show(null, new LaunchDescException(launchDesc, ResourceManager.getString((String)"enterprize.cfg.mandatory", (String)Config.getEnterprizeString()), null), bl);
        }
    }

    public static void importApp(String string) {
        String[] stringArray = new String[]{string};
        Globals.setImportMode(true);
        Globals.setSilentMode(true);
        Main.launchApp(stringArray, false);
        Launcher.checkCacheMax();
    }

    public static void launchJavaControlPanel(String string) {
        String[] stringArray = new String[7];
        String string2 = System.getProperty("javaplugin.user.profile");
        if (string2 == null) {
            string2 = "";
        }
        stringArray[0] = Config.getInstance().toExecArg(JREInfo.getDefaultJavaPath());
        stringArray[1] = "-cp";
        stringArray[2] = Config.getInstance().toExecArg(Config.getJavaHome() + File.separator + "lib" + File.separator + "deploy.jar");
        stringArray[3] = Config.getInstance().toExecArg("-Djavaplugin.user.profile=" + string2);
        stringArray[4] = "com.sun.deploy.panel.ControlPanel";
        stringArray[5] = "-tab";
        stringArray[6] = string == null ? "general" : string;
        Trace.println((String)("Launching Control Panel: " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3] + " " + stringArray[4] + " " + stringArray[5] + " "), (TraceLevel)TraceLevel.BASIC);
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
    }

    private static void uninstallCache(String string) {
        int n = -1;
        try {
            n = Main.uninstall(string);
        }
        catch (Exception exception) {
            LaunchErrorDialog.show(null, exception, !Globals.isSilentMode());
        }
        Main.systemExit(n);
    }

    private static String[] parseArgs(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-")) {
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-Xclearcache")) {
                try {
                    Cache.remove();
                    long l = Cache.getCacheSize();
                    if (l > 0L) {
                        System.err.println("Could not clean all entries  in cache since they are in use");
                        if (Globals.TCKHarnessRun) {
                            Main.tckprintln("Cache Clear Failed");
                        }
                        Main.systemExit(-1);
                    }
                }
                catch (IOException iOException) {
                    Trace.println((String)("Clear cached failed: " + iOException.getMessage()));
                    if (Globals.TCKHarnessRun) {
                        Main.tckprintln("Cache Clear Failed");
                    }
                    Main.systemExit(-1);
                }
                if (!Globals.TCKHarnessRun) continue;
                Main.tckprintln("Cache Clear Success");
                continue;
            }
            if (stringArray[i].equals("-offline")) {
                JnlpxArgs.SetIsOffline();
                Globals.setOffline(true);
                continue;
            }
            if (stringArray[i].equals("-online") || stringArray[i].equals("-Xnosplash")) continue;
            if (stringArray[i].equals("-installer")) {
                Globals.setInstallMode(true);
                continue;
            }
            if (stringArray[i].equals("-uninstall")) {
                uninstall = true;
                Globals.setInstallMode(true);
                continue;
            }
            if (stringArray[i].equals("-updateVersions")) {
                Main.systemExit(0);
                continue;
            }
            if (stringArray[i].equals("-import")) {
                Globals.setImportMode(true);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-silent")) {
                Globals.setSilentMode(true);
                continue;
            }
            if (stringArray[i].equals("-shortcut")) {
                Globals.setCreateShortcut(true);
                continue;
            }
            if (stringArray[i].equals("-association")) {
                Globals.setCreateAssoc(true);
                continue;
            }
            if (stringArray[i].equals("-codebase")) {
                if (i + 1 < stringArray.length) {
                    String string = stringArray[++i];
                    try {
                        new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        LaunchErrorDialog.show(null, malformedURLException, true);
                    }
                    Globals.setCodebaseOverride(string);
                }
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-system")) {
                Globals.setSystemCache(true);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-secure")) {
                Globals.setSecureMode(true);
                continue;
            }
            if (stringArray[i].equals("-open") || stringArray[i].equals("-print")) {
                if (i + 1 < stringArray.length) {
                    String[] stringArray2 = new String[]{stringArray[i++], stringArray[i]};
                    Globals.setApplicationArgs(stringArray2);
                }
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-viewer")) {
                _isViewer = true;
                continue;
            }
            Trace.println((String)("unsupported option: " + stringArray[i]), (TraceLevel)TraceLevel.BASIC);
        }
        String[] stringArray3 = new String[arrayList.size()];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = (String)arrayList.get(i);
        }
        return stringArray3;
    }

    private static void initTrace() {
        Object object;
        FileTraceListener fileTraceListener;
        Object object2;
        Trace.redirectStdioStderr();
        Trace.resetTraceLevel();
        Trace.setInitialTraceLevel();
        if (Globals.TraceBasic) {
            Trace.setBasicTrace((boolean)true);
        }
        if (Globals.TraceNetwork) {
            Trace.setNetTrace((boolean)true);
        }
        if (Globals.TraceCache) {
            Trace.setCacheTrace((boolean)true);
        }
        if (Globals.TraceSecurity) {
            Trace.setSecurityTrace((boolean)true);
        }
        if (Globals.TraceExtensions) {
            Trace.setExtTrace((boolean)true);
        }
        if (Globals.TraceTemp) {
            Trace.setTempTrace((boolean)true);
        }
        if (Config.getProperty((String)"deployment.console.startup.mode").equals("SHOW") && !Globals.isHeadless()) {
            object2 = JavawsConsoleController.getInstance();
            fileTraceListener = new ConsoleTraceListener((ConsoleController)object2);
            object = ConsoleWindow.create((ConsoleController)object2);
            ((JavawsConsoleController)object2).setConsole((ConsoleWindow)object);
            if (fileTraceListener != null) {
                fileTraceListener.setConsole((ConsoleWindow)object);
                Trace.addTraceListener((TraceListener)fileTraceListener);
                fileTraceListener.print(ConsoleHelper.displayVersion() + "\n");
                fileTraceListener.print(ConsoleHelper.displayHelp());
            }
        }
        if ((object2 = Main.initSocketTrace()) != null) {
            Trace.addTraceListener((TraceListener)object2);
        }
        if ((fileTraceListener = Main.initFileTrace()) != null) {
            Trace.addTraceListener((TraceListener)fileTraceListener);
        }
        if (Globals.isJavaVersionAtLeast14() && Config.getBooleanProperty((String)"deployment.log")) {
            object = null;
            try {
                Object object3;
                object = Config.getProperty((String)"deployment.javaws.logFileName");
                File file = new File(Config.getLogDirectory());
                if (object != null && object != "") {
                    if (((String)object).compareToIgnoreCase("TEMP") != 0) {
                        object3 = new File((String)object);
                        if (((File)object3).isDirectory()) {
                            object = "";
                        } else {
                            file = ((File)object3).getParentFile();
                            if (file != null) {
                                file.mkdirs();
                            }
                        }
                    } else {
                        object = "";
                    }
                }
                if (object == "") {
                    file.mkdirs();
                    object = Config.getLogDirectory() + File.separator + "javaws.log";
                }
                if ((object3 = new LoggerTraceListener("com.sun.deploy", (String)object)) != null) {
                    object3.getLogger().setLevel(Level.ALL);
                    JavawsConsoleController.getInstance().setLogger(object3.getLogger());
                    Trace.addTraceListener((TraceListener)object3);
                }
            }
            catch (Exception exception) {
                Trace.println((String)("can not create log file in directory: " + Config.getLogDirectory()), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    private static FileTraceListener initFileTrace() {
        if (Config.getBooleanProperty((String)"deployment.trace")) {
            File file = null;
            String string = Config.getProperty((String)"deployment.user.logdir");
            String string2 = Config.getProperty((String)"deployment.javaws.traceFileName");
            try {
                if (string2 != null && string2 != "" && string2.compareToIgnoreCase("TEMP") != 0) {
                    file = new File(string2);
                    if (!file.isDirectory()) {
                        int n = string2.lastIndexOf(File.separator);
                        if (n != -1) {
                            string = string2.substring(0, n);
                        }
                    } else {
                        file = null;
                    }
                }
                File file2 = new File(string);
                file2.mkdirs();
                if (file == null) {
                    file = File.createTempFile("javaws", ".trace", file2);
                }
                return new FileTraceListener(file, true);
            }
            catch (Exception exception) {
                Trace.println((String)("cannot create trace file in Directory: " + string), (TraceLevel)TraceLevel.BASIC);
            }
        }
        return null;
    }

    private static SocketTraceListener initSocketTrace() {
        if (Globals.LogToHost != null) {
            String string;
            String string2 = Globals.LogToHost;
            String string3 = null;
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            if (string2.charAt(0) == '[' && (n3 = string2.indexOf(1, 93)) != -1) {
                n2 = 1;
            } else {
                n3 = string2.indexOf(":");
            }
            string3 = string2.substring(n2, n3);
            if (string3 == null) {
                return null;
            }
            try {
                string = string2.substring(string2.lastIndexOf(58) + 1);
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0) {
                return null;
            }
            string = new SocketTraceListener(string3, n);
            if (string != null) {
                Socket socket = string.getSocket();
                if (Globals.TCKResponse && socket != null) {
                    try {
                        _tckStream = new DataInputStream(socket.getInputStream());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                }
            }
            return string;
        }
        return null;
    }

    private static int uninstall(String string) {
        if (string == null) {
            Trace.println((String)"Uninstall all!", (TraceLevel)TraceLevel.BASIC);
            Main.uninstallAll();
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Cache Clear Success");
            }
        } else {
            Trace.println((String)("Uninstall: " + string), (TraceLevel)TraceLevel.BASIC);
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(string);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
            if (launchDesc != null) {
                LocalApplicationProperties localApplicationProperties = null;
                localApplicationProperties = launchDesc.isInstaller() || launchDesc.isLibrary() ? Cache.getLocalApplicationProperties(string, launchDesc) : Cache.getLocalApplicationProperties(launchDesc.getCanonicalHome(), launchDesc);
                if (localApplicationProperties != null) {
                    Cache.remove(string, localApplicationProperties, launchDesc);
                    Cache.clean();
                    if (Globals.TCKHarnessRun) {
                        Main.tckprintln("Cache Clear Success");
                    }
                    return 0;
                }
            }
            Trace.println((String)"Error uninstalling!", (TraceLevel)TraceLevel.BASIC);
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Cache Clear Failed");
            }
            if (!Globals.isSilentMode()) {
                SplashScreen.hide();
                DialogFactory.showErrorDialog(null, (String)ResourceManager.getMessage((String)"uninstall.failedMessage"), (String)ResourceManager.getMessage((String)"uninstall.failedMessageTitle"));
            }
        }
        return 0;
    }

    private static void uninstallAll() {
        Cache.remove();
    }

    private static void setupBrowser() {
        if (Config.getBooleanProperty((String)"deployment.capture.mime.types")) {
            Main.setupNS6();
            Main.setupOpera();
            Config.setBooleanProperty((String)"deployment.capture.mime.types", (boolean)false);
        }
    }

    private static void setupOpera() {
        OperaSupport operaSupport = BrowserSupport.getInstance().getOperaSupport();
        if (operaSupport != null && operaSupport.isInstalled()) {
            operaSupport.enableJnlp(new File(JREInfo.getDefaultJavaPath()), Config.getBooleanProperty((String)"deployment.update.mime.types"));
        }
    }

    private static void setupNS6() {
        String string = null;
        string = BrowserSupport.getInstance().getNS6MailCapInfo();
        String string2 = "user_pref(\"browser.helperApps.neverAsk.openFile\", \"application%2Fx-java-jnlp-file\");\n";
        String string3 = System.getProperty("user.home");
        File file = new File(string3 + "/.mozilla/appreg");
        File file2 = null;
        try {
            file2 = NSPreferences.getNS6PrefsFile((File)file);
        }
        catch (IOException iOException) {
            Trace.println((String)"cannot determine NS6 prefs.js location", (TraceLevel)TraceLevel.BASIC);
        }
        if (file2 == null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            String string4 = null;
            fileInputStream = new FileInputStream(file2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string5 = "";
            boolean bl = true;
            boolean bl2 = string != null;
            block10: while (true) {
                try {
                    while (true) {
                        if ((string4 = bufferedReader.readLine()) == null) {
                            ((InputStream)fileInputStream).close();
                            break block10;
                        }
                        string5 = string5 + string4 + "\n";
                        if (string4.indexOf("x-java-jnlp-file") != -1) {
                            bl = false;
                        }
                        if (string == null || string4.indexOf(".mime.types") == -1) continue;
                        bl2 = false;
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                    continue;
                }
                break;
            }
            if (!bl && !bl2) {
                return;
            }
            if (bl) {
                string5 = string5 + string2;
            }
            if (string != null && bl2) {
                string5 = string5 + string;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                fileOutputStream.write(string5.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignoredException((Exception)fileNotFoundException);
            String string6 = "";
            if (string != null) {
                string6 = string6 + string;
            }
            string6 = string6 + string2;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(string6.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static void updateCache() {
        if (Config.getProperty((String)"deployment.javaws.cachedir") != null) {
            Cache.updateCache();
            Config.setProperty((String)"deployment.javaws.cachedir", null);
            Config.storeIfDirty();
        }
    }

    private static void initializeExecutionEnvironment() {
        Object object;
        boolean bl = Config.getOSName().indexOf("Windows") != -1;
        boolean bl2 = Globals.isJavaVersionAtLeast15();
        if (bl) {
            if (bl2) {
                com.sun.deploy.services.ServiceManager.setService((int)33024);
            } else {
                com.sun.deploy.services.ServiceManager.setService((int)16640);
            }
        } else if (bl2) {
            com.sun.deploy.services.ServiceManager.setService((int)36864);
        } else {
            com.sun.deploy.services.ServiceManager.setService((int)20480);
        }
        Properties properties = System.getProperties();
        properties.put("http.auth.serializeRequests", "true");
        if (Globals.isJavaVersionAtLeast14()) {
            object = (String)properties.get("java.protocol.handler.pkgs");
            if (object != null) {
                properties.put("java.protocol.handler.pkgs", object + "|com.sun.deploy.net.protocol");
            } else {
                properties.put("java.protocol.handler.pkgs", "com.sun.deploy.net.protocol");
            }
        }
        properties.setProperty("javawebstart.version", Globals.getComponentName());
        try {
            DeployProxySelector.reset();
            DeployCookieSelector.reset();
        }
        catch (Throwable throwable) {
            StaticProxyManager.reset();
        }
        if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
            object = JAuthenticator.getInstance(null);
            Authenticator.setDefault((Authenticator)object);
        }
        ServiceManager.setServiceManagerStub(new JnlpLookupStub());
        Main.addToSecurityProperty("package.access", "com.sun.javaws");
        Main.addToSecurityProperty("package.access", "com.sun.deploy");
        Main.addToSecurityProperty("package.definition", "com.sun.javaws");
        Main.addToSecurityProperty("package.definition", "com.sun.deploy");
        Main.addToSecurityProperty("package.definition", "com.sun.jnlp");
        Main.addToSecurityProperty("package.access", "org.mozilla.jss");
        Main.addToSecurityProperty("package.definition", "org.mozilla.jss");
        DialogFactory.addDialogListener((DialogListener)new JavawsDialogListener());
        if (properties.get("https.protocols") == null && !Config.getBooleanProperty((String)"deployment.security.TLSv1")) {
            properties.put("https.protocols", "SSL_TLS");
        }
    }

    private static void addToSecurityProperty(String string, String string2) {
        String string3 = Security.getProperty(string);
        Trace.println((String)("property " + string + " value " + string3), (TraceLevel)TraceLevel.SECURITY);
        string3 = string3 != null ? string3 + "," + string2 : string2;
        Security.setProperty(string, string3);
        Trace.println((String)("property " + string + " new value " + string3), (TraceLevel)TraceLevel.SECURITY);
    }

    public static void systemExit(int n) {
        JnlpxArgs.removeArgumentFile(_tempfile);
        SplashScreen.hide();
        Trace.flush();
        System.exit(n);
    }

    static boolean isViewer() {
        return _isViewer;
    }

    public static final ThreadGroup getLaunchThreadGroup() {
        Main.initializeThreadGroups();
        return _launchTG;
    }

    public static final ThreadGroup getSecurityThreadGroup() {
        Main.initializeThreadGroups();
        return _securityTG;
    }

    private static void initializeThreadGroups() {
        if (_securityTG == null) {
            _systemTG = Thread.currentThread().getThreadGroup();
            while (_systemTG.getParent() != null) {
                _systemTG = _systemTG.getParent();
            }
            _securityTG = new ThreadGroup(_systemTG, "javawsSecurityThreadGroup");
            new Thread(_securityTG, new Runnable(){

                public void run() {
                    AppContextUtil.createSecurityAppContext();
                }
            }).start();
            _launchTG = new ThreadGroup(_systemTG, "javawsApplicationThreadGroup");
        }
    }

    public static synchronized void tckprintln(String string) {
        long l = System.currentTimeMillis();
        Trace.println((String)("##TCKHarnesRun##:" + l + ":" + Runtime.getRuntime().hashCode() + ":" + Thread.currentThread() + ":" + string));
        if (_tckStream != null) {
            try {
                while (_tckStream.readLong() < l) {
                }
            }
            catch (IOException iOException) {
                System.err.println("Warning:Exceptions occurred, while logging to logSocket");
                iOException.printStackTrace(System.err);
            }
        }
    }

    static {
        _tempfile = new String[1];
        _tckStream = null;
        _timeing = true;
        uninstall = false;
    }
}

