/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;

public final class RSAPrivateKey
extends PrivateKeyInfo
implements PKCS11RSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    static final long serialVersionUID = 4424187430958879494L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] id = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private BigInteger privateExponent = null;
    private BigInteger prime1 = null;
    private BigInteger prime2 = null;
    private BigInteger exponent1 = null;
    private BigInteger exponent2 = null;
    private BigInteger coefficient = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey";

    public RSAPrivateKey(PKCS11Session pKCS11Session, PKCS11Object pKCS11Object, byte[] byArray, byte[] byArray2, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        if (debug != null) {
            Object[] objectArray = new Object[]{pKCS11Object, byArray, byArray2, string, bl, bl2, bl3, bl4, bl5, bl6, bigInteger, bigInteger2};
            debug.entry(16384L, (Object)className, "RSAPrivateKey", objectArray);
        }
        this.session = pKCS11Session;
        this.object = pKCS11Object;
        if (byArray != null) {
            this.id = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.id, 0, byArray.length);
        } else {
            this.id = (byte[])this.getValue(this.object, 258);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        } else {
            this.subject = (byte[])this.getValue(this.object, 257);
        }
        this.label = string != null ? new String(string) : (String)this.getValue(this.object, 3);
        this.isToken = (Boolean)this.getValue(this.object, 1);
        this.isSensitive = (Boolean)this.getValue(this.object, 259);
        this.isSign = (Boolean)this.getValue(this.object, 264);
        this.isDecrypt = (Boolean)this.getValue(this.object, 261);
        this.isUnwrap = (Boolean)this.getValue(this.object, 263);
        this.isExtractable = (Boolean)this.getValue(this.object, 354);
        if (bigInteger != null) {
            this.modulus = new BigInteger(bigInteger.toByteArray());
        }
        if (bigInteger2 != null) {
            this.publicExponent = new BigInteger(bigInteger2.toByteArray());
        }
        this.isPrivate = (Boolean)this.getValue(this.object, 2);
        this.isModifiable = (Boolean)this.getValue(this.object, 368);
        this.startDate = (Date)this.getValue(this.object, 272);
        this.endDate = (Date)this.getValue(this.object, 273);
        this.isDerive = (Boolean)this.getValue(this.object, 268);
        this.isLocal = (Boolean)this.getValue(this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getValue(this.object, 512);
        this.authPinFlags = (Integer)this.getValue(this.object, 513);
        this.isSignRecover = (Boolean)this.getValue(this.object, 265);
        this.isAlwaysSensitive = (Boolean)this.getValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getValue(this.object, 356);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPrivateKey");
        }
    }

    public RSAPrivateKey(PKCS11Session pKCS11Session, PKCS11Object pKCS11Object, byte[] byArray, byte[] byArray2, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this(pKCS11Session, pKCS11Object, byArray, byArray2, string, bl, bl2, bl3, bl4, bl5, bl6, bigInteger, bigInteger2);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{pKCS11Object, byArray, byArray2, string, bl, bl2, bl3, bl4, bl5, bl6, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8};
            debug.entry(16384L, (Object)className, "RSAPrivateKey", objectArray);
        }
        if (bigInteger3 != null) {
            this.privateExponent = new BigInteger(bigInteger3.toByteArray());
        }
        if (bigInteger4 != null) {
            this.prime1 = new BigInteger(bigInteger4.toByteArray());
        }
        if (bigInteger5 != null) {
            this.prime2 = new BigInteger(bigInteger5.toByteArray());
        }
        if (bigInteger6 != null) {
            this.exponent1 = new BigInteger(bigInteger6.toByteArray());
        }
        if (bigInteger7 != null) {
            this.exponent2 = new BigInteger(bigInteger7.toByteArray());
        }
        if (bigInteger8 != null) {
            this.coefficient = new BigInteger(bigInteger8.toByteArray());
        }
        this.algid = new AlgIdRSA();
        if (this.modulus != null && this.privateExponent != null && this.publicExponent != null && this.prime1 != null && this.prime2 != null && this.exponent1 != null && this.exponent2 != null && this.coefficient != null) {
            try {
                objectArray = new DerValue[9];
                objectArray[0] = new DerValue(2, version.toByteArray());
                objectArray[1] = new DerValue(2, this.modulus.toByteArray());
                objectArray[2] = new DerValue(2, this.publicExponent.toByteArray());
                objectArray[3] = new DerValue(2, this.privateExponent.toByteArray());
                objectArray[4] = new DerValue(2, this.prime1.toByteArray());
                objectArray[5] = new DerValue(2, this.prime2.toByteArray());
                objectArray[6] = new DerValue(2, this.exponent1.toByteArray());
                objectArray[7] = new DerValue(2, this.exponent2.toByteArray());
                objectArray[8] = new DerValue(2, this.coefficient.toByteArray());
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putSequence((DerValue[])objectArray);
                this.key = derOutputStream.toByteArray();
                this.encode();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("could not DER encode: " + iOException.getMessage());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "RSAPrivateKey");
            }
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.id.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getSecondaryAuth() {
        return new Boolean(this.isSecondaryAuth);
    }

    public Integer getAuthPinFlags() {
        return this.authPinFlags;
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getSignRecover() {
        return new Boolean(this.isSignRecover);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        if (this.isExtractable == null) {
            return null;
        }
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    public BigInteger getPrimeP() {
        return this.prime1;
    }

    public BigInteger getPrimeQ() {
        return this.prime2;
    }

    public BigInteger getPrimeExponentP() {
        return this.exponent1;
    }

    public BigInteger getPrimeExponentQ() {
        return this.exponent2;
    }

    public BigInteger getCrtCoefficient() {
        return this.coefficient;
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public String toString() {
        String string = "IBMPKCS11Impl";
        String string2 = string + " RSA Private Key: ";
        if (this.isToken != null) {
            string2 = string2 + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            string2 = string2 + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            string2 = string2 + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            string2 = string2 + "\n Modifiable: " + this.isModifiable;
        }
        string2 = string2 + "\n KeyType: " + this.keyType.toString();
        if (this.id != null) {
            string2 = string2 + "\n ID: " + new String(this.id);
        }
        if (this.startDate != null) {
            string2 = string2 + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            string2 = string2 + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            string2 = string2 + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            string2 = string2 + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            string2 = string2 + "\n Subject: " + new String(this.subject);
        }
        if (this.isSensitive != null) {
            string2 = string2 + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isSecondaryAuth != null) {
            string2 = string2 + "\n SecondaryAuth: " + this.isSecondaryAuth;
        }
        if (this.authPinFlags != null) {
            string2 = string2 + "\n AuthPinFlags: " + Integer.toBinaryString(this.authPinFlags);
        }
        if (this.isDecrypt != null) {
            string2 = string2 + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            string2 = string2 + "\n sign: " + this.isSign;
        }
        if (this.isSignRecover != null) {
            string2 = string2 + "\n SignRecover: " + this.isSignRecover;
        }
        if (this.isExtractable != null) {
            string2 = string2 + "\n isExtractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            string2 = string2 + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            string2 = string2 + "\n Never Extractable: " + this.isNeverExtractable;
        }
        if (this.modulus != null) {
            string2 = string2 + "\n Modulus: " + this.modulus.toString();
        }
        if (this.publicExponent != null) {
            string2 = string2 + "\n Public Exponent: " + this.publicExponent.toString();
        }
        if (this.privateExponent != null) {
            string2 = string2 + "\n Private Exponent: " + this.privateExponent.toString();
        }
        if (this.prime1 != null) {
            string2 = string2 + "\n Prime1: " + this.prime1.toString();
        }
        if (this.prime2 != null) {
            string2 = string2 + "\n Prime2: " + this.prime2.toString();
        }
        if (this.exponent1 != null) {
            string2 = string2 + "\n Exponent1: " + this.exponent1.toString();
        }
        if (this.exponent2 != null) {
            string2 = string2 + "\n Exponent2: " + this.exponent2.toString();
        }
        if (this.coefficient != null) {
            string2 = string2 + "\n Coefficient: " + this.coefficient.toString();
        }
        return string2;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "RSA";
    }
}

