/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class RSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 1024;
    private PKCS11Session session = null;
    private Config config = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private boolean paramsUsed = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator";

    public RSAPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
    }

    public RSAPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)algorithmParameterSpec, (Object)secureRandom);
        }
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11RSAKeyPairParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 RSA KeyPair Parameters must be specified");
        }
        PKCS11RSAKeyPairParameterSpec pKCS11RSAKeyPairParameterSpec = (PKCS11RSAKeyPairParameterSpec)algorithmParameterSpec;
        this.modlen = pKCS11RSAKeyPairParameterSpec.getStrength();
        if (pKCS11RSAKeyPairParameterSpec.getKeyID() != null) {
            try {
                this.id = pKCS11RSAKeyPairParameterSpec.getKeyID().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.id = pKCS11RSAKeyPairParameterSpec.getKeyID().getBytes();
            }
        }
        if (pKCS11RSAKeyPairParameterSpec.getSubject() != null) {
            try {
                this.subject = pKCS11RSAKeyPairParameterSpec.getSubject().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.subject = pKCS11RSAKeyPairParameterSpec.getSubject().getBytes();
            }
        }
        this.label = pKCS11RSAKeyPairParameterSpec.getLabel();
        this.isSensitive = pKCS11RSAKeyPairParameterSpec.getSensitive();
        this.isToken = pKCS11RSAKeyPairParameterSpec.getToken();
        this.sign = pKCS11RSAKeyPairParameterSpec.getSign();
        this.encrypt = pKCS11RSAKeyPairParameterSpec.getEncrypt();
        this.wrapping = pKCS11RSAKeyPairParameterSpec.getWrap();
        this.extractable = pKCS11RSAKeyPairParameterSpec.getExtractable();
        this.paramsUsed = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + n), (Object)secureRandom);
        }
        if (n < 512) {
            throw new InvalidParameterException("Key size must be at least 512 bit");
        }
        if (n > 65536) {
            throw new InvalidParameterException("Key size must be at most 65536 bit");
        }
        this.modlen = n;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int n) {
        this.initialize(n, null);
    }

    public KeyPair generateKeyPair() {
        PKCS11Object[] pKCS11ObjectArray;
        Object object2;
        Object object3;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateKeyPair");
        }
        int n = 9;
        int n2 = 9;
        int n3 = 0;
        HashMap<Integer, Object> hashMap = null;
        Set<Integer> set = null;
        Boolean bl = this.isToken;
        Boolean bl2 = this.isToken;
        Boolean bl3 = this.sign;
        Boolean bl4 = this.sign;
        Boolean bl5 = this.encrypt;
        Boolean bl6 = this.encrypt;
        Boolean bl7 = this.wrapping;
        Boolean bl8 = this.wrapping;
        if (this.isToken == null) {
            --n2;
            --n;
        }
        if (this.isSensitive == null) {
            --n2;
        }
        if (this.sign == null) {
            --n;
            --n2;
        }
        if (this.encrypt == null) {
            --n;
            --n2;
        }
        if (this.wrapping == null) {
            --n;
            --n2;
        }
        if (this.extractable == null) {
            --n2;
        }
        if (this.config != null) {
            hashMap = this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA);
            set = hashMap.keySet();
            object3 = set.iterator();
            block19: while (object3.hasNext()) {
                object2 = (Integer)object3.next();
                switch ((Integer)object2) {
                    case 1: {
                        if (this.paramsUsed) continue block19;
                        if (bl == null) {
                            ++n;
                        }
                        bl = (Boolean)hashMap.get(object2);
                        continue block19;
                    }
                    case 266: {
                        if (this.paramsUsed) continue block19;
                        if (bl3 == null) {
                            ++n;
                        }
                        bl3 = (Boolean)hashMap.get(object2);
                        continue block19;
                    }
                    case 260: {
                        if (this.paramsUsed) continue block19;
                        if (bl5 == null) {
                            ++n;
                        }
                        bl5 = (Boolean)hashMap.get(object2);
                        continue block19;
                    }
                    case 262: {
                        if (this.paramsUsed) continue block19;
                        if (bl7 == null) {
                            ++n;
                        }
                        bl7 = (Boolean)hashMap.get(object2);
                        continue block19;
                    }
                }
                ++n;
            }
        }
        object3 = new int[n];
        object2 = new Object[n];
        object3[n3] = 289;
        object2[n3++] = new Integer(this.modlen);
        object3[n3] = 290;
        object2[n3++] = new BigInteger("65537");
        object3[n3] = 258;
        object2[n3++] = this.id;
        object3[n3] = 257;
        object2[n3++] = this.subject;
        object3[n3] = 3;
        object2[n3++] = this.label;
        if (bl != null) {
            object3[n3] = true;
            object2[n3++] = bl;
        }
        if (bl3 != null) {
            object3[n3] = 266;
            object2[n3++] = bl3;
        }
        if (bl5 != null) {
            object3[n3] = 260;
            object2[n3++] = bl5;
        }
        if (bl7 != null) {
            object3[n3] = 262;
            object2[n3++] = bl7;
        }
        if (set != null) {
            for (Integer object4 : set) {
                if (object4 == 1 || object4 == 266 || object4 == 260 || object4 == 262) continue;
                object3[n3] = object4;
                object2[n3++] = hashMap.get(object4);
            }
        }
        if (this.config != null) {
            hashMap = this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA);
            set = hashMap.keySet();
            block21: for (Integer n4 : set) {
                switch (n4) {
                    case 1: {
                        if (this.paramsUsed) continue block21;
                        if (bl2 == null) {
                            ++n;
                        }
                        bl2 = (Boolean)hashMap.get(n4);
                        continue block21;
                    }
                    case 259: {
                        if (this.paramsUsed) continue block21;
                        if (this.isSensitive == null) {
                            ++n;
                        }
                        this.isSensitive = (Boolean)hashMap.get(n4);
                        continue block21;
                    }
                    case 261: {
                        if (this.paramsUsed) continue block21;
                        if (bl6 == null) {
                            ++n;
                        }
                        bl6 = (Boolean)hashMap.get(n4);
                        continue block21;
                    }
                    case 264: {
                        if (this.paramsUsed) continue block21;
                        if (bl4 == null) {
                            ++n;
                        }
                        bl4 = (Boolean)hashMap.get(n4);
                        continue block21;
                    }
                    case 263: {
                        if (this.paramsUsed) continue block21;
                        if (bl8 == null) {
                            ++n;
                        }
                        bl8 = (Boolean)hashMap.get(n4);
                        continue block21;
                    }
                }
                ++n;
            }
        }
        Iterator<Integer> iterator = (Iterator<Integer>)new int[n2];
        Object[] objectArray = new Object[n2];
        n3 = 0;
        iterator[n3] = 258;
        objectArray[n3++] = this.id;
        iterator[n3] = (Iterator<Integer>)257;
        objectArray[n3++] = this.subject;
        iterator[n3] = (Iterator<Integer>)3;
        objectArray[n3++] = this.label;
        if (this.isToken != null) {
            iterator[n3] = (Iterator<Integer>)true;
            objectArray[n3++] = this.isToken;
        }
        if (this.isSensitive != null) {
            iterator[n3] = (Iterator<Integer>)259;
            objectArray[n3++] = this.isSensitive;
        }
        if (this.encrypt != null) {
            iterator[n3] = (Iterator<Integer>)261;
            objectArray[n3++] = bl6;
        }
        if (this.sign != null) {
            iterator[n3] = (Iterator<Integer>)264;
            objectArray[n3++] = bl4;
        }
        if (this.wrapping != null) {
            iterator[n3] = (Iterator<Integer>)263;
            objectArray[n3++] = bl8;
        }
        if (this.extractable != null) {
            iterator[n3] = (Iterator<Integer>)354;
            objectArray[n3] = this.extractable;
        }
        if (set != null) {
            for (Integer n5 : set) {
                if (n5 == 1 || n5 == 259 || n5 == 261 || n5 == 264 || n5 == 263 || n5 == 354) continue;
                object3[n3] = n5;
                object2[n3++] = hashMap.get(n5);
            }
        }
        String string = "";
        Object var19_23 = null;
        KeyPair keyPair = null;
        try {
            pKCS11ObjectArray = this.session.generateKeyPair(0, null, (int[])object3, (Object[])object2, iterator, objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)exception);
            }
            throw new RuntimeException(exception.getMessage());
        }
        PKCS11Object[] pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
        PKCS11Object pKCS11Object = pKCS11ObjectArray2[0];
        PKCS11Object pKCS11Object2 = pKCS11ObjectArray2[1];
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(this.session, pKCS11Object, this.id, this.subject, this.label, this.isToken, this.sign, this.encrypt, this.wrapping, (BigInteger)this.getValue(pKCS11Object, 288), (Integer)this.getValue(pKCS11Object, 289), (BigInteger)this.getValue(pKCS11Object, 290));
            RSAPrivateKey rSAPrivateKey = null;
            if (this.isSensitive.booleanValue()) {
                rSAPrivateKey = new RSAPrivateKey(this.session, pKCS11Object2, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290));
            } else {
                try {
                    rSAPrivateKey = new RSAPrivateKey(this.session, pKCS11Object2, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290), (BigInteger)this.getValue(pKCS11Object2, 291), (BigInteger)this.getValue(pKCS11Object2, 292), (BigInteger)this.getValue(pKCS11Object2, 293), (BigInteger)this.getValue(pKCS11Object2, 294), (BigInteger)this.getValue(pKCS11Object2, 295), (BigInteger)this.getValue(pKCS11Object2, 296));
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)exception);
                    }
                    rSAPrivateKey = new RSAPrivateKey(this.session, pKCS11Object2, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290));
                }
            }
            keyPair = new KeyPair(rSAPublicKey, rSAPrivateKey);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_3", (Throwable)exception);
            }
            keyPair = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return keyPair;
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] pKCS11ObjectArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects", (Object[])pKCS11ObjectArray);
        }
        Integer n = (Integer)this.getValue(pKCS11ObjectArray[0], 0);
        Integer n2 = (Integer)this.getValue(pKCS11ObjectArray[1], 0);
        PKCS11Object pKCS11Object = null;
        PKCS11Object pKCS11Object2 = null;
        if (n.equals(PKCS11Object.PUBLIC_KEY) && n2.equals(PKCS11Object.PRIVATE_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[0];
            pKCS11Object = pKCS11ObjectArray[1];
        } else if (n.equals(PKCS11Object.PRIVATE_KEY) && n2.equals(PKCS11Object.PUBLIC_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[1];
            pKCS11Object = pKCS11ObjectArray[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        pKCS11ObjectArray[0] = pKCS11Object2;
        pKCS11ObjectArray[1] = pKCS11Object;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)pKCS11ObjectArray);
        }
        return pKCS11ObjectArray;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

