/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RSACipher
extends CipherSpi {
    private boolean decrypting = false;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private int mechanism;
    private PKCS11Session session = null;
    private Provider provider = null;
    private int paddingIndicator = 0;
    private BigInteger modulus;
    private byte[] data = null;
    private int dataUsed = 0;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSACipher";

    public RSACipher(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.mechanism = 1;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && (string.equals(" ") || string.equals("SSL"))) {
            return;
        }
        if (string != null) {
            throw new NoSuchAlgorithmException("Mode: " + string + " not implemented");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetPadding", (Object)("." + string + "."));
        }
        if (string.equalsIgnoreCase("PKCS1Padding") || string.equalsIgnoreCase("PKCS")) {
            this.paddingIndicator = 0;
            this.mechanism = 1;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"PKCS");
            }
            return;
        }
        if (string.equals(" ") || string.equalsIgnoreCase("NoPadding") || string == null) {
            this.paddingIndicator = 1;
            this.mechanism = 3;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"RAW RSA");
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"No such padding.");
        }
        throw new NoSuchPaddingException("Padding: " + string + " not implemented");
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int n) {
        return this.modulus.toByteArray().length;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        PKCS11Key pKCS11Key;
        this.decrypting = n == 2 || n == 4;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        String string = key.getAlgorithm();
        if (!string.equals("RSA")) {
            throw new InvalidKeyException("Not a RSA key.  Key algorithm is " + string + ".");
        }
        if (key instanceof PublicKey) {
            Object object;
            if (this.decrypting) {
                throw new InvalidKeyException("Public Key cannot be used to decrypt.");
            }
            if (key instanceof RSAPublicKey) {
                object = null;
                try {
                    object = KeyFactory.getInstance("RSA", this.provider);
                    pKCS11Key = (PKCS11Key)((KeyFactory)object).translateKey(key);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
                }
            } else {
                if (!(key instanceof PKCS11Key)) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("not RSA key: " + key);
                }
                pKCS11Key = (PKCS11Key)key;
            }
            try {
                object = (RSAPublicKey)key;
                this.modulus = object.getModulus();
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else if (key instanceof PrivateKey) {
            Object object;
            if (!this.decrypting) {
                throw new InvalidKeyException("Private key cannot be used to encrypt.");
            }
            if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                object = null;
                try {
                    object = KeyFactory.getInstance("RSA", this.provider);
                    pKCS11Key = (PKCS11Key)((KeyFactory)object).translateKey(key);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
                }
            } else {
                if (!(key instanceof PKCS11Key)) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("not RSA key: " + key);
                }
                pKCS11Key = (PKCS11Key)key;
            }
            try {
                object = (RSAPrivateKey)key;
                this.modulus = object.getModulus();
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else {
            throw new InvalidKeyException("Must be either public key or private key.");
        }
        this.data = new byte[(this.modulus.bitLength() + 7) / 8];
        this.dataUsed = 0;
        this.cipher = new PKCS11Cipher(this.mechanism, this.session);
        this.cipher.engineInit(n, pKCS11Key.getObject(), null, (this.modulus.bitLength() + 7) / 8);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.dataUsed + n2 > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        System.arraycopy(byArray, n, this.data, this.dataUsed, n2);
        this.dataUsed += n2;
        return new byte[0];
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.dataUsed + n2 > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        System.arraycopy(byArray, n, this.data, this.dataUsed, n2);
        this.dataUsed += n2;
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (this.dataUsed + n2 > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (n2 != 0) {
            System.arraycopy(byArray, n, this.data, this.dataUsed, n2);
        }
        return this.cipher.engineDoFinal(this.data, 0, this.dataUsed + n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.dataUsed + n2 > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (n2 != 0) {
            System.arraycopy(byArray, n, this.data, this.dataUsed, n2);
        }
        return this.cipher.engineDoFinal(this.data, 0, this.dataUsed + n2, byArray2, n3);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PublicKey) {
            try {
                BigInteger bigInteger = ((RSAPublicKey)key).getModulus();
                return bigInteger.bitLength();
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        if (key instanceof PrivateKey) {
            try {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                BigInteger bigInteger = rSAPrivateKey.getModulus();
                return bigInteger.bitLength();
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        throw new InvalidKeyException("Must be either public key or private key.");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        int n = 0;
        n = (this.modulus.bitLength() + 7) / 8 > ((PKCS11Key)key).getObject().size() ? (this.modulus.bitLength() + 7) / 8 : ((PKCS11Key)key).getObject().size();
        return this.cipher.engineWrap(((PKCS11Key)key).getObject(), n);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key = null;
        int[] nArray = null;
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[2];
        PKCS11Object pKCS11Object = null;
        switch (n) {
            case 3: {
                objectArray2 = ConstructKeys.constructSecretKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructSecretKey(pKCS11Object, string, this.provider);
                break;
            }
            case 2: {
                objectArray2 = ConstructKeys.constructPrivateKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructPrivateKey(pKCS11Object, string, this.provider);
                break;
            }
            case 1: {
                objectArray2 = ConstructKeys.constructPublicKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructPublicKey(pKCS11Object, string, this.provider);
            }
        }
        return key;
    }
}

