/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.DESedePKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKeyParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class GeneralPKCS11KeyGenerator
extends KeyGeneratorSpi {
    private PKCS11Session session = null;
    private Config config = null;
    private byte[] id = null;
    private String label = null;
    private Boolean isToken = null;
    private Boolean isSensitive = null;
    private Boolean encrypt = null;
    private Boolean wrapping = null;
    private Boolean extractable = null;
    private boolean keySpecUsed = false;
    private int keySize = 0;
    private KeyMechanismBuilder mechanismBuilder;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator";

    public GeneralPKCS11KeyGenerator(Provider provider, String string) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(string);
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.keySize = this.mechanismBuilder.getDefaultKeySize() / 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11SecretKeyParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 Secret Key Parameters must be specified");
        }
        PKCS11SecretKeyParameterSpec pKCS11SecretKeyParameterSpec = (PKCS11SecretKeyParameterSpec)algorithmParameterSpec;
        try {
            this.id = pKCS11SecretKeyParameterSpec.getKeyID().getBytes("8859_1");
        }
        catch (Exception exception) {
            this.id = pKCS11SecretKeyParameterSpec.getKeyID().getBytes();
        }
        this.label = pKCS11SecretKeyParameterSpec.getLabel();
        this.isToken = pKCS11SecretKeyParameterSpec.getToken();
        this.isSensitive = pKCS11SecretKeyParameterSpec.getSensitive();
        this.encrypt = pKCS11SecretKeyParameterSpec.getEncrypt();
        this.wrapping = pKCS11SecretKeyParameterSpec.getWrap();
        this.extractable = pKCS11SecretKeyParameterSpec.getExtractable();
        if (algorithmParameterSpec instanceof GeneralPKCS11KeyParameterSpec) {
            GeneralPKCS11KeyParameterSpec generalPKCS11KeyParameterSpec = (GeneralPKCS11KeyParameterSpec)algorithmParameterSpec;
            if (generalPKCS11KeyParameterSpec.getKeyType() != this.mechanismBuilder.getKeyType()) throw new InvalidAlgorithmParameterException("The Secret Key type must be " + this.mechanismBuilder.getAlgorithm());
            this.keySize = generalPKCS11KeyParameterSpec.getKeySizeInBytes();
        } else if (algorithmParameterSpec instanceof DESPKCS11KeyParameterSpec) {
            this.keySize = 8;
        } else if (algorithmParameterSpec instanceof DESedePKCS11KeyParameterSpec) {
            this.keySize = 24;
        }
        this.keySpecUsed = true;
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        int n2 = this.mechanismBuilder.getMechanism();
        switch (n2) {
            case 288: {
                if (n == 64) break;
                throw new InvalidParameterException("DES key length must be 64 bits");
            }
            case 305: {
                if (n == 192) break;
                throw new InvalidParameterException("DESede key length must be 192 bits");
            }
            case 4224: {
                if (n == 128 || n == 192 || n == 256) break;
                throw new InvalidParameterException("AES key length must be 128, 192, or 256 bits");
            }
            case 272: {
                if (n >= 40 && n <= 1024) break;
                throw new InvalidParameterException("ARCFOUR key length must be between 40 and 1024 bits");
            }
            case 4240: {
                if (n >= 40 && n <= 448) break;
                throw new InvalidParameterException("Blowfish key length must be between 40 and 448 bits");
            }
        }
        this.keySize = n / 8;
    }

    protected SecretKey engineGenerateKey() {
        GeneralKey generalKey;
        PKCS11Object pKCS11Object = null;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        if (this.config != null) {
            hashMap.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, this.mechanismBuilder.getKeyType()));
        } else if (!this.keySpecUsed) {
            this.isToken = new Boolean(false);
            this.isSensitive = new Boolean(false);
            this.encrypt = new Boolean(true);
            this.wrapping = new Boolean(true);
        }
        if (this.id != null) {
            hashMap.put(258, this.id);
        }
        if (this.label != null) {
            hashMap.put(3, this.label);
        }
        if (this.isToken != null) {
            hashMap.put(1, this.isToken);
        }
        if (this.isSensitive != null) {
            hashMap.put(259, this.isSensitive);
        }
        if (this.encrypt != null) {
            hashMap.put(260, this.encrypt);
            hashMap.put(261, this.encrypt);
        }
        if (this.wrapping != null) {
            hashMap.put(262, this.wrapping);
            hashMap.put(263, this.wrapping);
        }
        if (this.extractable != null) {
            hashMap.put(354, this.extractable);
        }
        if (this.keySize > 0) {
            hashMap.put(353, this.keySize);
        } else {
            this.engineInit(null);
            hashMap.put(353, this.keySize);
        }
        int[] nArray = new int[hashMap.size()];
        Object[] objectArray = new Object[hashMap.size()];
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            nArray[n] = n2;
            objectArray[n++] = hashMap.get(n2);
            if (debug == null) continue;
            debug.text(16384L, (Object)className, "engineGenerateKey_0.5", "attrType = " + nArray[n - 1]);
            debug.text(16384L, (Object)className, "engineGenerateKey_0.5", "attrValue = " + objectArray[n - 1]);
        }
        try {
            pKCS11Object = this.session.generateKey(this.mechanismBuilder.getMechanism(), null, nArray, objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey_1", (Throwable)exception);
            }
            throw new RuntimeException(exception.getMessage());
        }
        try {
            generalKey = new GeneralKey(this.session, pKCS11Object, this.mechanismBuilder.getAlgorithm());
        }
        catch (Exception exception) {
            generalKey = null;
        }
        return generalKey;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

