/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.util.Date;

public final class GeneralKey
implements GeneralPKCS11Key,
Serializable {
    private static final long serialVersionUID = 3617574881836020272L;
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private Boolean isSensitive = null;
    private Boolean isEncrypt = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isVerify = null;
    private Boolean isWrap = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private int keySize;
    private byte[] value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralKey";
    KeyMechanismBuilder mechanismBuilder;

    GeneralKey(PKCS11Session pKCS11Session, PKCS11Object pKCS11Object, String string) throws InvalidKeyException {
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(string);
        Integer n = this.mechanismBuilder.getKeyType();
        this.session = pKCS11Session;
        this.object = pKCS11Object;
        this.ID = (byte[])this.getAttrValue(this.object, 258);
        this.label = (String)this.getAttrValue(this.object, 3);
        this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        this.isSensitive = (Boolean)this.getAttrValue(this.object, 259);
        this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
        this.isExtractable = (Boolean)this.getAttrValue(this.object, 354);
        Integer n2 = (Integer)this.getAttrValue(this.object, 353);
        if (n2 != null) {
            this.keySize = n2;
        }
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
        if (this.isSensitive != null && !this.isSensitive.booleanValue()) {
            byte[] byArray = (byte[])this.getAttrValue(this.object, 17);
            this.value = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.value, 0, byArray.length);
        }
    }

    public byte[] getEncoded() {
        if (this.value != null) {
            return (byte[])this.value.clone();
        }
        return null;
    }

    public int getValueLen() {
        return this.keySize;
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.mechanismBuilder.getKeyType();
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getKeySizeInBytes() {
        return this.keySize;
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public String toString() {
        String string = "IBMPKCS11Impl";
        String string2 = string + " General Key: ";
        if (this.isToken != null) {
            string2 = string2 + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            string2 = string2 + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            string2 = string2 + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            string2 = string2 + "\n Modifiable: " + this.isModifiable;
        }
        string2 = string2 + "\n KeyType: " + this.mechanismBuilder.getAlgorithm();
        if (this.ID != null) {
            string2 = string2 + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            string2 = string2 + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            string2 = string2 + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            string2 = string2 + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            string2 = string2 + "\n Local: " + this.isLocal;
        }
        if (this.isSensitive != null) {
            string2 = string2 + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isEncrypt != null) {
            string2 = string2 + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isDecrypt != null) {
            string2 = string2 + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            string2 = string2 + "\n Sign: " + this.isSign;
        }
        if (this.isVerify != null) {
            string2 = string2 + "\n Verify: " + this.isVerify;
        }
        if (this.isWrap != null) {
            string2 = string2 + "\n Wrap: " + this.isWrap;
        }
        if (this.isUnwrap != null) {
            string2 = string2 + "\n Unwrap: " + this.isUnwrap;
        }
        if (this.isExtractable != null) {
            string2 = string2 + "\n Extractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            string2 = string2 + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            string2 = string2 + "\n Never Extractable: " + this.isNeverExtractable;
        }
        if (this.value != null) {
            string2 = string2 + "\n value: " + this.value.toString();
        }
        string2 = string2 + "\n keySize in bytes: " + this.keySize;
        return string2;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return this.mechanismBuilder.getAlgorithm();
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

