/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

class DHPKCS11PublicKey
implements PKCS11PublicKey,
DHPublicKey,
Serializable {
    private static final long serialVersionUID = 3258135773294114104L;
    private BigInteger y = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private PKCS11Object p11Object = null;
    private static final int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPKCS11PublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, PKCS11Session pKCS11Session, Config config) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding for the public key");
        }
        this.importPublicKeyIntoToken(pKCS11Session, config);
    }

    public DHPKCS11PublicKey(PKCS11Object pKCS11Object) throws InvalidKeyException {
        this.p11Object = pKCS11Object;
        try {
            this.y = new BigInteger(1, (byte[])this.getAttrValue(this.p11Object, 17));
            this.p = (BigInteger)this.getAttrValue(this.p11Object, 304);
            this.g = (BigInteger)this.getAttrValue(this.p11Object, 306);
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPKCS11PublicKey(byte[] byArray, PKCS11Session pKCS11Session, Config config) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException("Invalid key format");
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            if (!objectIdentifier.equals(ObjectIdentifier.newInternal((int[])DH_data))) {
                throw new InvalidKeyException("AlgorithID is not PKCS DH");
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                int n = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derValue.getData().getBitString();
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException("Excess key data");
            }
            this.encodedKey = (byte[])byArray.clone();
            this.importPublicKeyIntoToken(pKCS11Session, config);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException(pKCS11Exception.getMessage());
        }
    }

    private void importPublicKeyIntoToken(PKCS11Session pKCS11Session, Config config) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, PKCS11Object.PUBLIC_KEY);
        hashMap.put(256, PKCS11Object.DH);
        hashMap.put(304, this.p);
        hashMap.put(306, this.g);
        hashMap.put(17, this.y.toByteArray());
        hashMap.putAll(config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DH));
        int[] nArray = new int[hashMap.size()];
        Object[] objectArray = new Object[hashMap.size()];
        Iterator iterator = hashMap.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            nArray[n] = (Integer)entry.getKey();
            objectArray[n++] = entry.getValue();
        }
        this.p11Object = pKCS11Session.createObject(nArray, objectArray);
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IBMPKCS11 Diffie-Hellman Public Key:\ny:\n" + this.y.toString() + "\n" + "p:\n" + this.p.toString() + "\n" + "g:\n" + this.g.toString());
        return stringBuffer.toString();
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public byte[] getSubject() {
        return null;
    }

    public Boolean getEncrypt() {
        return null;
    }

    public Boolean getVerify() {
        return null;
    }

    public Boolean getVerifyRecover() {
        return null;
    }

    public Boolean getWrap() {
        return null;
    }

    public PKCS11Session getSession() {
        return this.p11Object.getSession();
    }

    public PKCS11Object getObject() {
        return this.p11Object;
    }

    public Boolean getToken() {
        Boolean bl = (Boolean)this.getAttrValue(this.p11Object, 1);
        return new Boolean(bl);
    }

    public Boolean getPrivate() {
        return Boolean.FALSE;
    }

    public String getLabel() {
        return (String)this.getAttrValue(this.p11Object, 3);
    }

    public Boolean getModifiable() {
        Boolean bl = (Boolean)this.getAttrValue(this.p11Object, 368);
        return new Boolean(bl);
    }

    public Integer getKeyType() {
        return PKCS11Object.DH;
    }

    public byte[] getID() {
        return (byte[])((byte[])this.getAttrValue(this.p11Object, 258)).clone();
    }

    public Date getStartDate() {
        return null;
    }

    public Date getEndDate() {
        return null;
    }

    public Boolean getDerive() {
        Boolean bl = (Boolean)this.getAttrValue(this.p11Object, 268);
        return new Boolean(bl);
    }

    public Boolean getLocal() {
        Boolean bl = (Boolean)this.getAttrValue(this.p11Object, 355);
        return new Boolean(bl);
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }
}

