/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHPKCS11ParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final Map<Integer, DHParameterSpec> dhCache = Collections.synchronizedMap(new HashMap());
    private int primeSize = 1024;
    private int exponentSize = 0;
    private SecureRandom random = null;
    private Provider provider = null;

    public DHPKCS11ParameterGenerator(Provider provider) {
        this.provider = provider;
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.primeSize = n;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.primeSize = dHGenParameterSpec.getPrimeSize();
        if (this.primeSize < 512 || this.primeSize > 1024 || this.primeSize % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Modulus size must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.exponentSize = dHGenParameterSpec.getExponentSize();
        if (this.exponentSize < 0) {
            throw new InvalidAlgorithmParameterException("Exponent size must be greater than zero");
        }
        if (this.exponentSize >= this.primeSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must be less than modulus size");
        }
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.exponentSize == 0) {
            int n = this.exponentSize = this.primeSize >= 1024 ? 768 : 512;
        }
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstance("IBMSecureRandom", this.provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.random = new SecureRandom();
            }
        }
        AlgorithmParameters algorithmParameters = null;
        try {
            DHParameterSpec dHParameterSpec = dhCache.get(this.primeSize);
            if (dHParameterSpec == null) {
                PKCS11Session pKCS11Session = ((IBMPKCS11Impl)this.provider).getSession();
                int[] nArray = new int[2];
                Object[] objectArray = new Object[2];
                nArray[0] = 0;
                objectArray[0] = PKCS11Object.DOMAIN_PARAMETERS;
                nArray[1] = 307;
                objectArray[1] = new Integer(this.primeSize);
                PKCS11Object pKCS11Object = pKCS11Session.generateKey(8193, null, nArray, objectArray);
                BigInteger bigInteger = pKCS11Object.getBigIntegerAttributeValue(304);
                BigInteger bigInteger2 = pKCS11Object.getBigIntegerAttributeValue(306);
                dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2, this.exponentSize);
                dhCache.put(this.primeSize, dHParameterSpec);
            }
            algorithmParameters = AlgorithmParameters.getInstance("DH", this.provider);
            algorithmParameters.init(dHParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new RuntimeException(pKCS11Exception.getMessage());
        }
        return algorithmParameters;
    }

    static {
        BigInteger bigInteger = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
        BigInteger bigInteger2 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
        BigInteger bigInteger3 = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
        BigInteger bigInteger4 = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
        BigInteger bigInteger5 = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
        BigInteger bigInteger6 = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
        dhCache.put(512, new DHParameterSpec(bigInteger, bigInteger2, 512));
        dhCache.put(768, new DHParameterSpec(bigInteger3, bigInteger4, 512));
        dhCache.put(1024, new DHParameterSpec(bigInteger5, bigInteger6, 768));
    }
}

