/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DESParameters
extends AlgorithmParametersSpi {
    private byte[] iv;

    public DESParameters(Provider provider) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter specification must be IvParameterSpec.");
        }
        byte[] byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
        if (byArray.length != 8) {
            throw new InvalidParameterSpecException("IV must be 8 bytes long");
        }
        this.iv = (byte[])byArray.clone();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerInputStream derInputStream = null;
        try {
            derInputStream = new DerInputStream(byArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(arrayIndexOutOfBoundsException.getMessage());
        }
        byte[] byArray2 = derInputStream.getOctetString();
        if (derInputStream.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        if (byArray2.length != 8) {
            throw new IOException("IV must be 8 bytes long");
        }
        this.iv = byArray2;
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName("javax.crypto.spec.IvParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("Parameter specification must be IvParameterSpec.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOctetString(this.iv);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String string = "\n    iv:\n[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.iv);
        string = string + "]\n";
        return string;
    }
}

