/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    String declaringClass;
    String methodName;
    String fileName;
    int lineNumber;

    public StackTraceElement(String string, String string2, String string3, int n) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.declaringClass = string;
        this.methodName = string2;
        this.fileName = string3;
        this.lineNumber = n;
    }

    private StackTraceElement() {
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        if (this.methodName == null || stackTraceElement.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(stackTraceElement.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(stackTraceElement.getClassName())) {
            return false;
        }
        String string = this.getFileName();
        if (string == null ? stackTraceElement.getFileName() != null : !string.equals(stackTraceElement.getFileName())) {
            return false;
        }
        return this.getLineNumber() == stackTraceElement.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        return this.methodName.hashCode() ^ this.declaringClass.hashCode();
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(this.getClassName());
        stringBuffer.append('.');
        stringBuffer.append(this.getMethodName());
        if (this.isNativeMethod()) {
            stringBuffer.append("(Native Method)");
        } else {
            String string = this.getFileName();
            if (string == null) {
                stringBuffer.append("(Unknown Source)");
            } else {
                int n = this.getLineNumber();
                stringBuffer.append('(');
                stringBuffer.append(string);
                if (n >= 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(n);
                }
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }
}

