/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassTokenHelper;

public class SharedClassTokenHelperImpl
extends SharedClassAbstractHelper
implements SharedClassTokenHelper {
    private boolean canFind;
    private boolean canStore;

    SharedClassTokenHelperImpl(ClassLoader classLoader, int n, boolean bl, boolean bl2) {
        this.id = n;
        this.canFind = bl;
        this.canStore = bl2;
        this.initializeShareableClassloader(classLoader);
        this.printVerboseInfo("Created TokenHelper with id " + n);
    }

    private native boolean findSharedClassImpl(int var1, String var2, String var3, byte[] var4);

    private native boolean storeSharedClassImpl(int var1, ClassLoader var2, String var3, Class var4);

    public synchronized byte[] findSharedClass(String string, String string2) {
        if (!this.canFind) {
            return null;
        }
        if (string == null) {
            this.printVerboseError("Cannot call findSharedClass with null token. Returning null.");
            return null;
        }
        if (string2 == null) {
            this.printVerboseError("Cannot call findSharedClass with null class name. Returning null.");
            return null;
        }
        byte[] byArray = new byte[this.ROMCLASS_COOKIE_SIZE];
        boolean bl = this.findSharedClassImpl(this.id, string2, string, byArray);
        if (!bl) {
            return null;
        }
        return byArray;
    }

    public synchronized boolean storeSharedClass(String string, Class clazz) {
        if (!this.canStore) {
            return false;
        }
        if (string == null) {
            this.printVerboseError("Cannot call storeSharedClass with null token. Returning false.");
            return false;
        }
        if (clazz == null) {
            this.printVerboseError("Cannot call storeSharedClass with null Class. Returning false.");
            return false;
        }
        ClassLoader classLoader = this.getClassLoader();
        if (!this.validateClassLoader(classLoader, clazz)) {
            return false;
        }
        return this.storeSharedClassImpl(this.id, classLoader, string, clazz);
    }
}

