/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.SharedClassHelper;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassPermission;
import com.ibm.oti.shared.SharedClassTokenHelper;
import com.ibm.oti.shared.SharedClassTokenHelperImpl;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import com.ibm.oti.shared.SharedClassURLClasspathHelperImpl;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.oti.shared.SharedClassURLHelperImpl;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;

public class SharedClassHelperFactoryImpl
implements SharedClassHelperFactory {
    static HashMap helpers = new HashMap();
    static int idCount = 1;

    private boolean checkPermission(ClassLoader classLoader, String string) {
        boolean bl = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SharedClassPermission(classLoader, string));
            }
            catch (AccessControlException accessControlException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean canFind(ClassLoader classLoader) {
        return this.checkPermission(classLoader, "read");
    }

    private boolean canStore(ClassLoader classLoader) {
        return this.checkPermission(classLoader, "write");
    }

    private String objectToString(Object object) {
        return object.getClass().getName() + Integer.toHexString(object.hashCode());
    }

    private void addHelper(ClassLoader classLoader, SharedClassHelper sharedClassHelper) {
        String string = this.objectToString(classLoader);
        HelperList helperList = (HelperList)helpers.get(string);
        if (helperList == null) {
            helpers.put(string, new HelperList(sharedClassHelper));
        } else {
            HelperList helperList2 = null;
            while (helperList != null) {
                if (helperList.current == null) {
                    helperList.current = sharedClassHelper;
                    return;
                }
                helperList2 = helperList;
                helperList = helperList.next;
            }
            helperList2.next = new HelperList(sharedClassHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassHelper findHelperForClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            String string = this.objectToString(classLoader);
            HelperList helperList = (HelperList)helpers.get(string);
            while (helperList != null) {
                SharedClassHelper sharedClassHelper = helperList.current;
                if (sharedClassHelper != null) {
                    ClassLoader classLoader2 = sharedClassHelper.getClassLoader();
                    if (classLoader2 == classLoader) {
                        return helperList.current;
                    }
                    if (classLoader2 == null) {
                        helperList.current = null;
                    }
                }
                helperList = helperList.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassTokenHelper getTokenHelper(ClassLoader classLoader) throws HelperAlreadyDefinedException {
        if (classLoader == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            SharedClassHelper sharedClassHelper = this.findHelperForClassLoader(classLoader);
            if (sharedClassHelper != null) {
                if (sharedClassHelper instanceof SharedClassTokenHelper) {
                    return (SharedClassTokenHelper)sharedClassHelper;
                }
                throw new HelperAlreadyDefinedException("A different type of helper already exists for this classloader");
            }
            boolean bl = this.canFind(classLoader);
            boolean bl2 = this.canStore(classLoader);
            if (bl || bl2) {
                SharedClassTokenHelperImpl sharedClassTokenHelperImpl = new SharedClassTokenHelperImpl(classLoader, idCount++, bl, bl2);
                this.addHelper(classLoader, sharedClassTokenHelperImpl);
                return sharedClassTokenHelperImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassURLHelper getURLHelper(ClassLoader classLoader) throws HelperAlreadyDefinedException {
        if (classLoader == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            SharedClassHelper sharedClassHelper = this.findHelperForClassLoader(classLoader);
            if (sharedClassHelper != null) {
                if (sharedClassHelper instanceof SharedClassURLHelper) {
                    return (SharedClassURLHelper)sharedClassHelper;
                }
                throw new HelperAlreadyDefinedException("A different type of helper already exists for this classloader");
            }
            boolean bl = this.canFind(classLoader);
            boolean bl2 = this.canStore(classLoader);
            if (bl || bl2) {
                SharedClassURLHelperImpl sharedClassURLHelperImpl = new SharedClassURLHelperImpl(classLoader, idCount++, bl, bl2);
                this.addHelper(classLoader, sharedClassURLHelperImpl);
                return sharedClassURLHelperImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedClassURLClasspathHelper getURLClasspathHelper(ClassLoader classLoader, URL[] uRLArray) throws HelperAlreadyDefinedException {
        if (classLoader == null || uRLArray == null) {
            return null;
        }
        HashMap hashMap = helpers;
        synchronized (hashMap) {
            SharedClassHelper sharedClassHelper = this.findHelperForClassLoader(classLoader);
            SharedClassURLClasspathHelperImpl sharedClassURLClasspathHelperImpl = null;
            boolean bl = true;
            if (sharedClassHelper != null) {
                if (sharedClassHelper instanceof SharedClassURLClasspathHelper) {
                    sharedClassURLClasspathHelperImpl = (SharedClassURLClasspathHelperImpl)sharedClassHelper;
                    URL[] uRLArray2 = sharedClassURLClasspathHelperImpl.getClasspath();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (uRLArray[i].equals(uRLArray2[i])) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return sharedClassURLClasspathHelperImpl;
                    }
                    throw new HelperAlreadyDefinedException("A SharedClassURLClasspathHelper already exists for this classloader with a different classpath");
                }
                throw new HelperAlreadyDefinedException("A different type of helper already exists for this classloader");
            }
            boolean bl2 = this.canFind(classLoader);
            boolean bl3 = this.canStore(classLoader);
            if (bl2 || bl3) {
                sharedClassURLClasspathHelperImpl = new SharedClassURLClasspathHelperImpl(classLoader, uRLArray, idCount++, bl2, bl3);
                this.addHelper(classLoader, sharedClassURLClasspathHelperImpl);
                return sharedClassURLClasspathHelperImpl;
            }
        }
        return null;
    }

    class HelperList {
        SharedClassHelper current;
        HelperList next;

        public HelperList(SharedClassHelper sharedClassHelper) {
            this.current = sharedClassHelper;
            this.next = null;
        }
    }
}

