/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassHelper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class SharedClassAbstractHelper
implements SharedClassHelper {
    int ROMCLASS_COOKIE_SIZE = 0;
    private Boolean verbose = null;
    private WeakReference loaderRef;
    int id;

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loaderRef.get();
    }

    public boolean isSharedClassCookie(byte[] byArray) {
        return byArray.length == this.ROMCLASS_COOKIE_SIZE;
    }

    private native int initializeShareableClassloaderImpl(ClassLoader var1);

    private native boolean getIsVerboseImpl();

    private boolean isVerbose() {
        if (this.verbose == null) {
            boolean bl = this.getIsVerboseImpl();
            this.verbose = new Boolean(bl);
            if (bl) {
                this.printVerboseInfo("Verbose output enabled for SharedClassHelper id " + this.id);
            }
        }
        return this.verbose;
    }

    void printVerboseError(String string) {
        if (this.isVerbose()) {
            System.err.println("Error for SharedClassHelper id " + this.id + ": " + string);
        }
    }

    void printVerboseInfo(String string) {
        if (this.isVerbose()) {
            System.err.println("Info for SharedClassHelper id " + this.id + ": " + string);
        }
    }

    void initializeShareableClassloader(ClassLoader classLoader) {
        this.loaderRef = new WeakReference<ClassLoader>(classLoader);
        this.ROMCLASS_COOKIE_SIZE = this.initializeShareableClassloaderImpl(classLoader);
    }

    URL convertJarURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (!uRL.getProtocol().equals("jar")) {
            return uRL;
        }
        String string = this.recursiveJarTrim(uRL.getPath());
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private String recursiveJarTrim(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf("!/");
        boolean bl = string.startsWith("jar:");
        int n3 = bl ? 4 : 0;
        int n4 = n = n2 >= 0 ? n2 : string.length();
        if (!bl && n2 == -1) {
            return string;
        }
        return this.recursiveJarTrim(string.substring(n3, n));
    }

    boolean validateClassLoader(ClassLoader classLoader, Class clazz) {
        if (classLoader == null) {
            return false;
        }
        if (!classLoader.equals(clazz.getClassLoader())) {
            this.printVerboseError("ClassLoader of SharedClassHelper and ClassLoader of class " + clazz.getName() + " do not match.");
            return false;
        }
        return true;
    }

    boolean validateURL(URL uRL, boolean bl) {
        String string;
        Boolean bl2;
        String string2 = uRL.getProtocol();
        if (!string2.equals("file") && !string2.equals("jar")) {
            this.printVerboseInfo("URL " + uRL + " does not have required file or jar protocol.");
            return false;
        }
        if (bl && !(bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(string = uRL.getPath()){
            final /* synthetic */ String val$fPath;
            {
                this.val$fPath = string;
            }

            public Object run() {
                File file = new File(this.val$fPath);
                return new Boolean(file.exists());
            }
        })).booleanValue()) {
            this.printVerboseError("URL resource " + uRL + " does not exist.");
            return false;
        }
        return true;
    }
}

