/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.Merge;
import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceRecord50;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public final class TraceFormat {
    private TraceArgs traceArgs = null;
    private Vector traceFiles = new Vector();
    private TraceFile traceFile = null;
    private BufferedWriter out;
    private static int generations;
    protected static MessageFile messageFile;
    protected static MessageFile messageFileBase;
    protected static Vector threads;
    protected static int invalidBuffers;
    protected static float verMod;
    protected static BigInteger overallStartSystem;
    protected static BigInteger overallStartPlatform;
    protected static BigInteger first;
    protected static BigInteger last;
    protected static BigInteger lastWritePlatform;
    protected static BigInteger lastWriteSystem;
    protected static BigInteger timeConversion;
    protected static String headings;
    protected static PrintStream outStream;
    protected static int expectedRecords;
    private Vector vectorOfAllTracePoints = null;
    private boolean populateGlobalArray = false;
    private boolean traceFileIsTruncatedOrCorrupt = false;
    private String[] types = new String[]{"Event     ", "Exception ", "Entry     ", "Entry     ", "Exit      ", "Exit      ", "Mem       ", "Mem       ", "Debug     ", "Debug     ", "Perf      ", "Perf      ", "AppTrace  "};
    protected static final String usageMessage = "Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-dat datfilelocation] [-uservmid vmid] [-indent] \n\t[-overridetimezone noOfHours]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdat = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -dat /142sdk/jre/lib\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n";
    protected static final String header = "                Trace Formatted Data ";
    private static final int FAIL = -1;
    private static final int OK = 0;
    private static String userVMIdentifier;
    private int tracedThreadWithNewestTracePoint = -1;

    public static void main(String[] stringArray) {
        TraceFormat traceFormat = new TraceFormat();
        traceFormat.readAndFormat(stringArray);
    }

    public TraceFormat() {
        this.initStatics();
        this.vectorOfAllTracePoints = new Vector();
        outStream = System.out;
    }

    public TraceFormat(String[] stringArray) {
        new TraceFormat(System.out, stringArray);
    }

    public TraceFormat(PrintStream printStream, String[] stringArray) {
        this.initStatics();
        outStream = printStream;
        this.readAndFormat(stringArray);
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            outStream.println("Error closing formatted trace file.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void initStatics() {
        threads = new Vector();
        invalidBuffers = 0;
        overallStartSystem = BigInteger.ZERO;
        overallStartPlatform = BigInteger.ZERO;
        first = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        last = BigInteger.ZERO;
        lastWritePlatform = BigInteger.ZERO;
        lastWriteSystem = BigInteger.ZERO;
        timeConversion = BigInteger.ZERO;
        headings = new String("ThreadID         TP id  Type         TraceEntry ");
        expectedRecords = 0;
        Util.initStatics();
        TraceArgs.initStatics();
        TraceRecord.initStatics();
        MessageFile.initStatics();
    }

    private void readAndFormat(String[] stringArray) {
        block51: {
            try {
                this.traceArgs = new TraceArgs(stringArray);
            }
            catch (TraceArgs.UsageException usageException) {
                outStream.println("TraceFormat Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-dat datfilelocation] [-uservmid vmid] [-indent] \n\t[-overridetimezone noOfHours]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdat = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -dat /142sdk/jre/lib\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n");
                return;
            }
            userVMIdentifier = TraceArgs.userVMIdentifier;
            try {
                TracePoint tracePoint;
                Object object;
                int n;
                if (this.getTraceFiles() != 0) {
                    return;
                }
                this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(TraceArgs.outputFile)));
                Util.Debug.println("TraceFormat.verMod = " + verMod);
                if (!TraceArgs.is50orNewer && (double)verMod < 5.0 || TraceArgs.override) {
                    String string = null;
                    if (TraceArgs.datFileDirectory == null) {
                        string = ".";
                        outStream.println("Processing pre 50 trace file with 50 formatter. Searching for the .dat files supplied with the traced vm in the current directory.");
                        outStream.println("****Absence of the dat files will cause failure****");
                    } else {
                        string = TraceArgs.datFileDirectory;
                    }
                    for (TraceFile this.traceFile : this.traceFiles) {
                        this.traceFile.traceFileHeader.processTraceBufferHeaders();
                    }
                    for (Object object2 : threads) {
                        Collections.sort(object2);
                    }
                    if (TraceArgs.summary) {
                        this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
                        return;
                    }
                    if (this.doSummary(this.out) != 0) {
                        return;
                    }
                    String string2 = string;
                    String string3 = this.traceFile.formatFileName();
                    try {
                        messageFile = new MessageFile((String)string2 + File.separator + string3);
                    }
                    catch (Exception exception) {
                        outStream.println("Can't open dat files - you need to copy the dat files from the traced vm to the current directory");
                        outStream.println(" or use the -dat flag to tell the formatter which directory it can find them in");
                        Util.Debug.println(exception);
                        return;
                    }
                    if (!string3.equals("TraceFormat.dat")) {
                        messageFileBase = new MessageFile((String)string2 + File.separator + "TraceFormat.dat");
                    }
                    outStream.println("*** starting formatting of entries");
                    this.out.write(header, 0, header.length());
                    this.out.newLine();
                    this.out.newLine();
                    if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
                        headings = "ThreadID TP id  Type         TraceEntry ";
                    }
                    this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
                    this.out.newLine();
                    try {
                        String string4;
                        Merge merge = new Merge(threads);
                        String string5 = System.getProperty("line.separator");
                        while ((string4 = merge.getNextEntry()) != null) {
                            this.out.write(string4 + string5);
                        }
                    }
                    catch (InvalidSpannedRecordException invalidSpannedRecordException) {
                        outStream.println("\n" + invalidSpannedRecordException.getMessage());
                        return;
                    }
                    this.out.flush();
                    outStream.println("*** formatted ");
                    outStream.println("Formatted output written to file: " + TraceArgs.outputFile);
                    break block51;
                }
                long l = 0L;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                Hashtable<Object, TraceThread> hashtable = new Hashtable<Object, TraceThread>();
                outStream.println("*** Starting data extraction from binary file(s) ");
                for (TraceFile this.traceFile : this.traceFiles) {
                    int n5 = this.traceFile.traceFileHeader.getTraceDataStart();
                    n4 = this.traceFile.traceFileHeader.getBufferSize();
                    long l2 = this.traceFile.length();
                    int n6 = this.traceFile.traceFileHeader.traceSection.getTraceType();
                    n2 = (int)(l2 - (long)n5) / n4;
                    n3 += n2;
                    if ((l2 - (long)n5) / (long)n4 >= Integer.MAX_VALUE) {
                        outStream.println("Trace file " + this.traceFile + " contains more than INT_MAX trace buffers, can only process INT_MAX buffers");
                    }
                    if ((l2 - (long)n5) % (long)n4 != 0L) {
                        outStream.println("*** TraceFile is truncated, or corrupted, will ignore some incomplete data at the end, but process everything that is avaiable");
                        this.traceFileIsTruncatedOrCorrupt = true;
                    }
                    if (n2 == 0) {
                        outStream.println("\n\n*** " + this.traceFile + " CONTAINS NO TRACE DATA - skipping file.\n\n");
                        continue;
                    }
                    Util.Debug.println("TP data starts at " + n5 + ", buffer size is " + n4 + ": file contains " + n2 + " buffers.");
                    outStream.println("*** Extracting " + n2 + " buffers from " + this.traceFile);
                    for (n = 0; n < n2; ++n) {
                        TraceThread traceThread;
                        Util.Debug.println("Processing buffer " + n + " at " + (n5 + n * n4));
                        TraceRecord50 traceRecord50 = new TraceRecord50();
                        traceRecord50.setTraceType(n6);
                        Util.Debug.println(" buffer is " + (n6 == 0 ? "internal" : "external"));
                        traceRecord50.processTraceBufferHeader(this.traceFile, n5 + n * n4, n4);
                        object = new Long(traceRecord50.getThreadIDAsLong());
                        if (hashtable.containsKey(object)) {
                            traceThread = (TraceThread)hashtable.get(object);
                            traceThread.add(traceRecord50);
                            continue;
                        }
                        traceThread = new TraceThread((Long)object, traceRecord50.getThreadName());
                        traceThread.addElement(traceRecord50);
                        threads.addElement(traceThread);
                        hashtable.put(object, traceThread);
                    }
                }
                outStream.println("*** Sorting extracted tracepoints");
                if (TraceArgs.summary) {
                    this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
                    return;
                }
                if (this.doSummary(this.out) != 0) {
                    outStream.println("*** Problem printing summary to file - may be incomplete ... continuing");
                }
                Object object3 = System.getProperty("java.home");
                object3 = ((String)object3).concat(File.separator).concat("lib");
                String string = System.getProperty("ibm.dg.trc.format", (String)object3);
                String string6 = this.traceFile.formatFileName();
                outStream.println("*** Loading formatting strings from " + string + File.separator + string6);
                messageFile = new MessageFile(string + File.separator + string6);
                if (!string6.equals("TraceFormat.dat")) {
                    outStream.println("*** Loading further formatting strings from " + string + File.separator + "TraceFormat.dat");
                    messageFileBase = new MessageFile(string + File.separator + "TraceFormat.dat");
                }
                outStream.println("*** Starting formatting of entries into text file " + TraceArgs.outputFile);
                this.out.write(header, 0, header.length());
                this.out.newLine();
                this.out.newLine();
                int n7 = Integer.valueOf(Util.getProperty("POINTER_SIZE"));
                if (userVMIdentifier != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (n = 0; n < userVMIdentifier.length(); ++n) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("  ");
                    headings = n7 == 4 ? stringBuffer + "ThreadID       TP id     Type        TraceEntry " : stringBuffer + "ThreadID               TP id     Type        TraceEntry ";
                } else {
                    headings = n7 == 4 ? "ThreadID       TP id     Type        TraceEntry " : "ThreadID               TP id     Type        TraceEntry ";
                }
                this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
                this.out.newLine();
                TraceThread[] traceThreadArray = new TraceThread[]{};
                TraceThread[] traceThreadArray2 = threads.toArray(traceThreadArray);
                int n8 = traceThreadArray2.length;
                System.out.println("*** Number of traced threads = " + n8);
                object = new BigInteger[n8];
                this.populateTimeStamps(traceThreadArray2, (BigInteger[])object, n8);
                double d = (double)n3 / 10.0;
                int n9 = 0;
                int n10 = 0;
                long l3 = 0L;
                int n11 = 0;
                while ((tracePoint = this.findNextTracePoint(traceThreadArray2, (BigInteger[])object, n8)) != null) {
                    n10 = TraceThread.getBuffersProcessed();
                    StringBuffer stringBuffer = new StringBuffer();
                    if ((double)n10 >= (double)n9 * d) {
                        outStream.print(n9 * 10 + "% ");
                        ++n9;
                    }
                    Util.Debug.println("next tracepoint: " + tracePoint.getComponentName() + "." + tracePoint.getTPID());
                    TraceThread traceThread = this.getCurrentTraceThread(traceThreadArray2);
                    Message message = MessageFile.getMessageFromID(tracePoint.getComponentName(), tracePoint.getTPID());
                    ++n11;
                    long l4 = tracePoint.getThreadID();
                    BigInteger bigInteger = tracePoint.getRawTimeStamp();
                    String string7 = Util.getFormattedTime(bigInteger);
                    tracePoint.setFormattedTime(string7);
                    stringBuffer.append(string7);
                    if (l4 == l3) {
                        stringBuffer.append(" ");
                    } else {
                        stringBuffer.append("*");
                    }
                    l3 = l4;
                    stringBuffer.append(tracePoint.toString() + " ");
                    if (message == null) {
                        Util.Debug.println("No message for tracepoint [" + tracePoint.getComponentName() + "." + tracePoint.getTPID() + "]");
                    } else {
                        int n12 = message.getType();
                        stringBuffer.append(this.types[n12]);
                        if (TraceArgs.indent) {
                            if (n12 == 2 || n12 == 3) {
                                traceThread.indent();
                            }
                            for (int i = 0; i < traceThread.getIndent(); ++i) {
                                stringBuffer.append(" ");
                            }
                            if (n12 == 4 || n12 == 5) {
                                traceThread.outdent();
                            }
                        }
                        byte[] byArray = tracePoint.getParmData();
                        String string8 = null;
                        if (byArray == null) {
                            byArray = new byte[1];
                            try {
                                string8 = message.getMessage(byArray, 0, 0);
                            }
                            catch (Exception exception) {
                                string8 = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
                            }
                        } else {
                            try {
                                string8 = message.getMessage(byArray, 0, byArray.length);
                            }
                            catch (Exception exception) {
                                string8 = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
                            }
                        }
                        stringBuffer.append(string8);
                    }
                    if (this.populateGlobalArray) {
                        this.vectorOfAllTracePoints.add(tracePoint);
                    }
                    this.out.write(stringBuffer.toString());
                    this.out.newLine();
                    this.populateTimeStamps(traceThreadArray2, (BigInteger[])object, n8);
                }
                if (n9 < 11) {
                    outStream.print("... 100%");
                }
                outStream.print("\n");
                outStream.println("*** Number of formatted tracepoints = " + n11);
                if (n10 < n3) {
                    outStream.println("\n" + n10 + "/" + n3 + " buffers processed successfully\n");
                }
                if (this.traceFileIsTruncatedOrCorrupt) {
                    this.out.write(" NOTE - PROBLEMS WERE ENCOUNTERED PROCESSING THE TRACE FILE(S), MOST LIKELY DUE TO TRACE FILE CORRUPTION OR TRUNCATION");
                    this.out.newLine();
                    this.out.write(" THE CONTENT OF THIS FORMATTED FILE COULD THEREFORE BE TRUNCATED OR CORRUPTED ALSO - REFER TO FORMATTER OUTPUT FOR FURTHER DETAILS");
                    this.out.newLine();
                }
                this.out.flush();
                outStream.println("*** Formatting complete");
                outStream.println("*** Formatted output written to file: " + TraceArgs.outputFile);
            }
            catch (Exception exception) {
                exception.printStackTrace(outStream);
            }
        }
    }

    protected int doSummary(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        bufferedWriter.write("                Trace Summary");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        TraceFile traceFile = (TraceFile)this.traceFiles.firstElement();
        traceFile.traceFileHeader.summarize(bufferedWriter);
        bufferedWriter.write("Active Threads :");
        bufferedWriter.newLine();
        for (TraceThread traceThread : threads) {
            bufferedWriter.write("        " + Long.toHexString(traceThread.threadID));
            bufferedWriter.write("  ");
            bufferedWriter.write(traceThread.threadName);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        if ((double)verMod >= 1.1) {
            object2 = lastWritePlatform.subtract(overallStartPlatform);
            object = lastWriteSystem.subtract(overallStartSystem);
            Util.Debug.println("lastWritePlatform:  " + lastWritePlatform);
            Util.Debug.println("overallStartSystem: " + overallStartSystem);
            Util.Debug.println("spanPlatform:       " + object2);
            Util.Debug.println("spanSystem:         " + object);
            timeConversion = ((BigInteger)object2).divide((BigInteger)object);
            Util.Debug.println("timeConversion:         " + timeConversion);
            bufferedWriter.write("JVM started      : " + Util.getFormattedTime(overallStartPlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Last buffer write: " + Util.getFormattedTime(lastWritePlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        object2 = "First tracepoint:  " + Util.getFormattedTime(first);
        object = "Last tracepoint :  " + Util.getFormattedTime(last);
        bufferedWriter.write((String)object2, 0, ((String)object2).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write((String)object, 0, ((String)object).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        return 0;
    }

    static final void setStartSystem(BigInteger bigInteger) {
        if (overallStartSystem.equals(BigInteger.ZERO)) {
            overallStartSystem = bigInteger;
        }
        if (overallStartSystem.compareTo(bigInteger) == -1) {
            overallStartSystem = bigInteger;
        }
    }

    static final void setStartPlatform(BigInteger bigInteger) {
        if (overallStartPlatform.equals(BigInteger.ZERO)) {
            overallStartPlatform = bigInteger;
        }
        if (overallStartPlatform.compareTo(bigInteger) == -1) {
            overallStartPlatform = bigInteger;
        }
    }

    final int getTraceFiles() {
        int n = 36;
        int n2 = TraceArgs.traceFile.indexOf("#");
        if (n2 == -1) {
            try {
                this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile, "r"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                outStream.println("Trace file is missing");
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace(outStream);
                return -1;
            }
        } else {
            int n3 = 0;
            char c = '\u0000';
            for (n3 = 0; n3 < n; ++n3) {
                c = Integer.toString(n3, n).toUpperCase().charAt(0);
                try {
                    this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile.replace('#', c), "r"));
                    continue;
                }
                catch (Exception exception) {
                    Util.Debug.println("TraceFormat: generations found " + n3);
                    break;
                }
            }
            if (n3 == 0) {
                outStream.println("Trace file is missing");
                return -1;
            }
            if (n3 != generations) {
                Util.Debug.println("TraceFormat: generations = " + generations);
                outStream.println("Trace file " + TraceArgs.traceFile.replace('#', c) + " is missing");
            }
            outStream.println("Processing " + (n3 != generations ? Integer.toString(n3) : "all") + " of the " + generations + " generations specified at runtime");
        }
        return 0;
    }

    static final void setGenerations(int n) {
        generations = n;
    }

    public static String getUserVMIdentifier() {
        return userVMIdentifier;
    }

    public Vector getVectorOfAllTracePoints() {
        return this.vectorOfAllTracePoints;
    }

    public void populateGlobalArray(boolean bl) {
        this.populateGlobalArray = bl;
    }

    public boolean populateTimeStamps(TraceThread[] traceThreadArray, BigInteger[] bigIntegerArray, int n) {
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = traceThreadArray[i].getTimeOfNextTracePoint();
        }
        return true;
    }

    public boolean threadsContainUnprocessedTracePoints(BigInteger[] bigIntegerArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (bigIntegerArray[i] == null) continue;
            return true;
        }
        return false;
    }

    public TraceThread getCurrentTraceThread(TraceThread[] traceThreadArray) {
        if (this.tracedThreadWithNewestTracePoint < 0) {
            return null;
        }
        return traceThreadArray[this.tracedThreadWithNewestTracePoint];
    }

    public TracePoint findNextTracePoint(TraceThread[] traceThreadArray, BigInteger[] bigIntegerArray, int n) {
        this.tracedThreadWithNewestTracePoint = 0;
        if (bigIntegerArray.length == 0 || traceThreadArray == null || n == 0) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < n; ++i) {
            if (bigInteger == null) {
                bigInteger = bigIntegerArray[i];
                this.tracedThreadWithNewestTracePoint = i;
                continue;
            }
            if (bigIntegerArray[i] == null || bigInteger.compareTo(bigIntegerArray[i]) <= 0) continue;
            bigInteger = bigIntegerArray[i];
            this.tracedThreadWithNewestTracePoint = i;
        }
        if (bigInteger == null) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        return traceThreadArray[this.tracedThreadWithNewestTracePoint].getNextTracePoint();
    }

    static {
        userVMIdentifier = null;
    }
}

