/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    static final long serialVersionUID = -2034453286688059956L;
    private BigInteger y;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.y = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(DSAPublicKey.b("\u0019pGk\"\u0014pF/F?M\u0012jl\u0019pVj\"\u0003%\u0012") + iOException.getMessage());
        }
    }

    DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPublicKey.a(DSAPublicKey.b("\u0010~Dn,\tzQzp\u0013kK!q\nzQ!F)^bnp\u001brW{g\bLBja"))) : class$java$security$spec$DSAParameterSpec);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(DSAPublicKey.b("3qDnn\u0013{\u0012dg\u0003%\u0012v\"\f~^zgp") + iOException.getMessage());
        }
    }

    public String toString() {
        return DSAPublicKey.b("3]\u007fEA?Y{_QZ[aN\"*jPck\u0019?yj{@\u0015") + this.y.toString() + "\n";
    }

    public void zeroize() {
        this.y = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    static /* synthetic */ Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 122;
                        break;
                    }
                    case 1: {
                        n5 = 31;
                        break;
                    }
                    case 2: {
                        n5 = 50;
                        break;
                    }
                    case 3: {
                        n5 = 15;
                        break;
                    }
                    default: {
                        n5 = 2;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

