/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;

class ESSCertId {
    private static HexDumpEncoder hexDumper = new HexDumpEncoder();
    private byte[] certHash;
    private GeneralNames issuer;
    private SerialNumber serialNumber;

    ESSCertId(DerValue derValue) throws IOException {
        DerInputStream derInputStream = derValue.getData();
        this.certHash = derInputStream.getDerValue().toByteArray();
        if (derInputStream.available() > 0) {
            DerValue derValue2 = derInputStream.getDerValue();
            DerInputStream derInputStream2 = derValue2.getData();
            try {
                this.issuer = new GeneralNames(derInputStream2.getDerValue());
            }
            catch (GeneralNamesException generalNamesException) {
                throw (IOException)new IOException().initCause(generalNamesException);
            }
            this.serialNumber = new SerialNumber(derInputStream2.getDerValue());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n\tCertificate hash (SHA-1):\n");
        if (hexDumper == null) {
            hexDumper = new HexDumpEncoder();
        }
        stringBuffer.append(hexDumper.encode(this.certHash));
        if (this.issuer != null && this.serialNumber != null) {
            stringBuffer.append("\n\tIssuer: " + this.issuer + "\n");
            stringBuffer.append("\t" + this.serialNumber);
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

