/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubjectAlternativeNameExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.SubjectAlternativeName";
    public static final String NAME = "SubjectAlternativeName";
    public static final String SUBJECT_NAME = "subject_name";
    GeneralNames names = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.SubjectAlternativeNameExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.names.encode(derOutputStream);
        }
        catch (GeneralNamesException generalNamesException) {
            if (debug != null) {
                debug.exception(8192L, className, "encodeThis", generalNamesException);
            }
            throw new IOException("SubjectAlternativeName: " + generalNamesException);
        }
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public SubjectAlternativeNameExtension(GeneralNames generalNames) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectAlternativeNameExtension", generalNames);
        }
        this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
        this.critical = false;
        if (generalNames != null) {
            this.names = (GeneralNames)generalNames.clone();
            this.encodeThis();
        } else {
            this.names = generalNames;
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectAlternativeNameExtension");
        }
    }

    public SubjectAlternativeNameExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectAlternativeNameExtension");
        }
        this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
        this.critical = false;
        this.names = new GeneralNames();
        if (debug != null) {
            debug.exit(16384L, className, "SubjectAlternativeNameExtension");
        }
    }

    public SubjectAlternativeNameExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectAlternativeNameExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "SubjectAlternativeNameExtension", "SubjectAlternativeName: Illegal argument type");
            }
            throw new IOException("SubjectAlternativeName: Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getData() == null) {
            this.names = new GeneralNames();
            return;
        }
        try {
            this.names = new GeneralNames(derValue);
        }
        catch (GeneralNamesException generalNamesException) {
            if (debug != null) {
                debug.exception(16384L, className, "SubjectAlternativeNameExtension", generalNamesException);
            }
            throw new IOException("SubjectAlternativeName: " + generalNamesException);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectAlternativeNameExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.names == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        String string = super.toString() + "SubjectAlternativeName [\n" + this.names.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", string);
        }
        return string;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectAlternativeName_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(SUBJECT_NAME)) {
            if (!(object instanceof GeneralNames)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralNames.");
                }
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = object != null ? (GeneralNames)((GeneralNames)object).clone() : (GeneralNames)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(SUBJECT_NAME)) {
            if (this.names != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.names.clone());
                }
                return this.names.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.names);
            }
            return this.names;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(SUBJECT_NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        this.names = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(SUBJECT_NAME);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

