/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.PolicyQualifierInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyInformation
implements Cloneable {
    private ObjectIdentifier certPolicyId;
    private Vector<PolicyQualifierInfo> policyQualifiers;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyInformation";
    private volatile int cachedHashVal = 0;

    public PolicyInformation(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyInformation", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "PolicyInformation");
        }
    }

    public PolicyInformation(ObjectIdentifier objectIdentifier, Vector<PolicyQualifierInfo> vector) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyInformation", objectIdentifier, vector);
        }
        this.certPolicyId = objectIdentifier;
        if (vector != null && vector.size() > 0) {
            Vector<PolicyQualifierInfo> vector2 = new Vector<PolicyQualifierInfo>();
            for (int i = 0; i < vector.size(); ++i) {
                PolicyQualifierInfo policyQualifierInfo = vector.get(i);
                vector2.addElement(policyQualifierInfo);
            }
            this.policyQualifiers = vector2;
        } else {
            this.policyQualifiers = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "PolicyInformation");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            PolicyInformation policyInformation = new PolicyInformation(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", policyInformation);
            }
            return policyInformation;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.certPolicyId);
        if (this.policyQualifiers != null && this.policyQualifiers.size() > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            for (int i = 0; i < this.policyQualifiers.size(); ++i) {
                this.policyQualifiers.elementAt(i).encode(derOutputStream3);
            }
            derOutputStream2.write((byte)48, derOutputStream3);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoding for PolicyInformation.");
            }
            throw new IOException("Invalid encoding for PolicyInformation.");
        }
        this.certPolicyId = derValue.getData().getOID();
        this.policyQualifiers = null;
        if (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "Invalid encoding of PolicyInformation.");
                }
                throw new IOException("Invalid encoding of PolicyInformation.");
            }
            this.policyQualifiers = new Vector();
            while (derValue2.getData().available() != 0) {
                DerValue derValue3 = derValue2.getData().getDerValue();
                PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(derValue3.toByteArray());
                this.policyQualifiers.addElement(policyQualifierInfo);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof PolicyInformation)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((PolicyInformation)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getPolicyIdentifier() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getPolicyIdentifier");
            debug.exit(16384L, (Object)className, "getPolicyIdentifier", this.certPolicyId);
        }
        return this.certPolicyId;
    }

    public Vector getPolicyQualifiers() {
        if (debug != null) {
            debug.entry(16384L, className, "getPolicyQualifiers");
        }
        if (this.policyQualifiers == null || this.policyQualifiers.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPolicyQualifiers_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPolicyQualifiers_2", (Vector)this.policyQualifiers.clone());
        }
        return (Vector)this.policyQualifiers.clone();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "\r\nPolicyInformation: [\r\n\tCertPolicyId: ";
        string = this.certPolicyId != null ? string + this.certPolicyId.toString() : string + "null";
        string = string + "\r\n\tPolicyQualifiers: ";
        string = this.policyQualifiers != null ? string + this.policyQualifiers.toString() : string + "null";
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

