/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyConstraintsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PolicyConstraints";
    public static final String NAME = "PolicyConstraints";
    public static final String REQUIRE = "require";
    public static final String INHIBIT = "inhibit";
    private static final byte TAG_REQUIRE = 0;
    private static final byte TAG_INHIBIT = 1;
    private int require = -1;
    private int inhibit = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyConstraintsExtension";

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.require == -1 && this.inhibit == -1) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.require != -1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.require));
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        if (this.inhibit != -1) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.inhibit));
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream3.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public PolicyConstraintsExtension(int n, int n2) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyConstraintsExtension", new Integer(n), new Integer(n2));
        }
        this.require = n;
        this.inhibit = n2;
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "PolicyConstraintsExtension");
        }
    }

    public PolicyConstraintsExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyConstraintsExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyConstraintsExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyConstraintsExtension", "Sequence tag missing for PolicyConstraint.");
            }
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream derInputStream = derValue.getData();
        while (derInputStream != null && derInputStream.available() != 0) {
            DerValue derValue2 = derInputStream.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.require != -1) {
                    if (debug != null) {
                        debug.text(16384L, className, "PolicyConstraintsExtension", "Duplicate requireExplicitPolicy found in the PolicyConstraintsExtension");
                    }
                    throw new IOException("Duplicate requireExplicitPolicyfound in the PolicyConstraintsExtension");
                }
                derValue2.resetTag((byte)2);
                this.require = derValue2.getInteger().intValue();
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.inhibit != -1) {
                    if (debug != null) {
                        debug.text(16384L, className, "PolicyConstraintsExtension", "Duplicate inhibitPolicyMapping found in the PolicyConstraintsExtension");
                    }
                    throw new IOException("Duplicate inhibitPolicyMappingfound in the PolicyConstraintsExtension");
                }
                derValue2.resetTag((byte)2);
                this.inhibit = derValue2.getInteger().intValue();
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "PolicyConstraintsExtension", "Invalid encoding of PolicyConstraint");
            }
            throw new IOException("Invalid encoding of PolicyConstraint");
        }
        if (debug != null) {
            debug.exit(16384L, className, "PolicyConstraintsExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "PolicyConstraints: [" + "  Require: ";
        string = this.require == -1 ? string + "unspecified;" : string + this.require + ";";
        string = string + "\tInhibit: ";
        string = this.inhibit == -1 ? string + "unspecified" : string + this.inhibit;
        string = string + " ]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyConstraints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Integer)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute value should be of type Integer.");
            }
            throw new IOException("Attribute value should be of type Integer.");
        }
        if (string.equalsIgnoreCase(REQUIRE)) {
            this.require = (Integer)object;
        } else if (string.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = (Integer)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name [" + string + "]" + " not recognized by " + "CertAttrSet:PolicyConstraints.");
            }
            throw new IOException("Attribute name [" + string + "]" + " not recognized by " + "CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(REQUIRE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Integer(this.require));
            }
            return new Integer(this.require);
        }
        if (string.equalsIgnoreCase(INHIBIT)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Integer(this.inhibit));
            }
            return new Integer(this.inhibit);
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(REQUIRE)) {
            this.require = -1;
        } else if (string.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = -1;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:PolicyConstraints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(REQUIRE);
        attributeNameEnumeration.addElement(INHIBIT);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

