/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameConstraintsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted = null;
    private GeneralSubtrees excluded = null;
    private boolean hasMin;
    private boolean hasMax;
    private boolean minMaxValid = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.X509.NameConstraintsExtension";

    private void calcMinMax() throws IOException {
        GeneralSubtree generalSubtree;
        int n;
        this.hasMin = false;
        this.hasMax = false;
        if (this.excluded != null) {
            for (n = 0; n < this.excluded.size(); ++n) {
                generalSubtree = this.excluded.get(n);
                if (generalSubtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (generalSubtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        if (this.permitted != null) {
            for (n = 0; n < this.permitted.size(); ++n) {
                generalSubtree = this.permitted.get(n);
                if (generalSubtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (generalSubtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        this.minMaxValid = true;
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.permitted != null) {
            derOutputStream = new DerOutputStream();
            this.permitted.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.excluded != null) {
            derOutputStream = new DerOutputStream();
            this.excluded.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public NameConstraintsExtension(GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NameConstraintsExtension", generalSubtrees, generalSubtrees2);
        }
        if (generalSubtrees == null && generalSubtrees2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "NameConstraints: Invalid arguments");
            }
            throw new IOException("NameConstraints: Invalid arguments");
        }
        if (generalSubtrees != null) {
            this.permitted = (GeneralSubtrees)generalSubtrees.clone();
        }
        if (generalSubtrees2 != null) {
            this.excluded = (GeneralSubtrees)generalSubtrees2.clone();
        }
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "NameConstraintsExtension");
        }
    }

    public NameConstraintsExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NameConstraintsExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "Invalid encoding for NameConstraintsExtension.");
            }
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        while (derValue.getData() != null && derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                if (this.permitted != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "NameConstraintsExtension", "Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                    }
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                derValue2.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                if (this.excluded != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "NameConstraintsExtension", "Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                    }
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                derValue2.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(derValue2);
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "Invalid encoding of NameConstraintsExtension.");
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "NameConstraintsExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n");
        }
        return super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralSubtrees.");
                }
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)object;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralSubtrees.");
                }
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.permitted);
            }
            return this.permitted;
        }
        if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.excluded);
            }
            return this.excluded;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(PERMITTED_SUBTREES);
        attributeNameEnumeration.addElement(EXCLUDED_SUBTREES);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public void merge(NameConstraintsExtension nameConstraintsExtension) throws IOException {
        if (nameConstraintsExtension == null) {
            return;
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get(EXCLUDED_SUBTREES);
        if (this.excluded == null) {
            this.excluded = generalSubtrees != null ? (GeneralSubtrees)generalSubtrees.clone() : null;
        } else if (generalSubtrees != null) {
            this.excluded.union(generalSubtrees);
        }
        GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get(PERMITTED_SUBTREES);
        if (this.permitted == null) {
            this.permitted = generalSubtrees2 != null ? (GeneralSubtrees)generalSubtrees2.clone() : null;
        } else if (generalSubtrees2 != null && (generalSubtrees = this.permitted.intersect(generalSubtrees2)) != null) {
            if (this.excluded != null) {
                this.excluded.union(generalSubtrees);
            } else {
                this.excluded = (GeneralSubtrees)generalSubtrees.clone();
            }
        }
        if (this.permitted != null) {
            this.permitted.reduce(this.excluded);
        }
        this.encodeThis();
    }

    public boolean verify(GeneralNameInterface generalNameInterface) throws IOException {
        GeneralNameInterface generalNameInterface2;
        Object object;
        int n;
        if (generalNameInterface == null) {
            throw new IOException("name is null");
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            block9: for (n = 0; n < this.excluded.size(); ++n) {
                GeneralSubtree generalSubtree = this.excluded.get(n);
                if (generalSubtree == null || (object = generalSubtree.getBase()) == null || (generalNameInterface2 = ((GeneralName)object).getName()) == null) continue;
                switch (generalNameInterface2.constrains(generalNameInterface)) {
                    case -1: 
                    case 2: 
                    case 3: {
                        continue block9;
                    }
                    case 0: 
                    case 1: {
                        return false;
                    }
                }
            }
        }
        if (this.permitted != null && this.permitted.size() > 0) {
            n = 0;
            block10: for (int i = 0; i < this.permitted.size(); ++i) {
                GeneralNameInterface generalNameInterface3;
                object = this.permitted.get(i);
                if (object == null || (generalNameInterface2 = ((GeneralSubtree)object).getBase()) == null || (generalNameInterface3 = ((GeneralName)generalNameInterface2).getName()) == null) continue;
                switch (generalNameInterface3.constrains(generalNameInterface)) {
                    case -1: {
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        n = 1;
                        continue block10;
                    }
                    case 0: 
                    case 1: {
                        return true;
                    }
                }
            }
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    public boolean verifyRFC822SpecialCase(X500Name x500Name) throws IOException {
        for (AVA aVA : x500Name.allAvas()) {
            RFC822Name rFC822Name;
            String string;
            ObjectIdentifier objectIdentifier = aVA.getObjectIdentifier();
            if (!objectIdentifier.equals(X500Name.emailAddress_oid) || (string = aVA.getValueString()) == null) continue;
            try {
                rFC822Name = new RFC822Name(string);
            }
            catch (IOException iOException) {
                continue;
            }
            if (this.verify(rFC822Name)) continue;
            return false;
        }
        return true;
    }
}

