/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public final class KeyIdentifier {
    private byte[] octetString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.KeyIdentifier";

    public KeyIdentifier(byte[] byArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyIdentifier", (Object)byArray);
        }
        this.octetString = byArray != null ? (byte[])byArray.clone() : byArray;
        if (debug != null) {
            debug.exit(16384L, className, "KeyIdentifier");
        }
    }

    public KeyIdentifier(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyIdentifier", derValue);
        }
        this.octetString = derValue.getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "KeyIdentifier");
        }
    }

    public byte[] getIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getIdentifier");
            debug.exit(16384L, (Object)className, "getIdentifier", (byte[])this.octetString.clone());
        }
        return (byte[])this.octetString.clone();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "KeyIdentifier [\n";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.octetString);
        string = string + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putOctetString(this.octetString);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }
}

