/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;
import java.math.BigInteger;

public final class GeneralSubtree {
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private GeneralName name;
    private int minimum = 0;
    private int maximum = -1;
    private int myhash = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralSubtree";

    public GeneralSubtree(GeneralName generalName, int n, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{generalName, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "GeneralSubtree", objectArray);
        }
        this.name = generalName;
        this.minimum = n;
        this.maximum = n2;
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtree");
        }
    }

    public GeneralSubtree(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSubtree", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralSubtree", "Invalid encoding for GeneralSubtree.");
            }
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(derValue.getData().getDerValue());
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)2);
                this.minimum = derValue2.getInteger().intValue();
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)2);
                this.maximum = derValue2.getInteger().intValue();
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "GeneralSubtree", "Invalid encoding of GeneralSubtree.");
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtree");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "\n   GeneralSubtree: [\n    GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n    Minimum: " + this.minimum;
        string = this.maximum == -1 ? string + "\t    Maximum: undefined" : string + "\t    Maximum: " + this.maximum;
        string = string + "    ]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralSubtree)) {
            return false;
        }
        GeneralSubtree generalSubtree = (GeneralSubtree)object;
        if (this.name == null ? generalSubtree.name != null : !this.name.equals(generalSubtree.name)) {
            return false;
        }
        if (this.minimum != generalSubtree.minimum) {
            return false;
        }
        return this.maximum == generalSubtree.maximum;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 17;
            if (this.name != null) {
                this.myhash = 37 * this.myhash + this.name.hashCode();
            }
            if (this.minimum != 0) {
                this.myhash = 37 * this.myhash + this.minimum;
            }
            if (this.maximum != -1) {
                this.myhash = 37 * this.myhash + this.maximum;
            }
        }
        return this.myhash;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        this.name.encode(derOutputStream3);
        if (this.minimum != 0) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.minimum));
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream2);
        }
        if (this.maximum != -1) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.maximum));
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public GeneralName getBase() {
        if (debug != null) {
            debug.entry(16384L, className, "getBase");
            debug.exit(16384L, (Object)className, "getBase", this.name);
        }
        return this.name;
    }

    public int getMinimum() {
        if (debug != null) {
            debug.entry(16384L, className, "getMinimum");
            debug.exit(16384L, (Object)className, "getMinimum", this.minimum);
        }
        return this.minimum;
    }

    public int getMaximum() {
        if (debug != null) {
            debug.entry(16384L, className, "getMaximum");
            debug.exit(16384L, (Object)className, "getMaximum", this.maximum);
        }
        return this.maximum;
    }
}

