/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificatePolicyId;
import java.io.IOException;

public final class CertificatePolicyMap {
    private CertificatePolicyId issuerDomain;
    private CertificatePolicyId subjectDomain;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificatePolicyMap";

    public CertificatePolicyMap(CertificatePolicyId certificatePolicyId, CertificatePolicyId certificatePolicyId2) {
        if (debug != null) {
            debug.entry(16384L, className, "CertificatePolicyMap", certificatePolicyId, certificatePolicyId2);
            debug.exit(16384L, className, "CertificatePolicyMap");
        }
        this.issuerDomain = certificatePolicyId;
        this.subjectDomain = certificatePolicyId2;
    }

    public CertificatePolicyMap(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePolicyMap", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "CertificatePolicyMap", "Invalid encoding for CertificatePolicyMap");
            }
            throw new IOException("Invalid encoding for CertificatePolicyMap");
        }
        this.issuerDomain = new CertificatePolicyId(derValue.getData().getDerValue());
        this.subjectDomain = new CertificatePolicyId(derValue.getData().getDerValue());
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePolicyMap");
        }
    }

    public CertificatePolicyId getIssuerIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuerIdentifier");
            debug.exit(16384L, (Object)className, "getIssuerIdentifier", this.issuerDomain);
        }
        return this.issuerDomain;
    }

    public CertificatePolicyId getSubjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectIdentifier");
            debug.exit(16384L, (Object)className, "getSubjectIdentifier", this.subjectDomain);
        }
        return this.subjectDomain;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "CertificatePolicyMap: [\nIssuerDomain:" + this.issuerDomain.toString() + "SubjectDomain:" + this.subjectDomain.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.issuerDomain.encode(derOutputStream2);
        this.subjectDomain.encode(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }
}

