/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CRLReasonCodeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "CRLReasonCode";
    public static final String REASON = "reason";
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFLIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private int reasonCode = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CRLReasonCodeExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encodeThis");
        }
        if (this.reasonCode == -1) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(16384L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putEnumerated(BigInteger.valueOf(this.reasonCode));
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "encodeThis_2");
        }
    }

    public CRLReasonCodeExtension(int n) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CRLReasonCodeExtension", new Integer(n));
        }
        if (n > 10 || n == 7 || n < 0) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal reason code specified");
            }
            throw new IOException("Illegal reason code specified");
        }
        this.reasonCode = n;
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLReasonCodeExtension");
        }
    }

    public CRLReasonCodeExtension(boolean bl, int n) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLReasonCodeExtension", new Boolean(bl), new Integer(n));
        }
        if (n > 10 || n == 7 || n < 0) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal reason code specified");
            }
            throw new IOException("Illegal reason code specified");
        }
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = bl;
        this.reasonCode = n;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CRLReasonCodeExtension");
        }
    }

    public CRLReasonCodeExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CRLReasonCodeExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.reasonCode = derValue.getEnumerated().intValue();
        if (this.reasonCode > 10 || this.reasonCode == 7 || this.reasonCode < 0) {
            if (debug != null) {
                debug.text(16384L, className, "CRLReasonCodeExtension", "Illegal reason code parsed");
            }
            throw new IOException("Illegal reason code parsed");
        }
        if (debug != null) {
            debug.exit(16384L, className, "CRLReasonCodeExtension");
        }
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Integer)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Integer.");
            }
            throw new IOException("Attribute must be of type Integer.");
        }
        if (string.equalsIgnoreCase(REASON)) {
            this.reasonCode = (Integer)object;
            if (this.reasonCode > 10 || this.reasonCode == 7 || this.reasonCode < 0) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Illegal reason code specified");
                }
                throw new IOException("Illegal reason code specified");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Name not supported by CRLReasonCodeExtension");
            }
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(REASON)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", new Integer(this.reasonCode));
            }
            return new Integer(this.reasonCode);
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Name not supported by CRLReasonCodeExtension");
        }
        throw new IOException("Name not supported by CRLReasonCodeExtension");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(REASON)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Name not supported by CRLReasonCodeExtension");
            }
            throw new IOException("Name not supported by CRLReasonCodeExtension");
        }
        this.reasonCode = -1;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "    Reason Code: ";
        switch (this.reasonCode) {
            case 0: {
                string = string + "Unspecified";
                break;
            }
            case 1: {
                string = string + "Key Compromise";
                break;
            }
            case 2: {
                string = string + "CA Compromise";
                break;
            }
            case 3: {
                string = string + "Affiliation Changed";
                break;
            }
            case 4: {
                string = string + "Superseded";
                break;
            }
            case 5: {
                string = string + "Cessation Of Operation";
                break;
            }
            case 6: {
                string = string + "Certificate Hold";
                break;
            }
            case 8: {
                string = string + "Remove from CRL";
                break;
            }
            case 9: {
                string = string + "Privilege Withdrawn";
                break;
            }
            case 10: {
                string = string + "AA Compromise";
                break;
            }
            default: {
                string = string + "Unrecognized reason code";
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ReasonCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(REASON);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

